/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.jpa;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.kie.internal.runtime.error.ExecutionError;

@Entity
@Table(name="ExecutionErrorInfo")
@SequenceGenerator(name="execErrorInfoIdSeq", sequenceName="EXEC_ERROR_INFO_ID_SEQ", allocationSize=1)
public class ExecutionErrorInfo
extends ExecutionError
implements Serializable {
    private static final long serialVersionUID = 6669858787722894023L;
    private Long id;

    public ExecutionErrorInfo() {
    }

    public ExecutionErrorInfo(String errorId, String type, String deploymentId, Long processInstanceId, String processId, Long activityId, String activityName, Long jobId, String errorMessage, String error, Date errorDate, Long initActivityId) {
        this.errorId = errorId;
        this.type = type;
        this.deploymentId = deploymentId;
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.activityId = activityId;
        this.activityName = activityName;
        this.jobId = jobId;
        this.errorMessage = errorMessage;
        this.error = error;
        this.errorDate = errorDate;
        this.acknowledged = new Short("0");
        this.initActivityId = initActivityId;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="execErrorInfoIdSeq")
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="ERROR_ID")
    public String getErrorId() {
        return this.errorId;
    }

    @Column(name="ERROR_TYPE")
    public String getType() {
        return super.getType();
    }

    @Column(name="DEPLOYMENT_ID")
    public String getDeploymentId() {
        return super.getDeploymentId();
    }

    @Column(name="PROCESS_INST_ID")
    public Long getProcessInstanceId() {
        return super.getProcessInstanceId();
    }

    @Column(name="ACTIVITY_ID")
    public Long getActivityId() {
        return super.getActivityId();
    }

    @Column(name="ERROR_MSG")
    public String getErrorMessage() {
        return super.getErrorMessage();
    }

    @Lob
    @Column(name="ERROR_INFO", length=65535)
    public String getError() {
        return super.getError();
    }

    @Column(name="ERROR_ACK")
    protected Short getAcknowledged() {
        return super.getAcknowledged();
    }

    @Column(name="ERROR_ACK_BY")
    public String getAcknowledgedBy() {
        return super.getAcknowledgedBy();
    }

    @Column(name="ERROR_ACK_AT")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getAcknowledgedAt() {
        return super.getAcknowledgedAt();
    }

    @Column(name="PROCESS_ID")
    public String getProcessId() {
        return super.getProcessId();
    }

    @Column(name="ACTIVITY_NAME")
    public String getActivityName() {
        return super.getActivityName();
    }

    @Column(name="ERROR_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getErrorDate() {
        return super.getErrorDate();
    }

    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }

    @Column(name="JOB_ID")
    public Long getJobId() {
        return super.getJobId();
    }

    @Column(name="INIT_ACTIVITY_ID")
    public Long getInitActivityId() {
        return super.getInitActivityId();
    }

    public String toString() {
        return "ExecutionErrorInfo [errorId=" + this.errorId + ", type=" + this.type + ", deploymentId=" + this.deploymentId + ", processInstanceId=" + this.processInstanceId + ", initActivityId=" + this.initActivityId + ", processId=" + this.processId + ", activityId=" + this.activityId + ", activityName=" + this.activityName + ", errorMessage=" + this.errorMessage + ", acknowledged=" + this.acknowledged + "]";
    }
}

