/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;

public class DMNMessageImpl
implements DMNMessage {
    private DMNMessage.Severity severity;
    private String message;
    private DMNMessageType messageType;
    private DMNModelInstrumentedBase source;
    private Throwable exception;
    private FEELEvent feelEvent;

    public DMNMessageImpl() {
    }

    public DMNMessageImpl(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source) {
        this(severity, message, messageType, source, (Throwable)null);
    }

    public DMNMessageImpl(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, Throwable exception) {
        this.severity = severity;
        this.message = message;
        this.messageType = messageType;
        this.source = source;
        this.exception = exception;
    }

    public DMNMessageImpl(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, FEELEvent feelEvent) {
        this.severity = severity;
        this.message = message;
        this.messageType = messageType;
        this.source = source;
        this.feelEvent = feelEvent;
    }

    public DMNMessage.Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public DMNMessageType getMessageType() {
        return this.messageType;
    }

    public String getSourceId() {
        return this.source != null && this.source instanceof DMNElement ? ((DMNElement)this.source).getId() : null;
    }

    public Object getSourceReference() {
        return this.source;
    }

    public Throwable getException() {
        return this.exception;
    }

    public FEELEvent getFeelEvent() {
        return this.feelEvent;
    }

    public String toString() {
        return "DMNMessage{ severity=" + this.severity + ", type=" + this.messageType + ", message='" + (this.message != null ? this.message : "") + '\'' + ", sourceId='" + this.getSourceId() + '\'' + ", exception='" + (this.exception != null ? this.exception.getClass().getSimpleName() + " : " + this.exception.getMessage() : "") + "', feelEvent='" + (this.feelEvent != null ? this.feelEvent.getClass().getSimpleName() + " : " + this.feelEvent.getMessage() : "") + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DMNMessageImpl)) {
            return false;
        }
        DMNMessageImpl that = (DMNMessageImpl)o;
        if (this.severity != that.severity) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.messageType != null ? !this.messageType.equals((Object)that.messageType) : that.messageType != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.exception != null ? !this.exception.equals(that.exception) : that.exception != null) {
            return false;
        }
        return this.feelEvent != null ? this.feelEvent.equals(that.feelEvent) : that.feelEvent == null;
    }

    public int hashCode() {
        int result = this.severity != null ? this.severity.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.messageType != null ? this.messageType.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 31 * result + (this.feelEvent != null ? this.feelEvent.hashCode() : 0);
        return result;
    }
}

