/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.base.field.ObjectFieldImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.IntervalProviderConstraint;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PatternExtractor;
import org.drools.core.spi.Tuple;
import org.drools.core.time.Interval;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.IndexUtil;
import org.drools.model.AlphaIndex;
import org.drools.model.BetaIndex;
import org.drools.model.Index;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;

public class LambdaConstraint
extends MutableTypeConstraint
implements IndexableConstraint,
IntervalProviderConstraint {
    private final ConstraintEvaluator evaluator;
    private FieldValue field;
    private InternalReadAccessor readAccessor;
    private Declaration indexingDeclaration;

    public LambdaConstraint(ConstraintEvaluator evaluator) {
        this.evaluator = evaluator;
        this.initIndexes();
    }

    private void initIndexes() {
        Index index = this.evaluator.getIndex();
        if (index != null) {
            this.readAccessor = new LambdaReadAccessor(index.getIndexId(), index.getIndexedClass(), index.getLeftOperandExtractor());
            if (index instanceof AlphaIndex) {
                this.field = new ObjectFieldImpl(((AlphaIndex)index).getRightValue());
            } else if (index instanceof BetaIndex) {
                this.indexingDeclaration = this.evaluator.getRequiredDeclarations()[0];
                if (this.indexingDeclaration.getExtractor() instanceof PatternExtractor) {
                    this.indexingDeclaration = this.indexingDeclaration.clone();
                    this.indexingDeclaration.setReadAccessor((InternalReadAccessor)new LambdaReadAccessor(index.getIndexId(), index.getIndexedClass(), ((BetaIndex)index).getRightOperandExtractor()));
                }
            }
        }
    }

    public String toString() {
        return this.evaluator.toString();
    }

    public Declaration[] getRequiredDeclarations() {
        return this.evaluator.getRequiredDeclarations();
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        this.evaluator.replaceDeclaration(oldDecl, newDecl);
    }

    public BitMask getListenedPropertyMask(Class modifiedClass, List<String> settableProperties) {
        if (this.evaluator.getReactiveProps() == null) {
            return super.getListenedPropertyMask(modifiedClass, settableProperties);
        }
        BitMask mask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
        for (String prop : this.evaluator.getReactiveProps()) {
            int pos = settableProperties.indexOf(prop);
            if (pos < 0) continue;
            mask = mask.set(pos + 1);
        }
        return mask;
    }

    public LambdaConstraint clone() {
        LambdaConstraint clone = new LambdaConstraint(this.evaluator.clone());
        clone.field = this.field;
        clone.readAccessor = this.readAccessor;
        return clone;
    }

    public boolean isTemporal() {
        return this.evaluator.isTemporal();
    }

    public Interval getInterval() {
        return this.evaluator.getInterval();
    }

    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        return this.evaluator.evaluate(handle, workingMemory);
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        LambdaContextEntry lambdaContext = (LambdaContextEntry)context;
        return this.evaluator.evaluate(handle, lambdaContext.getTuple(), lambdaContext.getWorkingMemory());
    }

    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        LambdaContextEntry lambdaContext = (LambdaContextEntry)context;
        return this.evaluator.evaluate(lambdaContext.getHandle(), tuple, lambdaContext.getWorkingMemory());
    }

    public ContextEntry createContextEntry() {
        return new LambdaContextEntry();
    }

    public boolean isUnification() {
        return false;
    }

    public boolean isIndexable(short nodeType) {
        return this.getConstraintType().isIndexableForNode(nodeType);
    }

    public IndexUtil.ConstraintType getConstraintType() {
        Index index = this.evaluator.getIndex();
        if (index != null) {
            switch (index.getConstraintType()) {
                case EQUAL: {
                    return IndexUtil.ConstraintType.EQUAL;
                }
                case NOT_EQUAL: {
                    return IndexUtil.ConstraintType.NOT_EQUAL;
                }
                case GREATER_THAN: {
                    return IndexUtil.ConstraintType.GREATER_THAN;
                }
                case GREATER_OR_EQUAL: {
                    return IndexUtil.ConstraintType.GREATER_OR_EQUAL;
                }
                case LESS_THAN: {
                    return IndexUtil.ConstraintType.LESS_THAN;
                }
                case LESS_OR_EQUAL: {
                    return IndexUtil.ConstraintType.LESS_OR_EQUAL;
                }
                case RANGE: {
                    return IndexUtil.ConstraintType.RANGE;
                }
            }
        }
        return IndexUtil.ConstraintType.UNKNOWN;
    }

    public FieldValue getField() {
        return this.field;
    }

    public AbstractHashTable.FieldIndex getFieldIndex() {
        return new AbstractHashTable.FieldIndex(this.readAccessor, this.indexingDeclaration, MvelConstraint.INDEX_EVALUATOR);
    }

    public InternalReadAccessor getFieldExtractor() {
        return this.readAccessor;
    }

    public boolean equals(Object other) {
        return this == other || other != null && ((Object)((Object)this)).getClass() == other.getClass() && this.evaluator.equals(((LambdaConstraint)((Object)other)).evaluator);
    }

    public int hashCode() {
        return this.evaluator.hashCode();
    }

    public static class LambdaContextEntry
    implements ContextEntry {
        private Tuple tuple;
        private InternalFactHandle handle;
        private transient InternalWorkingMemory workingMemory;

        public void updateFromTuple(InternalWorkingMemory workingMemory, Tuple tuple) {
            this.tuple = tuple;
            this.workingMemory = workingMemory;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.handle = handle;
        }

        public void resetTuple() {
            this.tuple = null;
        }

        public void resetFactHandle() {
            this.workingMemory = null;
            this.handle = null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tuple);
            out.writeObject(this.handle);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tuple = (Tuple)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public InternalFactHandle getHandle() {
            return this.handle;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }

        public ContextEntry getNext() {
            throw new UnsupportedOperationException();
        }

        public void setNext(ContextEntry entry) {
            throw new UnsupportedOperationException();
        }
    }
}

