/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.ArrayList;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.ast.DMNDecisionServiceFunctionDefinitionEvaluator;
import org.kie.dmn.core.ast.DMNFunctionDefinitionEvaluator;
import org.kie.dmn.core.ast.DecisionServiceNodeImpl;
import org.kie.dmn.core.compiler.CoerceDecisionServiceSingletonOutputOption;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.v1_1.DMNElementReference;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.DecisionService;
import org.kie.dmn.model.v1_1.NamedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionServiceCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionServiceCompiler.class);

    public void compileNode(DecisionService drge, DMNCompilerImpl compiler, DMNModelImpl model) {
        DecisionService ds = drge;
        DMNType type = null;
        if (ds.getVariable() == null) {
            DMNCompilerHelper.reportMissingVariable(model, (NamedElement)drge, (DMNModelInstrumentedBase)ds, Msg.MISSING_VARIABLE_FOR_DS);
            return;
        }
        DMNCompilerHelper.checkVariableName(model, (NamedElement)ds, ds.getName());
        type = ds.getVariable() != null && ds.getVariable().getTypeRef() != null ? compiler.resolveTypeRef(model, (NamedElement)ds, (DMNModelInstrumentedBase)ds.getVariable(), ds.getVariable().getTypeRef()) : compiler.resolveTypeRef(model, (NamedElement)ds, (DMNModelInstrumentedBase)ds, null);
        DecisionServiceNodeImpl bkmn = new DecisionServiceNodeImpl(ds, type);
        model.addDecisionService(bkmn);
    }

    public boolean accept(DMNNode node) {
        return node instanceof DecisionServiceNodeImpl;
    }

    public void compileEvaluator(DMNNode node, DMNCompilerImpl compiler, DMNCompilerContext ctx, DMNModelImpl model) {
        InputDataNode input;
        String id;
        DecisionServiceNodeImpl ni = (DecisionServiceNodeImpl)node;
        ArrayList<DMNFunctionDefinitionEvaluator.FormalParameter> parameters = new ArrayList<DMNFunctionDefinitionEvaluator.FormalParameter>();
        for (DMNElementReference er : ni.getDecisionService().getInputData()) {
            id = DMNCompilerImpl.getId(er);
            input = model.getInputById(id);
            if (input != null) {
                ni.addInputParameter(input.getName(), (DMNNode)input);
                parameters.add(new DMNFunctionDefinitionEvaluator.FormalParameter(input.getName(), input.getType()));
                continue;
            }
            MsgUtil.reportMessage(LOG, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ni.getDecisionService(), model, null, null, Msg.REFERENCE_NOT_FOUND_FOR_DS, id, node.getName());
        }
        for (DMNElementReference er : ni.getDecisionService().getInputDecision()) {
            id = DMNCompilerImpl.getId(er);
            input = model.getDecisionById(id);
            if (input != null) {
                ni.addInputParameter(input.getName(), (DMNNode)input);
                parameters.add(new DMNFunctionDefinitionEvaluator.FormalParameter(input.getName(), input.getResultType()));
                continue;
            }
            MsgUtil.reportMessage(LOG, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ni.getDecisionService(), model, null, null, Msg.REFERENCE_NOT_FOUND_FOR_DS, id, node.getName());
        }
        for (DMNElementReference er : ni.getDecisionService().getEncapsulatedDecision()) {
            id = DMNCompilerImpl.getId(er);
            input = model.getDecisionById(id);
            if (input != null) continue;
            MsgUtil.reportMessage(LOG, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ni.getDecisionService(), model, null, null, Msg.REFERENCE_NOT_FOUND_FOR_DS, id, node.getName());
        }
        for (DMNElementReference er : ni.getDecisionService().getOutputDecision()) {
            id = DMNCompilerImpl.getId(er);
            input = model.getDecisionById(id);
            if (input != null) continue;
            MsgUtil.reportMessage(LOG, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ni.getDecisionService(), model, null, null, Msg.REFERENCE_NOT_FOUND_FOR_DS, id, node.getName());
        }
        boolean coerceSingleton = ((DMNCompilerConfigurationImpl)compiler.getDmnCompilerConfig()).getOption(CoerceDecisionServiceSingletonOutputOption.class).isCoerceSingleton();
        DMNDecisionServiceFunctionDefinitionEvaluator exprEvaluator = new DMNDecisionServiceFunctionDefinitionEvaluator(ni, parameters, coerceSingleton);
        ni.setEvaluator(exprEvaluator);
    }
}

