/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.Argument;
import org.drools.model.Binding;
import org.drools.model.Condition;
import org.drools.model.ConditionalConsequence;
import org.drools.model.Consequence;
import org.drools.model.Declaration;
import org.drools.model.DeclarationSource;
import org.drools.model.FlowDSL;
import org.drools.model.From;
import org.drools.model.Pattern;
import org.drools.model.RuleItem;
import org.drools.model.RuleItemBuilder;
import org.drools.model.SingleConstraint;
import org.drools.model.Variable;
import org.drools.model.consequences.ConditionalNamedConsequenceImpl;
import org.drools.model.consequences.NamedConsequenceImpl;
import org.drools.model.constraints.OrConstraints;
import org.drools.model.constraints.SingleConstraint1;
import org.drools.model.constraints.SingleConstraint10;
import org.drools.model.constraints.SingleConstraint11;
import org.drools.model.constraints.SingleConstraint12;
import org.drools.model.constraints.SingleConstraint13;
import org.drools.model.constraints.SingleConstraint2;
import org.drools.model.constraints.SingleConstraint3;
import org.drools.model.constraints.SingleConstraint4;
import org.drools.model.constraints.SingleConstraint5;
import org.drools.model.constraints.SingleConstraint6;
import org.drools.model.constraints.SingleConstraint7;
import org.drools.model.constraints.SingleConstraint8;
import org.drools.model.constraints.SingleConstraint9;
import org.drools.model.constraints.TemporalConstraint;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.impl.NamesGenerator;
import org.drools.model.impl.ViewBuilder;
import org.drools.model.patterns.AccumulatePatternImpl;
import org.drools.model.patterns.CompositePatterns;
import org.drools.model.patterns.EvalImpl;
import org.drools.model.patterns.ExistentialPatternImpl;
import org.drools.model.patterns.PatternImpl;
import org.drools.model.patterns.QueryCallPattern;
import org.drools.model.view.AbstractExprViewItem;
import org.drools.model.view.AccumulateExprViewItem;
import org.drools.model.view.CombinedExprViewItem;
import org.drools.model.view.ExistentialExprViewItem;
import org.drools.model.view.Expr10ViewItemImpl;
import org.drools.model.view.Expr11ViewItemImpl;
import org.drools.model.view.Expr12ViewItemImpl;
import org.drools.model.view.Expr13ViewItemImpl;
import org.drools.model.view.Expr1ViewItemImpl;
import org.drools.model.view.Expr2ViewItemImpl;
import org.drools.model.view.Expr3ViewItemImpl;
import org.drools.model.view.Expr4ViewItemImpl;
import org.drools.model.view.Expr5ViewItemImpl;
import org.drools.model.view.Expr6ViewItemImpl;
import org.drools.model.view.Expr7ViewItemImpl;
import org.drools.model.view.Expr8ViewItemImpl;
import org.drools.model.view.Expr9ViewItemImpl;
import org.drools.model.view.ExprNViewItem;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.FixedValueItem;
import org.drools.model.view.InputViewItem;
import org.drools.model.view.InputViewItemImpl;
import org.drools.model.view.QueryCallViewItem;
import org.drools.model.view.TemporalExprViewItem;
import org.drools.model.view.ViewItem;

public class ViewFlowBuilder
implements ViewBuilder {
    ViewFlowBuilder() {
    }

    @Override
    public CompositePatterns apply(RuleItemBuilder<?>[] viewItemBuilders) {
        BuildContext ctx = new BuildContext(viewItemBuilders);
        return ViewFlowBuilder.ensureVariablesDeclarationInView(ViewFlowBuilder.viewItems2Condition(ctx, Condition.Type.AND, true), ctx);
    }

    private static CompositePatterns ensureVariablesDeclarationInView(CompositePatterns view, BuildContext ctx) {
        ctx.inputs.keySet().removeAll(ctx.usedVars);
        int i = 0;
        for (Map.Entry<Variable<?>, InputViewItemImpl<?>> entry : ctx.inputs.entrySet()) {
            view.addCondition(i++, new PatternImpl(entry.getKey()));
            ctx.usedVars.add(entry.getKey());
        }
        view.ensureVariablesDeclarationInView();
        view.getSubConditions().sort(ConditionComparator.INSTANCE);
        return view;
    }

    private static CompositePatterns viewItems2Condition(BuildContext ctx, Condition.Type type, boolean topLevel) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        HashMap conditionMap = new HashMap();
        LinkedHashMap<String, Consequence> consequences = topLevel ? new LinkedHashMap<String, Consequence>() : null;
        Iterator<RuleItem> ruleItemIterator = ctx.ruleItems.iterator();
        while (ruleItemIterator.hasNext()) {
            Object condition;
            Map<Variable<?>, InputViewItemImpl<?>> scopedInputs = type.createsScope() ? new LinkedHashMap(ctx.inputs) : ctx.inputs;
            RuleItem ruleItem = ruleItemIterator.next();
            if (topLevel && ruleItem instanceof AbstractExprViewItem && ((AbstractExprViewItem)ruleItem).isQueryExpression()) {
                ctx.isQuery = true;
            }
            if (ruleItem instanceof FixedValueItem) {
                conditions.add(new EvalImpl(((FixedValueItem)ruleItem).isValue()));
                continue;
            }
            if (ruleItem instanceof Consequence) {
                if (!topLevel) {
                    throw new IllegalStateException("A consequence can be only a top level item");
                }
                Consequence consequence = (Consequence)ruleItem;
                String name = ruleItemIterator.hasNext() ? NamesGenerator.generateName("consequence") : "default";
                consequences.put(name, consequence);
                conditions.add(new NamedConsequenceImpl(name, consequence.isBreaking()));
                continue;
            }
            if (ruleItem instanceof ConditionalConsequence) {
                if (!topLevel) {
                    throw new IllegalStateException("A consequence can be only a top level item");
                }
                conditions.add(ViewFlowBuilder.createConditionalNamedConsequence(consequences, (ConditionalConsequence)ruleItem));
                continue;
            }
            ViewItem viewItem = (ViewItem)ruleItem;
            if (viewItem instanceof CombinedExprViewItem) {
                CombinedExprViewItem combined = (CombinedExprViewItem)viewItem;
                if (combined.getType() == Condition.Type.OR && (condition = (Condition)conditionMap.get(combined.getFirstVariable())) instanceof PatternImpl) {
                    PatternImpl pattern = (PatternImpl)condition;
                    PatternImpl orPattern = new PatternImpl(pattern.getPatternVariable());
                    for (ViewItem expr : combined.getExpressions()) {
                        orPattern = (PatternImpl)ViewFlowBuilder.viewItem2Condition(expr, orPattern, ctx);
                    }
                    pattern.addConstraint(new OrConstraints(orPattern.getConstraint().getChildren()));
                    continue;
                }
                conditions.add(ViewFlowBuilder.viewItems2Condition(new BuildContext(ctx, combined.getExpressions(), scopedInputs), combined.getType(), false));
                continue;
            }
            if (viewItem instanceof QueryCallViewItem) {
                QueryCallViewItem query = (QueryCallViewItem)viewItem;
                condition = query.getArguments();
                int pattern = ((Argument<?>[])condition).length;
                for (int orPattern = 0; orPattern < pattern; ++orPattern) {
                    Argument<?> arg = condition[orPattern];
                    if (!(arg instanceof Variable)) continue;
                    ctx.usedVars.add((Variable)arg);
                    ctx.boundVars.add((Variable)arg);
                }
                conditions.add(new QueryCallPattern(query));
                continue;
            }
            if (viewItem instanceof Binding) {
                Binding bindViewItem = (Binding)((Object)viewItem);
                PatternImpl pattern = (PatternImpl)conditionMap.get(bindViewItem.getInputVariable());
                if (pattern == null) {
                    pattern = new PatternImpl(bindViewItem.getInputVariable());
                    pattern.addWatchedProps(bindViewItem.getWatchedProps());
                    ctx.usedVars.add(bindViewItem.getInputVariable());
                    conditions.add(pattern);
                    conditionMap.put(bindViewItem.getInputVariable(), pattern);
                }
                pattern.addBinding(bindViewItem);
                ctx.usedVars.add(viewItem.getFirstVariable());
                ctx.addBinding(bindViewItem);
                scopedInputs.putIfAbsent(viewItem.getFirstVariable(), (InputViewItemImpl)FlowDSL.input(viewItem.getFirstVariable()));
                continue;
            }
            Variable<?> patterVariable = ViewFlowBuilder.findPatterVariable(viewItem, scopedInputs.keySet());
            if (viewItem instanceof InputViewItemImpl) {
                scopedInputs.put(patterVariable, (InputViewItemImpl)viewItem);
                condition = new PatternImpl(patterVariable);
                ((PatternImpl)condition).addWatchedProps(((InputViewItemImpl)viewItem).getWatchedProps());
                conditions.add((Condition)condition);
                conditionMap.put(patterVariable, (Condition)condition);
                ctx.usedVars.add(patterVariable);
                continue;
            }
            if (viewItem instanceof ExistentialExprViewItem) {
                ExistentialExprViewItem existential = (ExistentialExprViewItem)viewItem;
                if (patterVariable != null && !ctx.isQuery) {
                    ViewFlowBuilder.registerInputsFromViewItem(existential.getExpression(), conditionMap, scopedInputs, patterVariable);
                }
                PatternImpl condition2 = new PatternImpl(patterVariable, SingleConstraint.TRUE, ctx.bindings.get(patterVariable));
                Condition.Type existentialType = existential.getType();
                ViewItem existentialExpr = existential.getExpression();
                while (existentialExpr instanceof ExistentialExprViewItem) {
                    existentialExpr = ((ExistentialExprViewItem)existentialExpr).getExpression();
                }
                conditions.add(new ExistentialPatternImpl(ViewFlowBuilder.viewItem2Condition(existentialExpr, condition2, ctx), existentialType));
                continue;
            }
            if (ruleItem instanceof ExprViewItem && ctx.boundVars.contains(patterVariable)) {
                conditions.add(new EvalImpl(ViewFlowBuilder.createConstraint((ExprViewItem)ruleItem)));
                continue;
            }
            ctx.usedVars.add(patterVariable);
            if (type == Condition.Type.AND) {
                condition = (Condition)conditionMap.get(patterVariable);
                if (condition == null) {
                    condition = new PatternImpl(patterVariable, SingleConstraint.TRUE, ctx.bindings.get(patterVariable));
                    conditions.add((Condition)condition);
                    if (!(viewItem instanceof AccumulateExprViewItem)) {
                        conditionMap.put(patterVariable, (Condition)condition);
                    }
                    scopedInputs.putIfAbsent(patterVariable, (InputViewItemImpl)FlowDSL.input(patterVariable));
                }
            } else {
                condition = new PatternImpl(patterVariable);
                conditions.add((Condition)condition);
            }
            ViewFlowBuilder.addInputFromVariableSource(scopedInputs, patterVariable);
            Condition modifiedPattern = ViewFlowBuilder.viewItem2Condition(viewItem, (Condition)condition, new BuildContext(ctx, scopedInputs));
            conditions.set(conditions.indexOf(condition), modifiedPattern);
            if (!ctx.isQuery) {
                ViewFlowBuilder.registerInputsFromViewItem(viewItem, conditionMap, scopedInputs, null);
            }
            if (type != Condition.Type.AND || viewItem instanceof AccumulateExprViewItem) continue;
            conditionMap.put(patterVariable, modifiedPattern);
        }
        return new CompositePatterns(type, conditions, ctx.usedVars, consequences);
    }

    private static void registerInputsFromViewItem(ViewItem viewItem, Map<Variable<?>, Condition> conditionMap, Map<Variable<?>, InputViewItemImpl<?>> scopedInputs, Variable<?> existentialVar) {
        for (Variable<?> var : viewItem.getVariables()) {
            if (!var.isFact() || conditionMap.containsKey(var) || var == existentialVar) continue;
            scopedInputs.putIfAbsent(var, (InputViewItemImpl)FlowDSL.input(var));
        }
    }

    private static Variable<?> findPatterVariable(ViewItem viewItem, Set<Variable<?>> vars) {
        Variable<Object> patternVariable = viewItem.getFirstVariable();
        if (!vars.contains(patternVariable)) {
            return patternVariable;
        }
        Variable<?>[] itemVars = viewItem.getVariables();
        block0: for (Variable<?> var : vars) {
            for (Variable<?> itemVar : itemVars) {
                if (itemVar != var) continue;
                patternVariable = itemVar;
                continue block0;
            }
        }
        return patternVariable;
    }

    private static void addInputFromVariableSource(Map<Variable<?>, InputViewItemImpl<?>> inputs, Variable<?> patterVariable) {
        Variable var;
        Declaration declaration;
        if (patterVariable instanceof Declaration && (declaration = (Declaration)patterVariable).getSource() instanceof From && (var = ((From)declaration.getSource()).getVariable()) != null) {
            ViewFlowBuilder.addInputFromVariableSource(inputs, var);
            if (var.isFact()) {
                inputs.putIfAbsent(var, (InputViewItemImpl)FlowDSL.input(var));
            }
        }
    }

    static ConditionalNamedConsequenceImpl createConditionalNamedConsequence(Map<String, Consequence> consequences, ConditionalConsequence cond) {
        return new ConditionalNamedConsequenceImpl(ViewFlowBuilder.createConstraint(cond.getExpr()), ViewFlowBuilder.createNamedConsequence(consequences, cond.getThen()), cond.getElse() != null ? ViewFlowBuilder.createConditionalNamedConsequence(consequences, cond.getElse()) : null);
    }

    static SingleConstraint createConstraint(ExprViewItem expr) {
        if (expr instanceof Expr1ViewItemImpl) {
            return new SingleConstraint1((Expr1ViewItemImpl)expr);
        }
        if (expr instanceof Expr2ViewItemImpl) {
            return new SingleConstraint2((Expr2ViewItemImpl)expr);
        }
        if (expr instanceof Expr3ViewItemImpl) {
            return new SingleConstraint3((Expr3ViewItemImpl)expr);
        }
        if (expr instanceof Expr4ViewItemImpl) {
            return new SingleConstraint4((Expr4ViewItemImpl)expr);
        }
        if (expr instanceof Expr5ViewItemImpl) {
            return new SingleConstraint5((Expr5ViewItemImpl)expr);
        }
        if (expr instanceof Expr6ViewItemImpl) {
            return new SingleConstraint6((Expr6ViewItemImpl)expr);
        }
        if (expr instanceof Expr7ViewItemImpl) {
            return new SingleConstraint7((Expr7ViewItemImpl)expr);
        }
        if (expr instanceof Expr8ViewItemImpl) {
            return new SingleConstraint8((Expr8ViewItemImpl)expr);
        }
        if (expr instanceof Expr9ViewItemImpl) {
            return new SingleConstraint9((Expr9ViewItemImpl)expr);
        }
        if (expr instanceof Expr10ViewItemImpl) {
            return new SingleConstraint10((Expr10ViewItemImpl)expr);
        }
        if (expr instanceof Expr11ViewItemImpl) {
            return new SingleConstraint11((Expr11ViewItemImpl)expr);
        }
        if (expr instanceof Expr12ViewItemImpl) {
            return new SingleConstraint12((Expr12ViewItemImpl)expr);
        }
        if (expr instanceof Expr13ViewItemImpl) {
            return new SingleConstraint13((Expr13ViewItemImpl)expr);
        }
        return null;
    }

    private static NamedConsequenceImpl createNamedConsequence(Map<String, Consequence> consequences, Consequence consequence) {
        if (consequence == null) {
            return null;
        }
        String name = NamesGenerator.generateName("consequence");
        consequences.put(name, consequence);
        return new NamedConsequenceImpl(name, consequence.isBreaking());
    }

    private static Condition viewItem2Condition(ViewItem viewItem, Condition condition, BuildContext ctx) {
        if (viewItem instanceof AbstractExprViewItem) {
            ((PatternImpl)condition).addWatchedProps(((AbstractExprViewItem)viewItem).getWatchedProps());
        }
        if (viewItem instanceof Expr1ViewItemImpl) {
            Expr1ViewItemImpl expr = (Expr1ViewItemImpl)viewItem;
            if (expr.getPredicate() != null) {
                ((PatternImpl)condition).addConstraint(new SingleConstraint1(expr));
            }
            return condition;
        }
        if (viewItem instanceof ExprNViewItem) {
            ((PatternImpl)condition).addConstraint(SingleConstraint.createConstraint((ExprNViewItem)viewItem));
            return condition;
        }
        if (viewItem instanceof TemporalExprViewItem) {
            TemporalExprViewItem expr = (TemporalExprViewItem)viewItem;
            ((PatternImpl)condition).addConstraint(TemporalConstraint.createTemporalConstraint(expr));
            return condition;
        }
        if (viewItem instanceof AccumulateExprViewItem) {
            PatternImpl newCondition;
            AccumulateExprViewItem acc = (AccumulateExprViewItem)viewItem;
            for (AccumulateFunction accFunc : acc.getAccumulateFunctions()) {
                ctx.usedVars.add(accFunc.getResult());
            }
            if (acc.getExpr() instanceof InputViewItem) {
                newCondition = condition;
            } else if (acc.getExpr() instanceof Binding) {
                Binding binding = (Binding)((Object)acc.getExpr());
                PatternImpl bindingPattern = new PatternImpl(binding.getInputVariable());
                bindingPattern.addBinding(binding);
                newCondition = bindingPattern;
                ctx.usedVars.add(binding.getBoundVariable());
            } else {
                newCondition = ViewFlowBuilder.viewItem2Condition(acc.getExpr(), condition, ctx);
            }
            return new AccumulatePatternImpl(newCondition, acc.getAccumulateFunctions());
        }
        if (viewItem instanceof CombinedExprViewItem) {
            CombinedExprViewItem combined = (CombinedExprViewItem)viewItem;
            CompositePatterns patterns = ViewFlowBuilder.viewItems2Condition(new BuildContext(ctx, combined.getExpressions()), combined.getType(), false);
            return patterns.getSubConditions().size() == 1 ? patterns.getSubConditions().get(0) : patterns;
        }
        throw new UnsupportedOperationException("Unknown ViewItem: " + viewItem);
    }

    private static class BuildContext {
        final List<RuleItem> ruleItems;
        final Map<Variable<?>, InputViewItemImpl<?>> inputs;
        final Set<Variable<?>> usedVars;
        final Set<Variable<?>> boundVars;
        final Map<Variable<?>, List<Binding>> bindings;
        boolean isQuery = false;

        BuildContext(RuleItemBuilder<?>[] viewItemBuilders) {
            this(Stream.of(viewItemBuilders).map(RuleItemBuilder::get).collect(Collectors.toList()), new LinkedHashMap(), new HashSet(), new HashSet(), new HashMap(), false);
        }

        BuildContext(BuildContext orignalContext, ViewItem[] view) {
            this(Arrays.asList(view), orignalContext.inputs, orignalContext.usedVars, orignalContext.boundVars, orignalContext.bindings, orignalContext.isQuery);
        }

        BuildContext(BuildContext orignalContext, Map<Variable<?>, InputViewItemImpl<?>> inputs) {
            this(orignalContext.ruleItems, inputs, orignalContext.usedVars, orignalContext.boundVars, orignalContext.bindings, orignalContext.isQuery);
        }

        BuildContext(BuildContext orignalContext, ViewItem[] view, Map<Variable<?>, InputViewItemImpl<?>> inputs) {
            this(Arrays.asList(view), inputs, orignalContext.usedVars, orignalContext.boundVars, orignalContext.bindings, orignalContext.isQuery);
        }

        BuildContext(List<RuleItem> ruleItems, Map<Variable<?>, InputViewItemImpl<?>> inputs, Set<Variable<?>> usedVars, Set<Variable<?>> boundVars, Map<Variable<?>, List<Binding>> bindings, boolean isQuery) {
            this.ruleItems = ruleItems;
            this.inputs = inputs;
            this.usedVars = usedVars;
            this.boundVars = boundVars;
            this.bindings = bindings;
            this.isQuery = isQuery;
        }

        void addBinding(Binding bindViewItem) {
            this.boundVars.add(bindViewItem.getBoundVariable());
            this.bindings.computeIfAbsent(bindViewItem.getInputVariable(), v -> new ArrayList()).add(bindViewItem);
        }
    }

    private static class ConditionComparator
    implements Comparator<Condition> {
        private static final ConditionComparator INSTANCE = new ConditionComparator();

        private ConditionComparator() {
        }

        @Override
        public int compare(Condition c1, Condition c2) {
            if (c1 instanceof Pattern && c2 instanceof Pattern) {
                Pattern p1 = (Pattern)c1;
                Pattern p2 = (Pattern)c2;
                if (p1.getPatternVariable() != null && p1.getPatternVariable() == ConditionComparator.getSourceVariable(p2)) {
                    return -1;
                }
                if (p2.getPatternVariable() != null && p2.getPatternVariable() == ConditionComparator.getSourceVariable(p1)) {
                    return 1;
                }
            }
            return 0;
        }

        private static Variable getSourceVariable(Pattern pattern) {
            DeclarationSource declarationSource;
            Variable source = pattern.getPatternVariable();
            if (source instanceof Declaration && (declarationSource = ((Declaration)source).getSource()) instanceof From) {
                return ((From)declarationSource).getVariable();
            }
            return null;
        }
    }
}

