/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PoolSetup {
    public static void setupConnection(String pool, String url, String username, String password, Properties properties) throws SQLException {
        GenericObjectPool connectionPool = new GenericObjectPool(null, PoolSetup.toInt(properties.getProperty("dbcpMaxActive"), 8), (byte)PoolSetup.toInt(properties.getProperty("dbcpWhenExhaustedAction"), 1), PoolSetup.toLong(properties.getProperty("dbcpMaxWait"), -1L), PoolSetup.toInt(properties.getProperty("dbcpMaxIdle"), 8), PoolSetup.toInt(properties.getProperty("dbcpMinIdle"), 0), PoolSetup.toBoolean(properties.getProperty("dbcpTestOnBorrow"), false), PoolSetup.toBoolean(properties.getProperty("dbcpTestOnReturn"), false), PoolSetup.toLong(properties.getProperty("dbcpTimeBetweenEvictionRunsMillis"), -1L), PoolSetup.toInt(properties.getProperty("dbcpNumTestsPerEvictionRun"), 3), PoolSetup.toLong(properties.getProperty("dbcpMinEvictableIdleTimeMillis"), 1800000L), PoolSetup.toBoolean(properties.getProperty("dbcpTestWhileIdle"), false), PoolSetup.toLong(properties.getProperty("dbcpSoftMinEvictableIdleTimeMillis"), -1L));
        DriverManagerConnectionFactory connectionFactory = null;
        connectionFactory = username == null || password == null ? new DriverManagerConnectionFactory(url, null) : new DriverManagerConnectionFactory(url, username, password);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, properties.getProperty("dbcpValidationQuery"), PoolSetup.toBoolean(properties.getProperty("dbcpDefaultReadOnly"), false), PoolSetup.toBoolean(properties.getProperty("dbcpDefaultAutoCommit"), true));
        try {
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("WARNING: DBCP needed but not in the classpath. ");
        }
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(pool, (ObjectPool)connectionPool);
    }

    public static String getUrl(String pool) {
        return "jdbc:apache:commons:dbcp:" + pool;
    }

    private static int toInt(String str, int def) {
        if (str == null) {
            return def;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Unable to parse as int: '" + str + "'", nfe);
        }
    }

    private static long toLong(String str, long def) {
        if (str == null) {
            return def;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Unable to parse as long: '" + str + "'", nfe);
        }
    }

    private static boolean toBoolean(String str, boolean def) {
        if (str == null) {
            return def;
        }
        if ("true".equals(str)) {
            return true;
        }
        if ("false".equals(str)) {
            return false;
        }
        throw new RuntimeException("Unable to parse as boolean: '" + str + "'");
    }
}

