/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.rule.builder.RuleBuilder;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.base.SalienceInteger;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.ConditionalBranch;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Forall;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.MultiAccumulate;
import org.drools.core.rule.NamedConsequence;
import org.drools.core.rule.PatternSource;
import org.drools.core.rule.QueryArgument;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.QueryImpl;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.SingleAccumulate;
import org.drools.core.rule.SlidingLengthWindow;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.rule.constraint.QueryNameConstraint;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.Enabled;
import org.drools.core.spi.EvalExpression;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.Salience;
import org.drools.core.time.impl.Timer;
import org.drools.model.AccumulatePattern;
import org.drools.model.Argument;
import org.drools.model.Binding;
import org.drools.model.Condition;
import org.drools.model.Consequence;
import org.drools.model.Constraint;
import org.drools.model.Declaration;
import org.drools.model.DeclarationSource;
import org.drools.model.DynamicValueSupplier;
import org.drools.model.EntryPoint;
import org.drools.model.FlowDSL;
import org.drools.model.From;
import org.drools.model.From0;
import org.drools.model.From1;
import org.drools.model.From2;
import org.drools.model.From3;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.Model;
import org.drools.model.Pattern;
import org.drools.model.Prototype;
import org.drools.model.PrototypeVariable;
import org.drools.model.Query;
import org.drools.model.Rule;
import org.drools.model.SingleConstraint;
import org.drools.model.TypeMetaData;
import org.drools.model.UnitData;
import org.drools.model.Value;
import org.drools.model.Variable;
import org.drools.model.View;
import org.drools.model.WindowDefinition;
import org.drools.model.WindowReference;
import org.drools.model.consequences.ConditionalNamedConsequenceImpl;
import org.drools.model.consequences.NamedConsequenceImpl;
import org.drools.model.constraints.SingleConstraint1;
import org.drools.model.functions.Function0;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Function3;
import org.drools.model.functions.FunctionUtils;
import org.drools.model.functions.Predicate1;
import org.drools.model.impl.DeclarationImpl;
import org.drools.model.impl.NamesGenerator;
import org.drools.model.patterns.CompositePatterns;
import org.drools.model.patterns.EvalImpl;
import org.drools.model.patterns.ExistentialPatternImpl;
import org.drools.model.patterns.PatternImpl;
import org.drools.model.patterns.QueryCallPattern;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.RuleContext;
import org.drools.modelcompiler.attributes.LambdaEnabled;
import org.drools.modelcompiler.attributes.LambdaSalience;
import org.drools.modelcompiler.consequence.LambdaConsequence;
import org.drools.modelcompiler.consequence.MVELConsequence;
import org.drools.modelcompiler.constraints.AbstractConstraint;
import org.drools.modelcompiler.constraints.BindingEvaluator;
import org.drools.modelcompiler.constraints.BindingInnerObjectEvaluator;
import org.drools.modelcompiler.constraints.CombinedConstraint;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaAccumulator;
import org.drools.modelcompiler.constraints.LambdaConstraint;
import org.drools.modelcompiler.constraints.LambdaDataProvider;
import org.drools.modelcompiler.constraints.LambdaEvalExpression;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;
import org.drools.modelcompiler.constraints.TemporalConstraintEvaluator;
import org.drools.modelcompiler.constraints.UnificationConstraint;
import org.drools.modelcompiler.facttemplate.FactFactory;
import org.drools.modelcompiler.util.MvelUtil;
import org.drools.modelcompiler.util.TypeDeclarationUtil;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.rule.All;
import org.kie.api.definition.rule.Direct;
import org.kie.api.definition.rule.Propagation;
import org.kie.api.definition.type.Role;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.soup.project.datamodel.commons.types.ClassTypeResolver;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class KiePackagesBuilder {
    private static final ObjectType JAVA_CLASS_OBJECT_TYPE = new ClassObjectType(Object.class);
    private final RuleBaseConfiguration configuration;
    private final Map<String, InternalKnowledgePackage> packages = new HashMap<String, InternalKnowledgePackage>();
    private final Map<String, ObjectType> objectTypeCache = new HashMap<String, ObjectType>();
    private final Collection<Model> models;

    public KiePackagesBuilder(KieBaseConfiguration conf) {
        this(conf, new ArrayList<Model>());
    }

    public KiePackagesBuilder(KieBaseConfiguration conf, Collection<Model> models) {
        this.configuration = (RuleBaseConfiguration)conf;
        this.models = models;
    }

    public void addModel(Model model) {
        this.models.add(model);
    }

    public CanonicalKiePackages build() {
        for (Model model : this.models) {
            KnowledgePackageImpl pkg;
            for (EntryPoint entryPoint : model.getEntryPoints()) {
                pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(model.getName(), this::createKiePackage);
                pkg.addEntryPointId(entryPoint.getName());
            }
            for (TypeMetaData metaType : model.getTypeMetaDatas()) {
                pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(metaType.getPackage(), this::createKiePackage);
                pkg.addTypeDeclaration(TypeDeclarationUtil.createTypeDeclaration(pkg, metaType));
            }
            for (Global global : model.getGlobals()) {
                pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(global.getPackage(), this::createKiePackage);
                pkg.addGlobal(global.getName(), global.getType());
            }
            for (Query query : model.getQueries()) {
                pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(query.getPackage(), this::createKiePackage);
                pkg.addRule((RuleImpl)this.compileQuery(pkg, query));
            }
            int ruleCounter = 0;
            for (Rule rule : model.getRules()) {
                KnowledgePackageImpl pkg2 = (KnowledgePackageImpl)this.packages.computeIfAbsent(rule.getPackage(), this::createKiePackage);
                RuleImpl ruleImpl = this.compileRule(pkg2, rule);
                ruleImpl.setLoadOrder(ruleCounter++);
                pkg2.addRule(ruleImpl);
            }
        }
        return new CanonicalKiePackages(this.packages);
    }

    public ClassLoader getClassLoader() {
        return this.configuration.getClassLoader();
    }

    private KnowledgePackageImpl createKiePackage(String name) {
        KnowledgePackageImpl kpkg = new KnowledgePackageImpl(name);
        kpkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.getClassLoader()));
        ClassTypeResolver typeResolver = new ClassTypeResolver(new HashSet(kpkg.getImports().keySet()), this.getClassLoader(), name);
        typeResolver.addImport(name + ".*");
        kpkg.setTypeResolver((TypeResolver)typeResolver);
        return kpkg;
    }

    private RuleImpl compileRule(KnowledgePackageImpl pkg, Rule rule) {
        RuleImpl ruleImpl = new RuleImpl(rule.getName());
        ruleImpl.setPackage(pkg.getName());
        ruleImpl.setPackage(rule.getPackage());
        if (rule.getUnit() != null) {
            ruleImpl.setRuleUnitClassName(rule.getUnit());
            pkg.getRuleUnitRegistry().getRuleUnitFor(ruleImpl);
        }
        RuleContext ctx = new RuleContext(this, pkg, ruleImpl);
        this.populateLHS(ctx, pkg, rule.getView());
        this.processConsequences(ctx, rule);
        if (ctx.needsStreamMode()) {
            pkg.setNeedStreamMode();
        }
        this.setRuleAttributes(rule, ruleImpl, ctx);
        this.setRuleMetaAttributes(rule, ruleImpl);
        return ruleImpl;
    }

    private void setRuleAttributes(Rule rule, RuleImpl ruleImpl, RuleContext ctx) {
        Boolean noLoop = this.setAttribute(rule, Rule.Attribute.NO_LOOP, arg_0 -> ((RuleImpl)ruleImpl).setNoLoop(arg_0));
        Boolean lockOnActive = this.setAttribute(rule, Rule.Attribute.LOCK_ON_ACTIVE, arg_0 -> ((RuleImpl)ruleImpl).setLockOnActive(arg_0));
        this.setAttribute(rule, Rule.Attribute.AUTO_FOCUS, arg_0 -> ((RuleImpl)ruleImpl).setAutoFocus(arg_0));
        this.setDynamicAttribute(rule, Rule.Attribute.ENABLED, e -> ruleImpl.setEnabled(this.createEnabled(e)));
        this.setDynamicAttribute(rule, Rule.Attribute.SALIENCE, s -> ruleImpl.setSalience(this.createSalience(s)));
        String agendaGroup = this.setAttribute(rule, Rule.Attribute.AGENDA_GROUP, arg_0 -> ((RuleImpl)ruleImpl).setAgendaGroup(arg_0));
        this.setAttribute(rule, Rule.Attribute.RULEFLOW_GROUP, rfg -> {
            ruleImpl.setRuleFlowGroup(rfg);
            if (agendaGroup == null) {
                ruleImpl.setAgendaGroup(rfg);
            }
        });
        this.setAttribute(rule, Rule.Attribute.ACTIVATION_GROUP, arg_0 -> ((RuleImpl)ruleImpl).setActivationGroup(arg_0));
        this.setAttribute(rule, Rule.Attribute.DURATION, t -> ruleImpl.setTimer(this.parseTimer(ruleImpl, (String)t, ctx)));
        this.setAttribute(rule, Rule.Attribute.TIMER, t -> ruleImpl.setTimer(this.parseTimer(ruleImpl, (String)t, ctx)));
        this.setAttribute(rule, Rule.Attribute.CALENDARS, arg_0 -> ((RuleImpl)ruleImpl).setCalendars(arg_0));
        this.setAttribute(rule, Rule.Attribute.DATE_EFFECTIVE, arg_0 -> ((RuleImpl)ruleImpl).setDateEffective(arg_0));
        this.setAttribute(rule, Rule.Attribute.DATE_EXPIRES, arg_0 -> ((RuleImpl)ruleImpl).setDateExpires(arg_0));
        ruleImpl.setEager(ruleImpl.isEager() || noLoop != null || lockOnActive != null);
    }

    private Salience createSalience(Object s) {
        if (s instanceof Integer) {
            return new SalienceInteger(((Integer)s).intValue());
        }
        if (s instanceof DynamicValueSupplier) {
            return new LambdaSalience((DynamicValueSupplier<Integer>)((DynamicValueSupplier)s));
        }
        throw new UnsupportedOperationException("Unknown salience type: " + s.getClass().getCanonicalName());
    }

    private Enabled createEnabled(Object e) {
        if (e instanceof Boolean) {
            return new EnabledBoolean(((Boolean)e).booleanValue());
        }
        if (e instanceof DynamicValueSupplier) {
            return new LambdaEnabled((DynamicValueSupplier<Boolean>)((DynamicValueSupplier)e));
        }
        throw new UnsupportedOperationException("Unknown salience type: " + e.getClass().getCanonicalName());
    }

    private <T> T setAttribute(Rule rule, Rule.Attribute<T> attribute, Consumer<T> consumer) {
        Object value = rule.getAttribute(attribute);
        if (value != attribute.getDefaultValue()) {
            consumer.accept(value);
            return (T)value;
        }
        return null;
    }

    private void setDynamicAttribute(Rule rule, Rule.Attribute<?> attribute, Consumer<Object> consumer) {
        Object value = rule.getAttribute(attribute);
        if (value != attribute.getDefaultValue()) {
            consumer.accept(value);
        }
    }

    private void setRuleMetaAttributes(Rule rule, RuleImpl ruleImpl) {
        for (Map.Entry kv : rule.getMetaData().entrySet()) {
            ruleImpl.addMetaAttribute((String)kv.getKey(), kv.getValue());
            if (((String)kv.getKey()).equals(Propagation.class.getName()) || ((String)kv.getKey()).equals(Propagation.class.getSimpleName())) {
                if (Propagation.Type.IMMEDIATE.toString().equals(kv.getValue())) {
                    ruleImpl.setDataDriven(true);
                    continue;
                }
                if (!Propagation.Type.EAGER.toString().equals(kv.getValue())) continue;
                ruleImpl.setEager(true);
                continue;
            }
            if (((String)kv.getKey()).equals(All.class.getName()) || ((String)kv.getKey()).equals(All.class.getSimpleName())) {
                ruleImpl.setAllMatches(true);
                continue;
            }
            if (!((String)kv.getKey()).equals(Direct.class.getName()) && !((String)kv.getKey()).equals(Direct.class.getSimpleName())) continue;
            ruleImpl.setActivationListener("direct");
        }
    }

    private Timer parseTimer(RuleImpl ruleImpl, String timerExpr, RuleContext ctx) {
        return RuleBuilder.buildTimer((RuleImpl)ruleImpl, (String)timerExpr, null, expr -> MvelUtil.createMvelObjectExpression(expr, ctx.getClassLoader(), ctx.getDeclarations()), null);
    }

    private QueryImpl compileQuery(KnowledgePackageImpl pkg, Query query) {
        QueryImpl queryImpl = new QueryImpl(query.getName());
        queryImpl.setPackage(query.getPackage());
        RuleContext ctx = new RuleContext(this, pkg, (RuleImpl)queryImpl);
        this.addQueryPattern(query, queryImpl, ctx);
        this.populateLHS(ctx, pkg, query.getView());
        return queryImpl;
    }

    private void addQueryPattern(Query query, QueryImpl queryImpl, RuleContext ctx) {
        org.drools.core.rule.Pattern pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, (ObjectType)ClassObjectType.DroolsQuery_ObjectType, null);
        LambdaReadAccessor extractor = new LambdaReadAccessor(DroolsQuery.class, (Function1 & Serializable)q -> ((DroolsQuery)q).getName());
        QueryNameConstraint constraint = new QueryNameConstraint((InternalReadAccessor)extractor, query.getName());
        pattern.addConstraint((org.drools.core.spi.Constraint)constraint);
        queryImpl.getLhs().addChild((RuleConditionElement)pattern);
        Variable[] args = query.getArguments();
        org.drools.core.rule.Declaration[] declarations = new org.drools.core.rule.Declaration[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = i;
            LambdaReadAccessor accessor = new LambdaReadAccessor(index, args[index].getType(), (Function1 & Serializable)obj -> ((DroolsQuery)obj).getElements()[index]);
            declarations[i] = new org.drools.core.rule.Declaration(args[i].getName(), (InternalReadAccessor)accessor, pattern, false);
            pattern.addDeclaration(declarations[i]);
            ctx.addQueryDeclaration(args[i], declarations[i]);
        }
        queryImpl.setParameters(declarations);
    }

    private void processConsequences(RuleContext ctx, Rule rule) {
        for (Map.Entry entry : rule.getConsequences().entrySet()) {
            this.processConsequence(ctx, (Consequence)entry.getValue(), (String)entry.getKey());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConsequence(RuleContext ctx, Consequence consequence, String name) {
        if (name.equals("default")) {
            if ("java".equals(consequence.getLanguage())) {
                ctx.getRule().setConsequence((org.drools.core.spi.Consequence)new LambdaConsequence(consequence));
            } else {
                if (!"mvel".equals(consequence.getLanguage())) throw new UnsupportedOperationException("Unknown script language for consequence: " + consequence.getLanguage());
                ctx.getRule().setConsequence((org.drools.core.spi.Consequence)new MVELConsequence(consequence, ctx));
            }
        } else {
            ctx.getRule().addNamedConsequence(name, (org.drools.core.spi.Consequence)new LambdaConsequence(consequence));
        }
        Variable[] consequenceVars = consequence.getDeclarations();
        String[] requiredDeclarations = new String[consequenceVars.length];
        for (int i = 0; i < consequenceVars.length; ++i) {
            requiredDeclarations[i] = consequenceVars[i].getName();
        }
        ctx.getRule().setRequiredDeclarationsForConsequence(name, requiredDeclarations);
    }

    private void populateLHS(RuleContext ctx, KnowledgePackageImpl pkg, View view) {
        GroupElement lhs = ctx.getRule().getLhs();
        if (ctx.getRule().getRuleUnitClassName() != null) {
            lhs.addChild((RuleConditionElement)this.addPatternForVariable(ctx, lhs, this.getUnitVariable(ctx, pkg, view)));
        }
        this.addSubConditions(ctx, lhs, view.getSubConditions());
        if (this.requiresLeftActivation((RuleConditionElement)lhs)) {
            lhs.addChild(0, (RuleConditionElement)new org.drools.core.rule.Pattern(0, (ObjectType)ClassObjectType.InitialFact_ObjectType));
        }
    }

    private boolean requiresLeftActivation(RuleConditionElement rce) {
        if (rce instanceof GroupElement) {
            GroupElement and = (GroupElement)rce;
            return and.getChildren().isEmpty() || this.requiresLeftActivation((RuleConditionElement)and.getChildren().get(0));
        }
        return rce instanceof QueryElement;
    }

    private Variable getUnitVariable(RuleContext ctx, KnowledgePackageImpl pkg, View view) {
        String unitClassName = ctx.getRule().getRuleUnitClassName();
        for (Variable var : view.getBoundVariables()) {
            if (!(var instanceof DeclarationImpl) || !var.getType().getName().equals(unitClassName)) continue;
            return ((DeclarationImpl)var).setSource((DeclarationSource)FlowDSL.entryPoint((String)"$$units$$"));
        }
        try {
            return FlowDSL.declarationOf((Class)pkg.getTypeResolver().resolveType(unitClassName), (DeclarationSource)FlowDSL.entryPoint((String)"$$units$$"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private RuleConditionElement conditionToElement(RuleContext ctx, GroupElement group, Condition condition) {
        if (condition.getType().isComposite()) {
            return this.addSubConditions(ctx, new GroupElement(KiePackagesBuilder.conditionToGroupElementType(condition.getType())), condition.getSubConditions());
        }
        switch (condition.getType()) {
            case PATTERN: {
                return this.buildPattern(ctx, group, condition);
            }
            case EVAL: {
                return this.buildEval(ctx, (EvalImpl)condition);
            }
            case ACCUMULATE: {
                org.drools.core.rule.Pattern source;
                boolean existingPattern;
                AccumulatePattern accumulatePattern = (AccumulatePattern)condition;
                org.drools.core.rule.Pattern pattern = null;
                if (accumulatePattern.getAccumulateFunctions().length == 1) {
                    pattern = ctx.getPattern(accumulatePattern.getAccumulateFunctions()[0].getResult());
                }
                boolean bl = existingPattern = pattern != null;
                if (!existingPattern) {
                    pattern = new org.drools.core.rule.Pattern(0, JAVA_CLASS_OBJECT_TYPE);
                }
                PatternImpl sourcePattern = (PatternImpl)accumulatePattern.getPattern();
                ArrayList<String> usedVariableName = new ArrayList<String>();
                Binding binding = null;
                if (sourcePattern != null) {
                    for (Variable v : sourcePattern.getInputVariables()) {
                        usedVariableName.add(v.getName());
                    }
                    if (!sourcePattern.getBindings().isEmpty()) {
                        binding = (Binding)sourcePattern.getBindings().iterator().next();
                        usedVariableName.add(binding.getBoundVariable().getName());
                    }
                }
                if (accumulatePattern.isCompositePatterns()) {
                    CompositePatterns compositePatterns = (CompositePatterns)accumulatePattern.getCondition();
                    GroupElement allSubConditions = new GroupElement(KiePackagesBuilder.conditionToGroupElementType(compositePatterns.getType()));
                    for (Condition c : compositePatterns.getSubConditions()) {
                        this.recursivelyAddConditions(ctx, group, allSubConditions, c);
                    }
                    source = allSubConditions;
                } else {
                    source = this.buildPattern(ctx, group, condition);
                }
                pattern.setSource((PatternSource)this.buildAccumulate(ctx, accumulatePattern, (RuleConditionElement)source, pattern, usedVariableName, binding));
                return existingPattern ? null : pattern;
            }
            case QUERY: {
                return this.buildQueryPattern(ctx, (QueryCallPattern)condition);
            }
            case NOT: 
            case EXISTS: {
                GroupElement ge = new GroupElement(KiePackagesBuilder.conditionToGroupElementType(condition.getType()));
                ge.addChild(this.conditionToElement(ctx, group, (Condition)condition.getSubConditions().get(0)));
                return ge;
            }
            case FORALL: {
                org.drools.core.rule.Pattern basePattern;
                Condition innerCondition = (Condition)condition.getSubConditions().get(0);
                ArrayList<org.drools.core.rule.Pattern> remainingPatterns = new ArrayList<org.drools.core.rule.Pattern>();
                if (innerCondition instanceof PatternImpl) {
                    basePattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, this.getObjectType(((PatternImpl)innerCondition).getPatternVariable()), "$__forallBaseIdentifier", true);
                    remainingPatterns.add((org.drools.core.rule.Pattern)this.conditionToElement(ctx, group, innerCondition));
                } else {
                    basePattern = (org.drools.core.rule.Pattern)this.conditionToElement(ctx, group, (Condition)innerCondition.getSubConditions().get(0));
                    for (int i = 1; i < innerCondition.getSubConditions().size(); ++i) {
                        remainingPatterns.add((org.drools.core.rule.Pattern)this.conditionToElement(ctx, group, (Condition)innerCondition.getSubConditions().get(i)));
                    }
                }
                return new Forall(basePattern, remainingPatterns);
            }
            case CONSEQUENCE: {
                if (condition instanceof NamedConsequenceImpl) {
                    NamedConsequenceImpl consequence = (NamedConsequenceImpl)condition;
                    return consequence.getName().equals("default") ? null : new NamedConsequence(consequence.getName(), consequence.isBreaking());
                }
                if (!(condition instanceof ConditionalNamedConsequenceImpl)) break;
                return this.buildConditionalConsequence(ctx, (ConditionalNamedConsequenceImpl)condition);
            }
        }
        throw new UnsupportedOperationException();
    }

    private void recursivelyAddConditions(RuleContext ctx, GroupElement group, GroupElement allSubConditions, Condition c) {
        if (c instanceof CompositePatterns) {
            this.buildCompositePatterns(ctx, group, allSubConditions, c);
        } else if (c instanceof ExistentialPatternImpl) {
            this.buildExistentialPatternImpl(ctx, group, allSubConditions, c);
        } else if (c instanceof PatternImpl) {
            allSubConditions.addChild((RuleConditionElement)this.buildPattern(ctx, group, c));
        }
    }

    private EvalCondition buildEval(RuleContext ctx, EvalImpl eval) {
        org.drools.core.rule.Declaration[] declarations = (org.drools.core.rule.Declaration[])Stream.of(eval.getExpr().getVariables()).map(ctx::getDeclaration).toArray(org.drools.core.rule.Declaration[]::new);
        LambdaEvalExpression evalExpr = new LambdaEvalExpression(declarations, eval.getExpr());
        return new EvalCondition((EvalExpression)evalExpr, declarations);
    }

    private ConditionalBranch buildConditionalConsequence(RuleContext ctx, ConditionalNamedConsequenceImpl consequence) {
        EvalCondition evalCondition;
        if (consequence.getExpr() != null) {
            org.drools.core.rule.Pattern pattern = ctx.getPattern(consequence.getExpr().getVariables()[0]);
            LambdaEvalExpression eval = new LambdaEvalExpression(pattern, consequence.getExpr());
            evalCondition = new EvalCondition((EvalExpression)eval, pattern.getRequiredDeclarations());
        } else {
            evalCondition = new EvalCondition(LambdaEvalExpression.EMPTY, null);
        }
        return new ConditionalBranch(evalCondition, new NamedConsequence(consequence.getThenConsequence().getName(), consequence.getThenConsequence().isBreaking()), consequence.getElseBranch() != null ? this.buildConditionalConsequence(ctx, consequence.getElseBranch()) : null);
    }

    private RuleConditionElement addSubConditions(RuleContext ctx, GroupElement ge, List<Condition> subconditions) {
        for (Condition subCondition : subconditions) {
            RuleConditionElement element = this.conditionToElement(ctx, ge, subCondition);
            if (element == null) continue;
            ge.addChild(element);
        }
        if (ge.getType() == GroupElement.AND && ge.getChildren().size() == 1) {
            return (RuleConditionElement)ge.getChildren().get(0);
        }
        return ge;
    }

    private RuleConditionElement buildQueryPattern(RuleContext ctx, QueryCallPattern queryPattern) {
        org.drools.core.rule.Pattern pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, (ObjectType)ClassObjectType.ObjectArray_ObjectType, null);
        QueryArgument[] arguments = new QueryArgument[queryPattern.getArguments().length];
        ArrayList<Integer> varIndexList = new ArrayList<Integer>();
        ArrayList<org.drools.core.rule.Declaration> requiredDeclarations = new ArrayList<org.drools.core.rule.Declaration>();
        for (int i2 = 0; i2 < queryPattern.getArguments().length; ++i2) {
            Argument arg = queryPattern.getArguments()[i2];
            if (arg instanceof Variable) {
                Variable var = (Variable)arg;
                org.drools.core.rule.Declaration decl = ctx.getDeclaration(var);
                if (decl != null) {
                    requiredDeclarations.add(decl);
                    arguments[i2] = new QueryArgument.Declr(decl);
                    continue;
                }
                ArrayElementReader reader = new ArrayElementReader((InternalReadAccessor)new SelfReferenceClassFieldReader(Object[].class), i2, arg.getType());
                org.drools.core.rule.Declaration varDeclaration = pattern.addDeclaration(var.getName());
                varDeclaration.setReadAccessor((InternalReadAccessor)reader);
                ctx.addInnerDeclaration(var, varDeclaration);
                arguments[i2] = QueryArgument.VAR;
                varIndexList.add(i2);
                continue;
            }
            if (arg instanceof Value) {
                arguments[i2] = new QueryArgument.Literal(((Value)arg).getValue());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return new QueryElement(pattern, queryPattern.getQuery().getName(), arguments, varIndexList.stream().mapToInt(i -> i).toArray(), requiredDeclarations.toArray(new org.drools.core.rule.Declaration[requiredDeclarations.size()]), queryPattern.isOpen(), false);
    }

    private org.drools.core.rule.Pattern buildPattern(RuleContext ctx, GroupElement group, Condition condition) {
        Pattern modelPattern = (Pattern)condition;
        org.drools.core.rule.Pattern pattern = this.addPatternForVariable(ctx, group, modelPattern.getPatternVariable());
        for (Binding binding : modelPattern.getBindings()) {
            org.drools.core.rule.Declaration declaration = new org.drools.core.rule.Declaration(binding.getBoundVariable().getName(), (InternalReadAccessor)new LambdaReadAccessor(binding.getBoundVariable().getType(), binding.getBindingFunction()), pattern, true);
            pattern.addDeclaration(declaration);
            if (binding.getReactOn() != null) {
                this.addFieldsToPatternWatchlist(pattern, binding.getReactOn());
            }
            ctx.addInnerDeclaration(binding.getBoundVariable(), declaration);
        }
        org.drools.core.rule.Declaration queryArgDecl = ctx.getQueryDeclaration(modelPattern.getPatternVariable());
        if (queryArgDecl != null) {
            pattern.addConstraint((org.drools.core.spi.Constraint)new UnificationConstraint(queryArgDecl));
        }
        this.addConstraintsToPattern(ctx, pattern, modelPattern.getConstraint());
        this.addFieldsToPatternWatchlist(pattern, modelPattern.getWatchedProps());
        return pattern;
    }

    private void buildExistentialPatternImpl(RuleContext ctx, GroupElement group, GroupElement allSubConditions, Condition condition) {
        ExistentialPatternImpl existentialPattern = (ExistentialPatternImpl)condition;
        this.recursivelyAddConditions(ctx, group, allSubConditions, (Condition)existentialPattern.getSubConditions().iterator().next());
    }

    private void buildCompositePatterns(RuleContext ctx, GroupElement group, GroupElement allSubConditions, Condition condition) {
        CompositePatterns compositePatterns = (CompositePatterns)condition;
        compositePatterns.getSubConditions().forEach(sc -> this.recursivelyAddConditions(ctx, group, allSubConditions, (Condition)sc));
    }

    private Accumulate buildAccumulate(RuleContext ctx, AccumulatePattern accPattern, RuleConditionElement source, org.drools.core.rule.Pattern pattern, List<String> usedVariableName, Binding binding) {
        MultiAccumulate accumulate;
        org.drools.model.functions.accumulate.AccumulateFunction[] accFunctions = accPattern.getAccumulateFunctions();
        BindingEvaluator bindingEvaluator = this.createBindingEvaluator(ctx, binding);
        if (accFunctions.length == 1) {
            org.drools.model.functions.accumulate.AccumulateFunction accFunction = accFunctions[0];
            Class functionClass = accFunction.getFunctionClass();
            Accumulator accumulator = this.createAccumulator(usedVariableName, bindingEvaluator, functionClass, accFunction);
            Variable boundVar = accPattern.getBoundVariables()[0];
            org.drools.core.rule.Declaration declaration = new org.drools.core.rule.Declaration(boundVar.getName(), org.drools.core.rule.Pattern.getReadAcessor((ObjectType)JAVA_CLASS_OBJECT_TYPE), pattern, true);
            pattern.addDeclaration(declaration);
            org.drools.core.rule.Declaration[] requiredDeclarations = this.getRequiredDeclarationsForAccumulate(ctx, binding, accFunction);
            if (requiredDeclarations.length == 0 && source instanceof org.drools.core.rule.Pattern && bindingEvaluator != null && bindingEvaluator.getDeclarations() != null) {
                ArrayList<org.drools.core.rule.Declaration> previousDecl = new ArrayList<org.drools.core.rule.Declaration>();
                org.drools.core.rule.Pattern patternSource = (org.drools.core.rule.Pattern)source;
                patternSource.resetDeclarations();
                for (org.drools.core.rule.Declaration d : bindingEvaluator.getDeclarations()) {
                    if (d.getIdentifier().equals(patternSource.getDeclaration().getIdentifier())) {
                        patternSource.addDeclaration(d);
                        continue;
                    }
                    previousDecl.add(d);
                }
                requiredDeclarations = previousDecl.toArray(new org.drools.core.rule.Declaration[previousDecl.size()]);
            }
            accumulate = new SingleAccumulate(source, requiredDeclarations, accumulator);
        } else {
            SelfReferenceClassFieldReader reader = new SelfReferenceClassFieldReader(Object[].class);
            Accumulator[] accumulators = new Accumulator[accFunctions.length];
            for (int i = 0; i < accFunctions.length; ++i) {
                Class functionClass = accFunctions[i].getFunctionClass();
                Accumulator accumulator = this.createAccumulator(usedVariableName, bindingEvaluator, functionClass, accFunctions[i]);
                Variable boundVar = accPattern.getBoundVariables()[i];
                pattern.addDeclaration(new org.drools.core.rule.Declaration(boundVar.getName(), (InternalReadAccessor)new ArrayElementReader((InternalReadAccessor)reader, i, boundVar.getType()), pattern, true));
                accumulators[i] = accumulator;
            }
            accumulate = new MultiAccumulate(source, new org.drools.core.rule.Declaration[0], accumulators);
        }
        for (Variable boundVar : accPattern.getBoundVariables()) {
            ctx.addAccumulateSource(boundVar, (Accumulate)accumulate);
        }
        return accumulate;
    }

    private org.drools.core.rule.Declaration[] getRequiredDeclarationsForAccumulate(RuleContext ctx, Binding binding, org.drools.model.functions.accumulate.AccumulateFunction accFunction) {
        if (binding != null || accFunction.getSource() == null) {
            if (accFunction.getExternalVars() != null) {
                Variable[] extVars = accFunction.getExternalVars();
                org.drools.core.rule.Declaration[] bindingDeclaration = new org.drools.core.rule.Declaration[extVars.length];
                for (int i = 0; i < extVars.length; ++i) {
                    bindingDeclaration[i] = ctx.getDeclaration(extVars[i]);
                }
                return bindingDeclaration;
            }
            return new org.drools.core.rule.Declaration[0];
        }
        if (accFunction.getSource() instanceof Variable) {
            return new org.drools.core.rule.Declaration[]{ctx.getPattern((Variable)accFunction.getSource()).getDeclaration()};
        }
        return new org.drools.core.rule.Declaration[0];
    }

    private BindingEvaluator createBindingEvaluator(RuleContext ctx, Binding binding) {
        if (binding == null) {
            return null;
        }
        Variable[] inputs = binding.getInputVariables();
        if (inputs.length == 1) {
            return new BindingInnerObjectEvaluator(binding);
        }
        org.drools.core.rule.Declaration[] declarations = new org.drools.core.rule.Declaration[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            declarations[i] = ctx.getDeclaration(inputs[i]);
        }
        return new BindingEvaluator(declarations, binding);
    }

    private Accumulator createAccumulator(List<String> usedVariableName, BindingEvaluator binding, Class<?> functionClass, org.drools.model.functions.accumulate.AccumulateFunction accFunction) {
        if (accFunction.isFixedValue()) {
            return new LambdaAccumulator.FixedValueAcc(this.getAccumulateFunction(functionClass), ((Value)accFunction.getSource()).getValue());
        }
        if (AccumulateFunction.class.isAssignableFrom(functionClass)) {
            return this.createLambdaAccumulator(usedVariableName, binding, functionClass);
        }
        if (Accumulator.class.isAssignableFrom(functionClass)) {
            return this.createLegacyAccumulator(functionClass);
        }
        throw new RuntimeException("Unknown functionClass" + functionClass);
    }

    private Accumulator createLegacyAccumulator(Class<?> functionClass) {
        Accumulator accumulator;
        try {
            accumulator = (Accumulator)functionClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return accumulator;
    }

    private Accumulator createLambdaAccumulator(List<String> usedVariableName, BindingEvaluator binding, Class<?> functionClass) {
        if (binding == null) {
            return new LambdaAccumulator.NotBindingAcc(this.getAccumulateFunction(functionClass), usedVariableName);
        }
        return new LambdaAccumulator.BindingAcc(this.getAccumulateFunction(functionClass), usedVariableName, binding);
    }

    private AccumulateFunction getAccumulateFunction(Class<?> functionClass) {
        AccumulateFunction accFunction1;
        try {
            accFunction1 = (AccumulateFunction)functionClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return accFunction1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private org.drools.core.rule.Pattern addPatternForVariable(RuleContext ctx, GroupElement group, Variable patternVariable) {
        org.drools.core.rule.Pattern pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, this.getObjectType(patternVariable), patternVariable.getName(), true);
        if (patternVariable instanceof Declaration) {
            Declaration decl = (Declaration)patternVariable;
            if (decl.getSource() != null) {
                if (decl.getSource() instanceof EntryPoint) {
                    pattern.setSource((PatternSource)new EntryPointId(((EntryPoint)decl.getSource()).getName()));
                } else if (decl.getSource() instanceof WindowReference) {
                    WindowReference window = (WindowReference)decl.getSource();
                    if (!ctx.getPkg().getWindowDeclarations().containsKey(window.getName())) {
                        this.createWindowReference(ctx, window);
                    }
                    pattern.setSource((PatternSource)new org.drools.core.rule.WindowReference(window.getName()));
                } else if (decl.getSource() instanceof From) {
                    From from = (From)decl.getSource();
                    DataProvider provider = this.createFromDataProvider(ctx, from);
                    org.drools.core.rule.From fromSource = new org.drools.core.rule.From(provider);
                    fromSource.setResultPattern(pattern);
                    pattern.setSource((PatternSource)fromSource);
                } else {
                    if (!(decl.getSource() instanceof UnitData)) throw new UnsupportedOperationException("Unknown source: " + decl.getSource());
                    UnitData unitData = (UnitData)decl.getSource();
                    pattern.setSource((PatternSource)new EntryPointId(ctx.getRule().getRuleUnitClassName() + "." + unitData.getName()));
                }
            } else {
                Accumulate accSource = ctx.getAccumulateSource(patternVariable);
                if (accSource != null) {
                    for (RuleConditionElement element : group.getChildren()) {
                        if (!(element instanceof org.drools.core.rule.Pattern) || ((org.drools.core.rule.Pattern)element).getSource() != accSource) continue;
                        if (accSource instanceof MultiAccumulate) {
                            ((org.drools.core.rule.Pattern)element).getConstraints().forEach(arg_0 -> ((org.drools.core.rule.Pattern)pattern).addConstraint(arg_0));
                            ((org.drools.core.rule.Pattern)element).getDeclarations().values().forEach(d -> {
                                pattern.addDeclaration(d);
                                d.setPattern(pattern);
                            });
                        }
                        group.getChildren().remove(element);
                        break;
                    }
                    pattern.setSource((PatternSource)accSource);
                }
            }
            if (decl.getWindow() != null) {
                pattern.addBehavior(this.createWindow((WindowDefinition)decl.getWindow()));
                ctx.setNeedStreamMode();
            }
        }
        ctx.registerPattern(patternVariable, pattern);
        return pattern;
    }

    private DataProvider createFromDataProvider(RuleContext ctx, From<?> from) {
        if (from instanceof From0) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN((Function0)((From0)from).getProvider()), from.isReactive(), new org.drools.core.rule.Declaration[0]);
        }
        if (from instanceof From1) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN((Function1)((From1)from).getProvider()), from.isReactive(), ctx.getDeclaration(from.getVariable()));
        }
        if (from instanceof From2) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN((Function2)((From2)from).getProvider()), from.isReactive(), ctx.getDeclaration(from.getVariable()), ctx.getDeclaration(((From2)from).getVariable2()));
        }
        if (from instanceof From3) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN((Function3)((From3)from).getProvider()), from.isReactive(), ctx.getDeclaration(from.getVariable()), ctx.getDeclaration(((From3)from).getVariable2()), ctx.getDeclaration(((From3)from).getVariable3()));
        }
        throw new UnsupportedOperationException("Unknown from type " + from);
    }

    private <T> void createWindowReference(RuleContext ctx, WindowReference<T> window) {
        WindowDeclaration windowDeclaration = new WindowDeclaration(window.getName(), ctx.getPkg().getName());
        Declaration variable = FlowDSL.declarationOf((Class)window.getPatternType());
        org.drools.core.rule.Pattern windowPattern = new org.drools.core.rule.Pattern(0, this.getClassObjectType(window.getPatternType()), variable.getName());
        windowDeclaration.setPattern(windowPattern);
        if (window.getEntryPoint() != null) {
            windowPattern.setSource((PatternSource)new EntryPointId(window.getEntryPoint().getName()));
        }
        for (Predicate1 predicate : window.getPredicates()) {
            SingleConstraint1 singleConstraint = new SingleConstraint1(NamesGenerator.generateName((String)"expr"), (Variable)variable, predicate);
            ConstraintEvaluator constraintEvaluator = new ConstraintEvaluator(windowPattern, (SingleConstraint)singleConstraint);
            windowPattern.addConstraint((org.drools.core.spi.Constraint)new LambdaConstraint(constraintEvaluator));
        }
        windowPattern.addBehavior(this.createWindow((WindowDefinition)window));
        ctx.getPkg().addWindowDeclaration(windowDeclaration);
    }

    private Behavior createWindow(WindowDefinition window) {
        switch (window.getType()) {
            case LENGTH: {
                return new SlidingLengthWindow((int)window.getValue());
            }
            case TIME: {
                return new SlidingTimeWindow(window.getValue());
            }
        }
        throw new IllegalArgumentException("Unknown window type: " + window.getType());
    }

    private void addConstraintsToPattern(RuleContext ctx, org.drools.core.rule.Pattern pattern, Constraint constraint) {
        if (constraint.getType() == Constraint.Type.MULTIPLE) {
            for (Constraint child : constraint.getChildren()) {
                this.addConstraintsToPattern(ctx, pattern, child);
            }
            return;
        }
        this.createConstraint(ctx, pattern, constraint).ifPresent(arg_0 -> ((org.drools.core.rule.Pattern)pattern).addConstraint(arg_0));
    }

    private Optional<org.drools.core.spi.Constraint> createConstraint(RuleContext ctx, org.drools.core.rule.Pattern pattern, Constraint constraint) {
        if (constraint.getType() == Constraint.Type.SINGLE) {
            SingleConstraint singleConstraint = (SingleConstraint)constraint;
            return singleConstraint.getVariables().length > 0 ? Optional.of(this.createSingleConstraint(ctx, pattern, singleConstraint)) : Optional.empty();
        }
        List<AbstractConstraint> constraints = constraint.getChildren().stream().map(child -> this.createConstraint(ctx, pattern, (Constraint)child)).filter(Optional::isPresent).map(Optional::get).map(AbstractConstraint.class::cast).collect(Collectors.toList());
        return Optional.of(new CombinedConstraint(constraint.getType(), constraints));
    }

    private org.drools.core.spi.Constraint createSingleConstraint(RuleContext ctx, org.drools.core.rule.Pattern pattern, SingleConstraint singleConstraint) {
        Variable[] vars = singleConstraint.getVariables();
        org.drools.core.rule.Declaration[] declarations = new org.drools.core.rule.Declaration[vars.length];
        org.drools.core.rule.Declaration unificationDeclaration = this.collectConstraintDeclarations(ctx, pattern, singleConstraint, vars, declarations);
        ConstraintEvaluator constraintEvaluator = singleConstraint.isTemporal() ? new TemporalConstraintEvaluator(declarations, pattern, singleConstraint) : new ConstraintEvaluator(declarations, pattern, singleConstraint);
        return unificationDeclaration != null ? new UnificationConstraint(unificationDeclaration, constraintEvaluator) : new LambdaConstraint(constraintEvaluator);
    }

    private org.drools.core.rule.Declaration collectConstraintDeclarations(RuleContext ctx, org.drools.core.rule.Pattern pattern, SingleConstraint singleConstraint, Variable[] vars, org.drools.core.rule.Declaration[] declarations) {
        org.drools.core.rule.Declaration unificationDeclaration = null;
        boolean isEqual = singleConstraint.getIndex() != null && singleConstraint.getIndex().getConstraintType() == Index.ConstraintType.EQUAL;
        for (int i = 0; i < vars.length; ++i) {
            org.drools.core.rule.Declaration accDeclaration;
            declarations[i] = ctx.getDeclaration(vars[i]);
            if (isEqual && declarations[i].getPattern().getObjectType().equals(ClassObjectType.DroolsQuery_ObjectType)) {
                unificationDeclaration = declarations[i];
                continue;
            }
            if (!(pattern.getSource() instanceof MultiAccumulate) || (accDeclaration = (org.drools.core.rule.Declaration)pattern.getDeclarations().get(declarations[i].getBindingName())) == null) continue;
            declarations[i].setReadAccessor(accDeclaration.getExtractor());
        }
        return unificationDeclaration;
    }

    private void addFieldsToPatternWatchlist(org.drools.core.rule.Pattern pattern, String ... fields) {
        if (fields != null && fields.length > 0) {
            HashSet<String> watchlist = pattern.getListenedProperties();
            if (watchlist == null) {
                watchlist = new HashSet<String>();
                pattern.setListenedProperties(watchlist);
            }
            watchlist.addAll(Arrays.asList(fields));
        }
    }

    Collection<InternalKnowledgePackage> getKiePackages() {
        return this.packages.values();
    }

    ObjectType getObjectType(Variable patternVariable) {
        return patternVariable instanceof PrototypeVariable ? this.getPrototypeObjectType(((PrototypeVariable)patternVariable).getPrototype()) : this.getClassObjectType(patternVariable.getType());
    }

    private ObjectType getPrototypeObjectType(Prototype prototype) {
        return this.objectTypeCache.computeIfAbsent(prototype.getFullName(), name -> {
            KnowledgePackageImpl pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(prototype.getPackage(), this::createKiePackage);
            return new FactTemplateObjectType(FactFactory.prototypeToFactTemplate(prototype, pkg));
        });
    }

    private ObjectType getClassObjectType(Class<?> patternClass) {
        return this.objectTypeCache.computeIfAbsent(patternClass.getCanonicalName(), name -> {
            boolean isEvent = false;
            if (!(name.startsWith("java.lang") && !this.packages.containsKey(patternClass.getPackage().getName()) || patternClass.isPrimitive())) {
                KnowledgePackageImpl pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(patternClass.getPackage().getName(), this::createKiePackage);
                TypeDeclaration typeDeclaration = pkg.getTypeDeclaration(patternClass);
                if (typeDeclaration == null) {
                    typeDeclaration = TypeDeclarationUtil.createTypeDeclaration(patternClass);
                    pkg.addTypeDeclaration(typeDeclaration);
                }
                isEvent = typeDeclaration.getRole() == Role.Type.EVENT;
            }
            return new ClassObjectType(patternClass, isEvent);
        });
    }

    private static GroupElement.Type conditionToGroupElementType(Condition.Type type) {
        switch (type) {
            case AND: {
                return GroupElement.Type.AND;
            }
            case OR: {
                return GroupElement.Type.OR;
            }
            case EXISTS: {
                return GroupElement.Type.EXISTS;
            }
            case NOT: {
                return GroupElement.Type.NOT;
            }
        }
        throw new UnsupportedOperationException();
    }
}

