/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands;

import org.jbpm.executor.RequeueAware;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequeueRunningJobsCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(RequeueRunningJobsCommand.class);

    public ExecutionResults execute(CommandContext ctx) {
        Long olderThan = (Long)ctx.getData("MaxRunningTime");
        Long requestId = (Long)ctx.getData("RequestId");
        try {
            ExecutorService executorService = (ExecutorService)ServiceRegistry.get().service(ServiceRegistry.EXECUTOR_SERVICE);
            if (executorService instanceof RequeueAware) {
                if (requestId != null) {
                    logger.info("Requeue jobs by id {}", (Object)requestId);
                    ((RequeueAware)executorService).requeueById(requestId);
                } else {
                    logger.info("Requeue jobs older than {}", (Object)olderThan);
                    ((RequeueAware)executorService).requeue(olderThan);
                }
            } else {
                logger.info("Executor Service is not capable of jobs requeue");
            }
        }
        catch (Exception e) {
            logger.error("Error while requeueing jobs", (Throwable)e);
        }
        ExecutionResults executionResults = new ExecutionResults();
        return executionResults;
    }
}

