/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNCompiler;
import org.kie.dmn.api.core.DMNCompilerConfiguration;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.core.ast.ItemDefNode;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.ast.DecisionServiceNodeImpl;
import org.kie.dmn.core.ast.ItemDefNodeImpl;
import org.kie.dmn.core.compiler.BusinessKnowledgeModelCompiler;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNEvaluatorCompiler;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.DRGElementCompiler;
import org.kie.dmn.core.compiler.DecisionCompiler;
import org.kie.dmn.core.compiler.DecisionServiceCompiler;
import org.kie.dmn.core.compiler.ImportDMNResolverUtil;
import org.kie.dmn.core.compiler.InputDataCompiler;
import org.kie.dmn.core.compiler.ItemDefinitionDependenciesSorter;
import org.kie.dmn.core.compiler.KnowledgeSourceCompiler;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.compiler.execmodelbased.ExecModelDMNEvaluatorCompiler;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.AliasFEELType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.profiles.FEELv12Profile;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.model.api.DecisionTable;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.api.InformationRequirement;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.api.KnowledgeRequirement;
import org.kie.dmn.model.api.NamedElement;
import org.kie.dmn.model.api.OutputClause;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.TInformationItem;
import org.kie.dmn.model.v1_1.extensions.DecisionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNCompilerImpl
implements DMNCompiler {
    private static final Logger logger = LoggerFactory.getLogger(DMNCompilerImpl.class);
    private final DMNEvaluatorCompiler evaluatorCompiler;
    private DMNCompilerConfiguration dmnCompilerConfig;
    private Deque<DRGElementCompiler> drgCompilers = new LinkedList<DRGElementCompiler>();

    public DMNCompilerImpl() {
        this(DMNFactory.newCompilerConfiguration());
    }

    public DMNCompilerImpl(DMNCompilerConfiguration dmnCompilerConfig) {
        this.drgCompilers.add(new InputDataCompiler());
        this.drgCompilers.add(new BusinessKnowledgeModelCompiler());
        this.drgCompilers.add(new DecisionCompiler());
        this.drgCompilers.add(new DecisionServiceCompiler());
        this.drgCompilers.add(new KnowledgeSourceCompiler());
        this.dmnCompilerConfig = dmnCompilerConfig;
        DMNCompilerConfigurationImpl cc = (DMNCompilerConfigurationImpl)dmnCompilerConfig;
        this.addDRGElementCompilers(cc.getDRGElementCompilers());
        this.evaluatorCompiler = cc.isUseExecModelCompiler() ? new ExecModelDMNEvaluatorCompiler(this) : new DMNEvaluatorCompiler(this);
    }

    private void addDRGElementCompiler(DRGElementCompiler compiler) {
        this.drgCompilers.push(compiler);
    }

    private void addDRGElementCompilers(List<DRGElementCompiler> compilers) {
        ListIterator<DRGElementCompiler> listIterator = compilers.listIterator(compilers.size());
        while (listIterator.hasPrevious()) {
            this.addDRGElementCompiler(listIterator.previous());
        }
    }

    public DMNModel compile(Resource resource, Collection<DMNModel> dmnModels) {
        try {
            DMNModel model = this.compile(resource.getReader(), dmnModels);
            if (model == null) {
                return null;
            }
            ((DMNModelImpl)model).setResource(resource);
            return model;
        }
        catch (IOException e) {
            logger.error("Error retrieving reader for resource: " + resource.getSourcePath(), (Throwable)e);
            return null;
        }
    }

    public DMNModel compile(Reader source, Collection<DMNModel> dmnModels) {
        try {
            Definitions dmndefs = this.getMarshaller().unmarshal(source);
            DMNModel model = this.compile(dmndefs, dmnModels);
            return model;
        }
        catch (Exception e) {
            logger.error("Error compiling model from source.", (Throwable)e);
            return null;
        }
    }

    public DMNMarshaller getMarshaller() {
        if (this.dmnCompilerConfig != null && !this.dmnCompilerConfig.getRegisteredExtensions().isEmpty()) {
            return DMNMarshallerFactory.newMarshallerWithExtensions((List)this.getDmnCompilerConfig().getRegisteredExtensions());
        }
        return DMNMarshallerFactory.newDefaultMarshaller();
    }

    public DMNModel compile(Definitions dmndefs, Collection<DMNModel> dmnModels) {
        if (dmndefs == null) {
            return null;
        }
        DMNModelImpl model = new DMNModelImpl(dmndefs);
        model.setRuntimeTypeCheck(((DMNCompilerConfigurationImpl)this.dmnCompilerConfig).getOption(RuntimeTypeCheckOption.class).isRuntimeTypeCheck());
        DMNCompilerConfigurationImpl cc = (DMNCompilerConfigurationImpl)this.dmnCompilerConfig;
        List<FEELProfile> helperFEELProfiles = cc.getFeelProfiles();
        if (dmndefs instanceof org.kie.dmn.model.v1_2.KieDMNModelInstrumentedBase) {
            if (!helperFEELProfiles.stream().anyMatch(FEELv12Profile.class::isInstance)) {
                helperFEELProfiles.clear();
                helperFEELProfiles.add((FEELProfile)new FEELv12Profile());
                helperFEELProfiles.addAll(cc.getFeelProfiles());
            }
        }
        DMNFEELHelper feel = new DMNFEELHelper(cc.getRootClassLoader(), helperFEELProfiles);
        DMNCompilerContext ctx = new DMNCompilerContext(feel);
        if (!dmndefs.getImport().isEmpty()) {
            for (Import i : dmndefs.getImport()) {
                if (ImportDMNResolverUtil.whichImportType(i) == ImportDMNResolverUtil.ImportType.DMN) {
                    Either<String, DMNModel> resolvedResult = ImportDMNResolverUtil.resolveImportDMN(i, dmnModels, m -> new QName(m.getNamespace(), m.getName()));
                    DMNModel located = (DMNModel)resolvedResult.cata(msg -> {
                        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)i, model, null, null, Msg.IMPORT_NOT_FOUND_FOR_NODE, msg, i);
                        return null;
                    }, Function.identity());
                    if (located == null) continue;
                    String iAlias = Optional.ofNullable(i.getName()).orElse(located.getName());
                    model.setImportAliasForNS(iAlias, located.getNamespace(), located.getName());
                    this.importFromModel(model, located, iAlias);
                    continue;
                }
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, null, model, null, null, Msg.IMPORT_TYPE_UNKNOWN, i.getImportType());
            }
        }
        this.processItemDefinitions(ctx, model, dmndefs);
        this.processDrgElements(ctx, model, dmndefs);
        return model;
    }

    private void importFromModel(DMNModelImpl model, DMNModel m, String iAlias) {
        model.addImportChainChild(((DMNModelImpl)m).getImportChain(), iAlias);
        for (ItemDefNode idn : m.getItemDefinitions()) {
            model.getTypeRegistry().registerType(idn.getType());
        }
        for (ItemDefNode idn : m.getInputs()) {
            model.addInput((InputDataNode)idn);
        }
        for (BusinessKnowledgeModelNode bkm : m.getBusinessKnowledgeModels()) {
            model.addBusinessKnowledgeModel(bkm);
        }
        for (DecisionNode dn : m.getDecisions()) {
            model.addDecision(dn);
        }
        for (DecisionServiceNode dsn : m.getDecisionServices()) {
            model.addDecisionService(dsn);
        }
    }

    private void processItemDefinitions(DMNCompilerContext ctx, DMNModelImpl model, Definitions dmndefs) {
        dmndefs.normalize();
        List<ItemDefinition> ordered = new ItemDefinitionDependenciesSorter(model.getNamespace()).sort(dmndefs.getItemDefinition());
        for (ItemDefinition id : ordered) {
            ItemDefNodeImpl idn = new ItemDefNodeImpl(id);
            DMNType type = this.buildTypeDef(ctx, model, idn, id, true);
            idn.setType(type);
            model.addItemDefinition(idn);
        }
    }

    private void processDrgElements(DMNCompilerContext ctx, DMNModelImpl model, Definitions dmndefs) {
        for (DRGElement e : dmndefs.getDrgElement()) {
            boolean foundIt = false;
            for (DRGElementCompiler dRGElementCompiler : this.drgCompilers) {
                if (!dRGElementCompiler.accept(e)) continue;
                foundIt = true;
                dRGElementCompiler.compileNode(e, this, model);
            }
            if (foundIt) continue;
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)e, model, null, null, Msg.UNSUPPORTED_ELEMENT, e.getClass().getSimpleName(), e.getId());
        }
        if (dmndefs.getExtensionElements() != null) {
            DecisionServiceCompiler compiler = new DecisionServiceCompiler();
            List decisionServices = dmndefs.getExtensionElements().getAny().stream().filter(DecisionServices.class::isInstance).map(DecisionServices.class::cast).collect(Collectors.toList());
            for (DecisionServices dss : decisionServices) {
                for (DecisionService ds : dss.getDecisionService()) {
                    if (ds.getVariable() == null) {
                        TInformationItem variable = new TInformationItem();
                        variable.setId(UUID.randomUUID().toString());
                        variable.setName(ds.getName());
                        variable.setParent((DMNModelInstrumentedBase)ds);
                        ds.setVariable((InformationItem)variable);
                    }
                    compiler.compileNode(ds, this, model);
                }
            }
            for (DecisionServiceNode ds : model.getDecisionServices()) {
                DecisionServiceNodeImpl decisionServiceNodeImpl = (DecisionServiceNodeImpl)ds;
                decisionServiceNodeImpl.addModelImportAliases(model.getImportAliasesForNS());
                if (decisionServiceNodeImpl.getEvaluator() != null || !compiler.accept(decisionServiceNodeImpl)) continue;
                compiler.compileEvaluator(decisionServiceNodeImpl, this, ctx, model);
            }
        }
        for (BusinessKnowledgeModelNode bkm : model.getBusinessKnowledgeModels()) {
            BusinessKnowledgeModelNodeImpl bkmi = (BusinessKnowledgeModelNodeImpl)bkm;
            bkmi.addModelImportAliases(model.getImportAliasesForNS());
            for (DRGElementCompiler dRGElementCompiler : this.drgCompilers) {
                if (bkmi.getEvaluator() != null || !dRGElementCompiler.accept((DMNNode)bkm)) continue;
                dRGElementCompiler.compileEvaluator((DMNNode)bkm, this, ctx, model);
            }
        }
        for (DecisionNode d : model.getDecisions()) {
            DecisionNodeImpl di = (DecisionNodeImpl)d;
            di.addModelImportAliases(model.getImportAliasesForNS());
            for (DRGElementCompiler dRGElementCompiler : this.drgCompilers) {
                if (di.getEvaluator() != null || !dRGElementCompiler.accept((DMNNode)d)) continue;
                dRGElementCompiler.compileEvaluator((DMNNode)d, this, ctx, model);
            }
        }
        this.detectCycles(model);
    }

    private void detectCycles(DMNModelImpl model) {
        HashMap<DecisionNodeImpl, Boolean> registry = new HashMap<DecisionNodeImpl, Boolean>();
        for (DecisionNode decision : model.getDecisions()) {
            DecisionNodeImpl decisionNode = (DecisionNodeImpl)decision;
            this.detectCycles(decisionNode, registry, model);
        }
    }

    private void detectCycles(DecisionNodeImpl node, Map<DecisionNodeImpl, Boolean> registry, DMNModelImpl model) {
        if (Boolean.TRUE.equals(registry.get(node))) {
            return;
        }
        if (Boolean.FALSE.equals(registry.put(node, Boolean.FALSE))) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.CYCLIC_DEP_FOR_NODE, node.getName());
            registry.put(node, Boolean.TRUE);
        }
        for (DMNNode dependency : node.getDependencies().values()) {
            if (!(dependency instanceof DecisionNodeImpl)) continue;
            this.detectCycles((DecisionNodeImpl)dependency, registry, model);
        }
        registry.put(node, Boolean.TRUE);
    }

    public void linkRequirements(DMNModelImpl model, DMNBaseNode node) {
        String id;
        for (InformationRequirement ir : node.getInformationRequirement()) {
            if (ir.getRequiredInput() != null) {
                id = DMNCompilerImpl.getId(ir.getRequiredInput());
                InputDataNode input = model.getInputById(id);
                if (input != null) {
                    node.addDependency(input.getName(), (DMNNode)input);
                    continue;
                }
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ir.getRequiredInput(), model, null, null, Msg.REQ_INPUT_NOT_FOUND_FOR_NODE, id, node.getName());
                continue;
            }
            if (ir.getRequiredDecision() == null) continue;
            id = DMNCompilerImpl.getId(ir.getRequiredDecision());
            DecisionNode dn = model.getDecisionById(id);
            if (dn != null) {
                node.addDependency(dn.getName(), (DMNNode)dn);
                continue;
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ir.getRequiredDecision(), model, null, null, Msg.REQ_DECISION_NOT_FOUND_FOR_NODE, id, node.getName());
        }
        for (KnowledgeRequirement kr : node.getKnowledgeRequirement()) {
            if (kr.getRequiredKnowledge() == null) continue;
            id = DMNCompilerImpl.getId(kr.getRequiredKnowledge());
            BusinessKnowledgeModelNode bkmn = model.getBusinessKnowledgeModelById(id);
            DecisionServiceNode dsn = model.getDecisionServiceById(id);
            if (bkmn != null) {
                node.addDependency(bkmn.getName(), (DMNNode)bkmn);
                continue;
            }
            if (dsn != null) {
                node.addDependency(dsn.getName(), (DMNNode)dsn);
                continue;
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)kr.getRequiredKnowledge(), model, null, null, Msg.REQ_BKM_NOT_FOUND_FOR_NODE, id, node.getName());
        }
    }

    public static String getId(DMNElementReference er) {
        String href = er.getHref();
        return href.startsWith("#") ? href.substring(1) : href;
    }

    private DMNType buildTypeDef(DMNCompilerContext ctx, DMNModelImpl dmnModel, DMNNode node, ItemDefinition itemDef, boolean topLevel) {
        BaseDMNTypeImpl type = null;
        if (itemDef.getTypeRef() != null) {
            type = (BaseDMNTypeImpl)this.resolveTypeRef(dmnModel, (NamedElement)itemDef, (DMNModelInstrumentedBase)itemDef, itemDef.getTypeRef());
            if (type != null) {
                DMNType registered;
                UnaryTests allowedValuesStr = itemDef.getAllowedValues();
                if (topLevel || allowedValuesStr != null || itemDef.isIsCollection() != type.isCollection()) {
                    BaseDMNTypeImpl baseType = type;
                    type = type.clone();
                    type.setBaseType(baseType);
                    type.setNamespace(dmnModel.getNamespace());
                    type.setName(itemDef.getName());
                    Type baseFEELType = type.getFeelType();
                    if (baseFEELType instanceof BuiltInType) {
                        type.setFeelType((Type)new AliasFEELType(itemDef.getName(), (BuiltInType)baseFEELType));
                    }
                    type.setAllowedValues(null);
                    if (allowedValuesStr != null) {
                        List<UnaryTest> av = ctx.getFeelHelper().evaluateUnaryTests(ctx, allowedValuesStr.getText(), dmnModel, (DMNElement)itemDef, Msg.ERR_COMPILING_ALLOWED_VALUES_LIST_ON_ITEM_DEF, allowedValuesStr.getText(), node.getName());
                        type.setAllowedValues(av);
                    }
                    if (itemDef.isIsCollection()) {
                        type.setCollection(itemDef.isIsCollection());
                    }
                }
                if (topLevel && (registered = dmnModel.getTypeRegistry().registerType(type)) != type) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)itemDef, dmnModel, null, null, Msg.DUPLICATED_ITEM_DEFINITION, itemDef.getName());
                }
            }
        } else {
            DMNCompilerHelper.checkVariableName(dmnModel, (NamedElement)itemDef, itemDef.getName());
            CompositeTypeImpl compType = new CompositeTypeImpl(dmnModel.getNamespace(), itemDef.getName(), itemDef.getId(), itemDef.isIsCollection());
            DMNType registered = itemDef.getItemComponent().iterator();
            while (registered.hasNext()) {
                ItemDefinition fieldDef = (ItemDefinition)registered.next();
                DMNCompilerHelper.checkVariableName(dmnModel, (NamedElement)fieldDef, fieldDef.getName());
                DMNType fieldType = this.buildTypeDef(ctx, dmnModel, node, fieldDef, false);
                fieldType = fieldType != null ? fieldType : dmnModel.getTypeRegistry().unknown();
                compType.addField(fieldDef.getName(), fieldType);
            }
            type = compType;
            if (topLevel && (registered = dmnModel.getTypeRegistry().registerType(type)) != type) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)itemDef, dmnModel, null, null, Msg.DUPLICATED_ITEM_DEFINITION, itemDef.getName());
            }
        }
        return type;
    }

    public DMNType resolveTypeRef(DMNModelImpl dmnModel, NamedElement model, DMNModelInstrumentedBase localElement, QName typeRef) {
        if (typeRef != null) {
            QName nsAndName = DMNCompilerImpl.getNamespaceAndName(localElement, dmnModel.getImportAliasesForNS(), typeRef);
            DMNType type = dmnModel.getTypeRegistry().resolveType(nsAndName.getNamespaceURI(), nsAndName.getLocalPart());
            if (type == null && localElement.getURIFEEL().equals(nsAndName.getNamespaceURI())) {
                if (model instanceof Decision && ((Decision)model).getExpression() instanceof DecisionTable) {
                    DecisionTable dt = (DecisionTable)((Decision)model).getExpression();
                    if (dt.getOutput().size() > 1) {
                        CompositeTypeImpl compType = new CompositeTypeImpl(dmnModel.getNamespace(), model.getName() + "_Type", model.getId(), dt.getHitPolicy().isMultiHit());
                        for (OutputClause oc : dt.getOutput()) {
                            DMNType fieldType = this.resolveTypeRef(dmnModel, model, (DMNModelInstrumentedBase)oc, oc.getTypeRef());
                            compType.addField(oc.getName(), fieldType);
                        }
                        dmnModel.getTypeRegistry().registerType(compType);
                        return compType;
                    }
                    if (dt.getOutput().size() == 1) {
                        return this.resolveTypeRef(dmnModel, model, (DMNModelInstrumentedBase)dt.getOutput().get(0), ((OutputClause)dt.getOutput().get(0)).getTypeRef());
                    }
                }
            } else if (type == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, localElement, dmnModel, null, null, Msg.UNKNOWN_TYPE_REF_ON_NODE, typeRef.toString(), localElement.getParentDRDElement().getIdentifierString());
                type = dmnModel.getTypeRegistry().unknown();
            }
            return type;
        }
        return dmnModel.getTypeRegistry().unknown();
    }

    /*
     * WARNING - void declaration
     */
    public static QName getNamespaceAndName(DMNModelInstrumentedBase localElement, Map<String, QName> importAliases, QName typeRef) {
        void var4_15;
        if (localElement instanceof KieDMNModelInstrumentedBase) {
            if (!typeRef.getPrefix().equals("")) {
                return new QName(localElement.getNamespaceURI(typeRef.getPrefix()), typeRef.getLocalPart());
            }
            for (Map.Entry<String, QName> entry : importAliases.entrySet()) {
                String prefix = entry.getKey() + ".";
                if (!typeRef.getLocalPart().startsWith(prefix)) continue;
                return new QName(entry.getValue().getNamespaceURI(), typeRef.getLocalPart().replace(prefix, ""));
            }
            return new QName(localElement.getNamespaceURI(typeRef.getPrefix()), typeRef.getLocalPart());
        }
        String string = typeRef.getLocalPart();
        int n = -1;
        switch (string.hashCode()) {
            case -1034364087: {
                if (!string.equals("number")) break;
                boolean bl = false;
                break;
            }
            case -891985903: {
                if (!string.equals("string")) break;
                boolean bl = true;
                break;
            }
            case 64711720: {
                if (!string.equals("boolean")) break;
                int n2 = 2;
                break;
            }
            case -1453897867: {
                if (!string.equals("days and time duration")) break;
                int n3 = 3;
                break;
            }
            case 397061518: {
                if (!string.equals("years and months duration")) break;
                int n4 = 4;
                break;
            }
            case 3076014: {
                if (!string.equals("date")) break;
                int n5 = 5;
                break;
            }
            case 3560141: {
                if (!string.equals("time")) break;
                int n6 = 6;
                break;
            }
            case 981732264: {
                if (!string.equals("date and time")) break;
                int n7 = 7;
            }
        }
        switch (var4_15) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return new QName(localElement.getURIFEEL(), typeRef.getLocalPart());
            }
        }
        for (Map.Entry entry : importAliases.entrySet()) {
            String prefix = (String)entry.getKey() + ".";
            if (!typeRef.getLocalPart().startsWith(prefix)) continue;
            return new QName(((QName)entry.getValue()).getNamespaceURI(), typeRef.getLocalPart().replace(prefix, ""));
        }
        return new QName(localElement.getNamespaceURI(""), typeRef.getLocalPart());
    }

    public DMNCompilerConfiguration getDmnCompilerConfig() {
        return this.dmnCompilerConfig;
    }

    public List<DMNExtensionRegister> getRegisteredExtensions() {
        if (this.dmnCompilerConfig == null) {
            return Collections.emptyList();
        }
        return this.dmnCompilerConfig.getRegisteredExtensions();
    }

    public DMNEvaluatorCompiler getEvaluatorCompiler() {
        return this.evaluatorCompiler;
    }
}

