/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.AnnotationDeclarationError;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.factmodel.GeneratedFact;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.Modifier;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.BodyDeclaration;
import org.drools.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.drools.javaparser.ast.body.ConstructorDeclaration;
import org.drools.javaparser.ast.body.FieldDeclaration;
import org.drools.javaparser.ast.body.MethodDeclaration;
import org.drools.javaparser.ast.comments.JavadocComment;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.LongLiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.NormalAnnotationExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.nodeTypes.NodeWithAnnotations;
import org.drools.javaparser.ast.stmt.BlockStmt;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.ArrayType;
import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.PrimitiveType;
import org.drools.javaparser.ast.type.Type;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.ModelBuilderImpl;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.util.MvelUtil;
import org.kie.api.definition.type.Duration;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;
import org.kie.api.definition.type.Timestamp;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class POJOGenerator {
    private static final String EQUALS = "equals";
    private static final String HASH_CODE = "hashCode";
    private static final String TO_STRING = "toString";
    private static final Statement referenceEquals = JavaParser.parseStatement((String)"if (this == o) { return true; }");
    private static final Statement classCheckEquals = JavaParser.parseStatement((String)"if (o == null || getClass() != o.getClass()) { return false; }");
    public static final Map<String, Class<?>> predefinedClassLevelAnnotation = new HashMap();
    public static final List<String> exprAnnotations;

    public static void generatePOJO(ModelBuilderImpl builder, InternalKnowledgePackage pkg, PackageDescr packageDescr, PackageModel packageModel) {
        TypeResolver typeResolver = pkg.getTypeResolver();
        for (TypeDeclarationDescr typeDescr : packageDescr.getTypeDeclarations()) {
            try {
                POJOGenerator.processType(builder, packageModel, typeDescr, typeResolver.resolveType(typeDescr.getFullTypeName()));
            }
            catch (ClassNotFoundException e) {
                packageModel.addGeneratedPOJO(POJOGenerator.toClassDeclaration(builder, typeDescr, packageDescr, pkg.getTypeResolver()));
                packageModel.addTypeMetaDataExpressions((Expression)POJOGenerator.registerTypeMetaData(pkg.getName() + "." + typeDescr.getTypeName()));
            }
        }
    }

    public static Map<String, Class<?>> compileType(KnowledgeBuilderImpl kbuilder, ClassLoader packageClassLoader, List<GeneratedClassWithPackage> classesWithPackage) {
        return JavaParserCompiler.compileAll(kbuilder, packageClassLoader, classesWithPackage);
    }

    public static void registerType(TypeResolver typeResolver, Map<String, Class<?>> classMap) {
        for (Map.Entry<String, Class<?>> entry : classMap.entrySet()) {
            typeResolver.registerClass(entry.getKey(), entry.getValue());
            typeResolver.registerClass(entry.getValue().getSimpleName(), entry.getValue());
        }
    }

    private static void processType(ModelBuilderImpl builder, PackageModel packageModel, TypeDeclarationDescr typeDescr, Class<?> type) {
        MethodCallExpr typeMetaDataCall = POJOGenerator.registerTypeMetaData(type.getCanonicalName());
        for (AnnotationDescr ann : typeDescr.getAnnotations()) {
            typeMetaDataCall = new MethodCallExpr((Expression)typeMetaDataCall, "addAnnotation");
            typeMetaDataCall.addArgument((Expression)new StringLiteralExpr(ann.getName()));
            for (Map.Entry entry : ann.getValueMap().entrySet()) {
                MethodCallExpr annotationValueCall = new MethodCallExpr(null, "D.annotationValue");
                annotationValueCall.addArgument((Expression)new StringLiteralExpr((String)entry.getKey()));
                String expr = entry.getValue().toString();
                if (exprAnnotations.contains(ann.getName()) && MvelUtil.analyzeExpression(type, expr) == null) {
                    builder.addBuilderResult((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Unable to analyze expression '" + expr + "' for " + ann.getName() + " attribute"));
                }
                annotationValueCall.addArgument(POJOGenerator.quote(expr));
                typeMetaDataCall.addArgument((Expression)annotationValueCall);
            }
        }
        packageModel.addTypeMetaDataExpressions((Expression)typeMetaDataCall);
    }

    private static MethodCallExpr registerTypeMetaData(String className) {
        MethodCallExpr typeMetaDataCall = new MethodCallExpr(null, "D.typeMetaData");
        typeMetaDataCall.addArgument(className + ".class");
        return typeMetaDataCall;
    }

    private static ClassOrInterfaceDeclaration toClassDeclaration(ModelBuilderImpl builder, TypeDeclarationDescr typeDeclaration, PackageDescr packageDescr, TypeResolver typeResolver) {
        boolean hasSuper;
        EnumSet<Modifier> classModifiers = EnumSet.of(Modifier.PUBLIC);
        String generatedClassName = typeDeclaration.getTypeName();
        ClassOrInterfaceDeclaration generatedClass = new ClassOrInterfaceDeclaration(classModifiers, false, generatedClassName);
        generatedClass.addImplementedType(GeneratedFact.class.getName());
        generatedClass.addImplementedType(Serializable.class.getName());
        boolean bl = hasSuper = typeDeclaration.getSuperTypeName() != null;
        if (hasSuper) {
            generatedClass.addExtendedType(typeDeclaration.getSuperTypeName());
        }
        ArrayList<AnnotationDescr> softAnnotations = new ArrayList<AnnotationDescr>();
        for (AnnotationDescr ann : typeDeclaration.getAnnotations()) {
            if (ann.getName().equals("serialVersionUID")) {
                LongLiteralExpr valueExpr = new LongLiteralExpr(ann.getValue("value").toString());
                generatedClass.addFieldWithInitializer((Type)PrimitiveType.longType(), "serialVersionUID", (Expression)valueExpr, new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
                continue;
            }
            POJOGenerator.processAnnotation(builder, typeResolver, (NodeWithAnnotations)generatedClass, ann, softAnnotations);
        }
        if (softAnnotations.size() > 0) {
            String softAnnDictionary = softAnnotations.stream().map(a -> "<dt>" + a.getName() + "</dt><dd>" + a.getValuesAsString() + "</dd>").collect(Collectors.joining());
            JavadocComment generatedClassJavadoc = new JavadocComment("<dl>" + softAnnDictionary + "</dl>");
            generatedClass.setJavadocComment(generatedClassJavadoc);
        }
        generatedClass.addConstructor(new Modifier[]{Modifier.PUBLIC});
        ArrayList<Statement> equalsFieldStatement = new ArrayList<Statement>();
        ArrayList<Statement> hashCodeFieldStatement = new ArrayList<Statement>();
        ArrayList<String> toStringFieldStatement = new ArrayList<String>();
        ArrayList<TypeFieldDescr> keyFields = new ArrayList<TypeFieldDescr>();
        List<TypeFieldDescr> inheritedFields = POJOGenerator.findInheritedDeclaredFields(typeDeclaration, packageDescr);
        TypeFieldDescr[] typeFields = POJOGenerator.typeFieldsSortedByPosition(typeDeclaration);
        if (!inheritedFields.isEmpty() || !typeDeclaration.getFields().isEmpty()) {
            boolean createFullArgsConstructor = typeFields.length < 65;
            ConstructorDeclaration fullArgumentsCtor = null;
            NodeList ctorFieldStatement = null;
            if (createFullArgsConstructor) {
                fullArgumentsCtor = generatedClass.addConstructor(new Modifier[]{Modifier.PUBLIC});
                ctorFieldStatement = NodeList.nodeList((Node[])new Statement[0]);
                MethodCallExpr superCall = new MethodCallExpr(null, "super");
                for (TypeFieldDescr typeFieldDescr : inheritedFields) {
                    String fieldName = typeFieldDescr.getFieldName();
                    POJOGenerator.addCtorArg(fullArgumentsCtor, typeFieldDescr.getPattern().getObjectType(), fieldName);
                    superCall.addArgument(fieldName);
                    if (typeFieldDescr.getAnnotation("key") == null) continue;
                    keyFields.add(typeFieldDescr);
                }
                ctorFieldStatement.add((Node)new ExpressionStmt((Expression)superCall));
            }
            int position = inheritedFields.size();
            for (TypeFieldDescr typeFieldDescr : typeFields) {
                String fieldName = typeFieldDescr.getFieldName();
                Type returnType = JavaParser.parseType((String)typeFieldDescr.getPattern().getObjectType());
                if (createFullArgsConstructor) {
                    POJOGenerator.addCtorArg(fullArgumentsCtor, returnType, fieldName);
                    ctorFieldStatement.add((Node)POJOGenerator.replaceFieldName(JavaParser.parseStatement((String)"this.__fieldName = __fieldName;"), fieldName));
                }
                FieldDeclaration field = typeFieldDescr.getInitExpr() == null ? generatedClass.addField(returnType, fieldName, new Modifier[]{Modifier.PRIVATE}) : generatedClass.addFieldWithInitializer(returnType, fieldName, JavaParser.parseExpression((String)typeFieldDescr.getInitExpr()), new Modifier[]{Modifier.PRIVATE});
                field.createSetter();
                MethodDeclaration getter = field.createGetter();
                toStringFieldStatement.add(MessageFormat.format("+ {0}+{1}", POJOGenerator.quote(fieldName + "="), fieldName));
                boolean hasPositionAnnotation = false;
                for (AnnotationDescr ann : typeFieldDescr.getAnnotations()) {
                    if (ann.getName().equalsIgnoreCase("key")) {
                        keyFields.add(typeFieldDescr);
                        field.addAnnotation(Key.class.getName());
                        equalsFieldStatement.add(POJOGenerator.generateEqualsForField(getter, fieldName));
                        hashCodeFieldStatement.add(POJOGenerator.generateHashCodeForField(getter, fieldName));
                        continue;
                    }
                    if (ann.getName().equalsIgnoreCase("position")) {
                        field.addAndGetAnnotation(Position.class.getName()).addPair("value", "" + ann.getValue());
                        hasPositionAnnotation = true;
                        ++position;
                        continue;
                    }
                    if (ann.getName().equalsIgnoreCase("duration") || ann.getName().equalsIgnoreCase("expires") || ann.getName().equalsIgnoreCase("timestamp")) {
                        Class<?> annotationClass = predefinedClassLevelAnnotation.get(ann.getName().toLowerCase());
                        String annFqn = annotationClass.getCanonicalName();
                        NormalAnnotationExpr annExpr = generatedClass.addAndGetAnnotation(annFqn);
                        annExpr.addPair("value", POJOGenerator.quote(fieldName));
                        continue;
                    }
                    POJOGenerator.processAnnotation(builder, typeResolver, (NodeWithAnnotations)field, ann, null);
                }
                if (!hasPositionAnnotation) {
                    field.addAndGetAnnotation(Position.class.getName()).addPair("value", "" + position++);
                }
                if (!createFullArgsConstructor) continue;
                fullArgumentsCtor.setBody(new BlockStmt(ctorFieldStatement));
            }
            if (!keyFields.isEmpty() && keyFields.size() != inheritedFields.size() + typeFields.length) {
                ConstructorDeclaration keyArgumentsCtor = generatedClass.addConstructor(new Modifier[]{Modifier.PUBLIC});
                NodeList ctorKeyFieldStatement = NodeList.nodeList((Node[])new Statement[0]);
                MethodCallExpr keySuperCall = new MethodCallExpr(null, "super");
                ctorKeyFieldStatement.add((Node)new ExpressionStmt((Expression)keySuperCall));
                for (TypeFieldDescr typeFieldDescr : keyFields) {
                    String fieldName = typeFieldDescr.getFieldName();
                    POJOGenerator.addCtorArg(keyArgumentsCtor, typeFieldDescr.getPattern().getObjectType(), fieldName);
                    if (typeDeclaration.getFields().get(fieldName) != null) {
                        ctorKeyFieldStatement.add((Node)POJOGenerator.replaceFieldName(JavaParser.parseStatement((String)"this.__fieldName = __fieldName;"), fieldName));
                        continue;
                    }
                    keySuperCall.addArgument(fieldName);
                }
                keyArgumentsCtor.setBody(new BlockStmt(ctorKeyFieldStatement));
            }
            if (!keyFields.isEmpty()) {
                generatedClass.addMember((BodyDeclaration)POJOGenerator.generateEqualsMethod(generatedClassName, equalsFieldStatement, hasSuper));
                generatedClass.addMember((BodyDeclaration)POJOGenerator.generateHashCodeMethod(hashCodeFieldStatement, hasSuper));
            }
        }
        generatedClass.addMember((BodyDeclaration)POJOGenerator.generateToStringMethod(generatedClassName, toStringFieldStatement));
        return generatedClass;
    }

    private static void processAnnotation(ModelBuilderImpl builder, TypeResolver typeResolver, NodeWithAnnotations node, AnnotationDescr ann, List<AnnotationDescr> softAnnotations) {
        String annFqn;
        Class annotationClass = predefinedClassLevelAnnotation.get(ann.getName());
        if (annotationClass == null) {
            try {
                annotationClass = typeResolver.resolveType(ann.getName());
            }
            catch (ClassNotFoundException e) {
                return;
            }
        }
        if ((annFqn = annotationClass.getCanonicalName()) != null) {
            NormalAnnotationExpr annExpr = node.addAndGetAnnotation(annFqn);
            for (Map.Entry entry : ann.getValueMap().entrySet()) {
                try {
                    annotationClass.getMethod((String)entry.getKey(), new Class[0]);
                    annExpr.addPair((String)entry.getKey(), POJOGenerator.getAnnotationValue(annFqn, (String)entry.getKey(), entry.getValue()));
                }
                catch (NoSuchMethodException e) {
                    if (softAnnotations != null) continue;
                    builder.addBuilderResult((KnowledgeBuilderResult)new AnnotationDeclarationError(ann, "Unknown annotation property " + (String)entry.getKey()));
                }
            }
        } else if (softAnnotations != null) {
            softAnnotations.add(ann);
        }
    }

    private static TypeFieldDescr[] typeFieldsSortedByPosition(TypeDeclarationDescr typeDeclaration) {
        Collection typeFields = typeDeclaration.getFields().values();
        TypeFieldDescr[] sortedTypes = new TypeFieldDescr[typeFields.size()];
        ArrayList<TypeFieldDescr> nonPositionalFields = new ArrayList<TypeFieldDescr>();
        for (TypeFieldDescr descr : typeFields) {
            AnnotationDescr ann = descr.getAnnotation("Position");
            if (ann == null) {
                nonPositionalFields.add(descr);
                continue;
            }
            int pos = Integer.parseInt(ann.getValue().toString());
            sortedTypes[pos] = descr;
        }
        int counter = 0;
        for (TypeFieldDescr descr : nonPositionalFields) {
            while (sortedTypes[counter] != null) {
                ++counter;
            }
            sortedTypes[counter++] = descr;
        }
        return sortedTypes;
    }

    private static void addCtorArg(ConstructorDeclaration fullArgumentsCtor, String typeName, String fieldName) {
        POJOGenerator.addCtorArg(fullArgumentsCtor, JavaParser.parseType((String)typeName), fieldName);
    }

    private static void addCtorArg(ConstructorDeclaration fullArgumentsCtor, Type fieldType, String fieldName) {
        fullArgumentsCtor.addParameter(fieldType, fieldName);
    }

    private static List<TypeFieldDescr> findInheritedDeclaredFields(TypeDeclarationDescr typeDeclaration, PackageDescr packageDescr) {
        return POJOGenerator.findInheritedDeclaredFields(new ArrayList<TypeFieldDescr>(), POJOGenerator.getSuperType(typeDeclaration, packageDescr), packageDescr);
    }

    private static List<TypeFieldDescr> findInheritedDeclaredFields(List<TypeFieldDescr> fields, Optional<TypeDeclarationDescr> supertType, PackageDescr packageDescr) {
        supertType.ifPresent(st -> {
            POJOGenerator.findInheritedDeclaredFields(fields, POJOGenerator.getSuperType(st, packageDescr), packageDescr);
            fields.addAll(st.getFields().values());
        });
        return fields;
    }

    private static Optional<TypeDeclarationDescr> getSuperType(TypeDeclarationDescr typeDeclaration, PackageDescr packageDescr) {
        return typeDeclaration.getSuperTypeName() != null ? packageDescr.getTypeDeclarations().stream().filter(td -> td.getTypeName().equals(typeDeclaration.getSuperTypeName())).findFirst() : Optional.empty();
    }

    private static MethodDeclaration generateEqualsMethod(String generatedClassName, Collection<Statement> equalsFieldStatement, boolean hasSuper) {
        NodeList equalsStatements = NodeList.nodeList((Node[])new Statement[]{referenceEquals, classCheckEquals});
        equalsStatements.add((Node)POJOGenerator.classCastStatement(generatedClassName));
        if (hasSuper) {
            equalsStatements.add((Node)JavaParser.parseStatement((String)"if ( !super.equals( o ) ) return false;"));
        }
        equalsStatements.addAll(equalsFieldStatement);
        equalsStatements.add((Node)JavaParser.parseStatement((String)"return true;"));
        Type returnType = JavaParser.parseType((String)Boolean.TYPE.getSimpleName());
        MethodDeclaration equals = new MethodDeclaration(EnumSet.of(Modifier.PUBLIC), returnType, EQUALS);
        equals.addParameter(Object.class, "o");
        equals.addAnnotation("Override");
        equals.setBody(new BlockStmt(equalsStatements));
        return equals;
    }

    private static Statement classCastStatement(String className) {
        Statement statement = JavaParser.parseStatement((String)"__className that = (__className) o;");
        statement.findAll(ClassOrInterfaceType.class).stream().filter(n1 -> n1.getName().toString().equals("__className")).forEach(n -> n.replace((Node)DrlxParseUtil.toClassOrInterfaceType(className)));
        return statement;
    }

    private static Statement generateEqualsForField(MethodDeclaration getter, String fieldName) {
        Statement statement;
        Type type = getter.getType();
        if (type instanceof ClassOrInterfaceType) {
            statement = JavaParser.parseStatement((String)" if( __fieldName != null ? !__fieldName.equals(that.__fieldName) : that.__fieldName != null) { return false; }");
        } else if (type instanceof ArrayType) {
            Type componentType = ((ArrayType)type).getComponentType();
            statement = componentType instanceof PrimitiveType ? JavaParser.parseStatement((String)(" if( !java.util.Arrays.equals((" + componentType + "[])__fieldName, (" + componentType + "[])that.__fieldName)) { return false; }")) : JavaParser.parseStatement((String)" if( !java.util.Arrays.equals((Object[])__fieldName, (Object[])that.__fieldName)) { return false; }");
        } else if (type instanceof PrimitiveType) {
            statement = JavaParser.parseStatement((String)" if( __fieldName != that.__fieldName) { return false; }");
        } else {
            throw new RuntimeException("Unknown type");
        }
        return POJOGenerator.replaceFieldName(statement, fieldName);
    }

    private static Statement replaceFieldName(Statement statement, String fieldName) {
        statement.findAll(NameExpr.class).stream().filter(n -> n.getName().toString().equals("__fieldName")).forEach(n -> n.replace((Node)new NameExpr(fieldName)));
        statement.findAll(FieldAccessExpr.class).stream().filter(n -> n.getName().toString().equals("__fieldName")).forEach(n -> n.replace((Node)new FieldAccessExpr(n.getScope(), fieldName)));
        return statement;
    }

    private static MethodDeclaration generateHashCodeMethod(Collection<Statement> hashCodeFieldStatement, boolean hasSuper) {
        Statement header = JavaParser.parseStatement((String)(hasSuper ? "int result = super.hashCode();" : "int result = 1;"));
        NodeList hashCodeStatements = NodeList.nodeList((Node[])new Statement[]{header});
        hashCodeStatements.addAll(hashCodeFieldStatement);
        hashCodeStatements.add((Node)JavaParser.parseStatement((String)"return result;"));
        Type returnType = JavaParser.parseType((String)Integer.TYPE.getSimpleName());
        MethodDeclaration equals = new MethodDeclaration(EnumSet.of(Modifier.PUBLIC), returnType, HASH_CODE);
        equals.addAnnotation("Override");
        equals.setBody(new BlockStmt(hashCodeStatements));
        return equals;
    }

    private static Statement generateHashCodeForField(MethodDeclaration getter, String fieldName) {
        Type type = getter.getType();
        if (type instanceof ClassOrInterfaceType) {
            return JavaParser.parseStatement((String)MessageFormat.format("result = 31 * result + ({0} != null ? {0}.hashCode() : 0);", fieldName));
        }
        if (type instanceof ArrayType) {
            Type componentType = ((ArrayType)type).getComponentType();
            if (componentType instanceof PrimitiveType) {
                return JavaParser.parseStatement((String)MessageFormat.format("result = 31 * result + ({0} != null ? java.util.Arrays.hashCode((" + componentType + "[]){0}) : 0);", fieldName));
            }
            return JavaParser.parseStatement((String)MessageFormat.format("result = 31 * result + ({0} != null ? java.util.Arrays.hashCode((Object[]){0}) : 0);", fieldName));
        }
        if (type instanceof PrimitiveType) {
            String primitiveToInt = fieldName;
            PrimitiveType.Primitive primitiveType = ((PrimitiveType)type).getType();
            switch (primitiveType) {
                case BOOLEAN: {
                    primitiveToInt = MessageFormat.format("({0} ? 1231 : 1237)", fieldName);
                    break;
                }
                case DOUBLE: {
                    primitiveToInt = MessageFormat.format("(int) (Double.doubleToLongBits({0}) ^ (Double.doubleToLongBits({0}) >>> 32))", fieldName);
                    break;
                }
                case FLOAT: {
                    primitiveToInt = MessageFormat.format("Float.floatToIntBits({0})", fieldName);
                    break;
                }
                case LONG: {
                    primitiveToInt = MessageFormat.format("(int) ({0} ^ ({0} >>> 32))", fieldName);
                }
            }
            return JavaParser.parseStatement((String)MessageFormat.format("result = 31 * result + {0};", primitiveToInt));
        }
        throw new RuntimeException("Unknown type");
    }

    private static MethodDeclaration generateToStringMethod(String generatedClassName, List<String> toStringFieldStatement) {
        String header = MessageFormat.format("return {0} + {1}", POJOGenerator.quote(generatedClassName), POJOGenerator.quote("( "));
        String body = String.join((CharSequence)MessageFormat.format("+ {0}", POJOGenerator.quote(", ")), toStringFieldStatement);
        String close = MessageFormat.format("+{0};", POJOGenerator.quote(" )"));
        Statement toStringStatement = JavaParser.parseStatement((String)(header + body + close));
        Type returnType = JavaParser.parseType((String)String.class.getSimpleName());
        MethodDeclaration equals = new MethodDeclaration(EnumSet.of(Modifier.PUBLIC), returnType, TO_STRING);
        equals.addAnnotation("Override");
        equals.setBody(new BlockStmt(NodeList.nodeList((Node[])new Statement[]{toStringStatement})));
        return equals;
    }

    private static String quote(String str) {
        return "\"" + str.replace("\"", "\\\"") + "\"";
    }

    private static String getAnnotationValue(String annotationName, String valueName, Object value) {
        if (value instanceof Class) {
            return ((Class)value).getName() + ".class";
        }
        if (value.getClass().isArray()) {
            String valueString = Stream.of((Object[])value).map(Object::toString).collect(Collectors.joining(",", "{", "}"));
            return valueString.replace('[', '{').replace(']', '}');
        }
        return POJOGenerator.getAnnotationValue(annotationName, valueName, value.toString());
    }

    private static String getAnnotationValue(String annotationName, String valueName, String value) {
        if (annotationName.equals(Role.class.getCanonicalName())) {
            return Role.Type.class.getCanonicalName() + "." + value.toUpperCase();
        }
        if (annotationName.equals(Expires.class.getCanonicalName())) {
            if ("value".equals(valueName)) {
                return POJOGenerator.quote(value);
            }
            if ("policy".equals(valueName)) {
                return Expires.Policy.class.getCanonicalName() + "." + value.toUpperCase();
            }
            throw new UnsupportedOperationException("Unrecognized annotation value for Expires: " + valueName);
        }
        if ((annotationName.equals(Duration.class.getCanonicalName()) || annotationName.equals(Timestamp.class.getCanonicalName())) && "value".equals(valueName)) {
            return POJOGenerator.quote(value);
        }
        return value;
    }

    static {
        predefinedClassLevelAnnotation.put("role", Role.class);
        predefinedClassLevelAnnotation.put("duration", Duration.class);
        predefinedClassLevelAnnotation.put("expires", Expires.class);
        predefinedClassLevelAnnotation.put("timestamp", Timestamp.class);
        exprAnnotations = Arrays.asList("duration", "timestamp");
    }
}

