/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.humantask;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.test.JBPMHelper;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;

public class HumanTaskExample {
    public static final void main(String[] args) {
        try {
            RuntimeManager manager = HumanTaskExample.getRuntimeManager("humantask/HumanTask.bpmn");
            RuntimeEngine runtime = manager.getRuntimeEngine(null);
            KieSession ksession = runtime.getKieSession();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("userId", "krisv");
            params.put("description", "Need a new laptop computer");
            ksession.startProcess("com.sample.humantask", params);
            TaskService taskService = runtime.getTaskService();
            TaskSummary task1 = taskService.getTasksAssignedAsPotentialOwner("sales-rep", "en-UK").get(0);
            System.out.println("Sales-rep executing task " + task1.getName() + "(" + task1.getId() + ": " + task1.getDescription() + ")");
            taskService.claim(task1.getId(), "sales-rep");
            taskService.start(task1.getId(), "sales-rep");
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("comment", "Agreed, existing laptop needs replacing");
            results.put("outcome", "Accept");
            taskService.complete(task1.getId(), "sales-rep", results);
            TaskSummary task2 = taskService.getTasksAssignedAsPotentialOwner("krisv", "en-UK").get(0);
            System.out.println("krisv executing task " + task2.getName() + "(" + task2.getId() + ": " + task2.getDescription() + ")");
            taskService.start(task2.getId(), "krisv");
            results = new HashMap();
            results.put("outcome", "Agree");
            taskService.complete(task2.getId(), "krisv", results);
            TaskSummary task3 = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK").get(0);
            System.out.println("john executing task " + task3.getName() + "(" + task3.getId() + ": " + task3.getDescription() + ")");
            taskService.claim(task3.getId(), "john");
            taskService.start(task3.getId(), "john");
            results = new HashMap();
            results.put("outcome", "Agree");
            taskService.complete(task3.getId(), "john", results);
            TaskSummary task4 = taskService.getTasksAssignedAsPotentialOwner("sales-rep", "en-UK").get(0);
            System.out.println("sales-rep executing task " + task4.getName() + "(" + task4.getId() + ": " + task4.getDescription() + ")");
            taskService.start(task4.getId(), "sales-rep");
            Map<String, Object> content = taskService.getTaskContent(task4.getId());
            for (Map.Entry<String, Object> entry : content.entrySet()) {
                System.out.println(entry.getKey() + " = " + entry.getValue());
            }
            taskService.complete(task4.getId(), "sales-rep", null);
            System.out.println("Process instance completed");
            manager.disposeRuntimeEngine(runtime);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    private static RuntimeManager getRuntimeManager(String process) {
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(new UserGroupCallback(){

            @Override
            public List<String> getGroupsForUser(String userId) {
                ArrayList<String> result = new ArrayList<String>();
                if ("sales-rep".equals(userId)) {
                    result.add("sales");
                } else if ("john".equals(userId)) {
                    result.add("PM");
                }
                return result;
            }

            @Override
            public boolean existsUser(String arg0) {
                return true;
            }

            @Override
            public boolean existsGroup(String arg0) {
                return true;
            }
        }).addAsset(KieServices.Factory.get().getResources().newClassPathResource(process), ResourceType.BPMN2).get();
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
    }
}

