/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.printer;

import java.util.List;
import java.util.stream.Collectors;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.metamodel.NodeMetaModel;
import org.drools.javaparser.metamodel.PropertyMetaModel;
import org.drools.javaparser.utils.SeparatedItemStringBuilder;
import org.drools.javaparser.utils.Utils;

public class JsonPrinter {
    private final boolean outputNodeType;

    public JsonPrinter(boolean outputNodeType) {
        this.outputNodeType = outputNodeType;
    }

    public String output(Node node) {
        return this.output(node, null, 0);
    }

    public String output(Node node, String name, int level) {
        Utils.assertNotNull(node);
        NodeMetaModel metaModel = node.getMetaModel();
        List<PropertyMetaModel> allPropertyMetaModels = metaModel.getAllPropertyMetaModels();
        List attributes = allPropertyMetaModels.stream().filter(PropertyMetaModel::isAttribute).filter(PropertyMetaModel::isSingular).collect(Collectors.toList());
        List subNodes = allPropertyMetaModels.stream().filter(PropertyMetaModel::isNode).filter(PropertyMetaModel::isSingular).collect(Collectors.toList());
        List subLists = allPropertyMetaModels.stream().filter(PropertyMetaModel::isNodeList).collect(Collectors.toList());
        SeparatedItemStringBuilder content = name == null ? new SeparatedItemStringBuilder("{", ",", "}") : new SeparatedItemStringBuilder(JsonPrinter.q(name) + ":{", ",", "}");
        if (this.outputNodeType) {
            content.append(JsonPrinter.q("type") + ":" + JsonPrinter.q(metaModel.getTypeName()), new Object[0]);
        }
        for (PropertyMetaModel attributeMetaModel : attributes) {
            content.append(JsonPrinter.q(attributeMetaModel.getName()) + ":" + JsonPrinter.q(attributeMetaModel.getValue(node).toString()), new Object[0]);
        }
        for (PropertyMetaModel subNodeMetaModel : subNodes) {
            Node value = (Node)subNodeMetaModel.getValue(node);
            if (value == null) continue;
            content.append(this.output(value, subNodeMetaModel.getName(), level + 1), new Object[0]);
        }
        for (PropertyMetaModel subListMetaModel : subLists) {
            NodeList subList = (NodeList)subListMetaModel.getValue(node);
            if (subList == null || subList.isEmpty()) continue;
            SeparatedItemStringBuilder listContent = new SeparatedItemStringBuilder(JsonPrinter.q(subListMetaModel.getName()) + ":[", ",", "]");
            for (Node subListNode : subList) {
                listContent.append(this.output(subListNode, null, level + 1), new Object[0]);
            }
            content.append(listContent.toString(), new Object[0]);
        }
        return content.toString();
    }

    private static String q(String value) {
        return "\"" + value + "\"";
    }
}

