/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.appformer.maven.support.DependencyFilter;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.impl.AbstractDeploymentService;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.FormManagerService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptor;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.KModuleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorManager;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorMerger;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.model.DeployedAsset;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.definition.process.Process;
import org.kie.api.executor.ExecutorService;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.remote.Remotable;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.ObjectModelResolver;
import org.kie.internal.runtime.conf.ObjectModelResolverProvider;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.scanner.KieMavenRepository;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class KModuleDeploymentService
extends AbstractDeploymentService {
    protected static Logger logger = LoggerFactory.getLogger(KModuleDeploymentService.class);
    private static final String DEFAULT_KBASE_NAME = "defaultKieBase";
    private static final String PROCESS_ID_XPATH = "/*[local-name() = 'definitions']/*[local-name() = 'process']/@id";
    private static final String CASE_ID_XPATH = "/*[local-name() = 'definitions']/*[local-name() = 'case']/@id";
    protected DefinitionService bpmn2Service;
    protected DeploymentDescriptorMerger merger = new DeploymentDescriptorMerger();
    protected FormManagerService formManagerService;
    protected ExecutorService executorService;
    protected XPathExpression processIdXPathExpression;
    protected XPathExpression caseIdXPathExpression;

    public KModuleDeploymentService() {
        try {
            this.processIdXPathExpression = XPathFactory.newInstance().newXPath().compile(PROCESS_ID_XPATH);
            this.caseIdXPathExpression = XPathFactory.newInstance().newXPath().compile(CASE_ID_XPATH);
        }
        catch (XPathExpressionException e) {
            logger.error("Unable to parse '{}' XPath expression due to {}", (Object)PROCESS_ID_XPATH, (Object)e.getMessage());
        }
        ServiceRegistry.get().register(DeploymentService.class.getSimpleName(), (Object)this);
    }

    public void onInit() {
        EntityManagerFactoryManager.get().addEntityManagerFactory("org.jbpm.domain", this.getEmf());
    }

    @Override
    public void deploy(DeploymentUnit unit) {
        try {
            Collection dependencies;
            InternalKieModule module;
            super.deploy(unit);
            if (!(unit instanceof KModuleDeploymentUnit)) {
                throw new IllegalArgumentException("Invalid deployment unit provided - " + unit.getClass().getName());
            }
            KModuleDeploymentUnit kmoduleUnit = (KModuleDeploymentUnit)unit;
            DeployedUnitImpl deployedUnit = new DeployedUnitImpl(unit);
            deployedUnit.setActive(kmoduleUnit.isActive());
            KieContainer kieContainer = kmoduleUnit.getKieContainer();
            ReleaseId releaseId = null;
            if (kieContainer == null) {
                KieServices ks = KieServices.Factory.get();
                releaseId = ks.newReleaseId(kmoduleUnit.getGroupId(), kmoduleUnit.getArtifactId(), kmoduleUnit.getVersion());
                KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
                repository.resolveArtifact(releaseId.toExternalForm());
                kieContainer = ks.newKieContainer(releaseId);
                kmoduleUnit.setKieContainer(kieContainer);
            }
            releaseId = kieContainer.getReleaseId();
            String kbaseName = kmoduleUnit.getKbaseName();
            if (StringUtils.isEmpty((CharSequence)kbaseName)) {
                KieBaseModel defaultKBaseModel = ((KieContainerImpl)kieContainer).getKieProject().getDefaultKieBaseModel();
                kbaseName = defaultKBaseModel != null ? defaultKBaseModel.getName() : DEFAULT_KBASE_NAME;
            }
            if ((module = (InternalKieModule)((KieContainerImpl)kieContainer).getKieModuleForKBase(kbaseName)) == null) {
                throw new IllegalStateException("Cannot find kbase, either it does not exist or there are multiple default kbases in kmodule.xml");
            }
            KieBase kbase = kieContainer.getKieBase(kbaseName);
            HashMap<String, ProcessDescriptor> processDescriptors = new HashMap<String, ProcessDescriptor>();
            for (Process process : kbase.getProcesses()) {
                processDescriptors.put(process.getId(), ((ProcessDescriptor)process.getMetaData().get("ProcessDescriptor")).clone());
            }
            Collection files = module.getFileNames();
            this.processResources(module, files, kieContainer, kmoduleUnit, deployedUnit, releaseId, processDescriptors);
            if (module.getKieDependencies() != null) {
                dependencies = module.getKieDependencies().values();
                for (InternalKieModule depModule : dependencies) {
                    logger.debug("Processing dependency module " + depModule.getReleaseId());
                    files = depModule.getFileNames();
                    this.processResources(depModule, files, kieContainer, kmoduleUnit, deployedUnit, depModule.getReleaseId(), processDescriptors);
                }
            }
            if ((dependencies = module.getJarDependencies((DependencyFilter)new DependencyFilter.ExcludeScopeFilter(new String[]{"test", "provided"}))) != null && !dependencies.isEmpty()) {
                this.processClassloader(kieContainer, deployedUnit);
            }
            AuditEventBuilder auditLoggerBuilder = this.setupAuditLogger(this.identityProvider, unit.getIdentifier());
            RuntimeEnvironmentBuilder builder = this.boostrapRuntimeEnvironmentBuilder(kmoduleUnit, deployedUnit, kieContainer, kmoduleUnit.getMergeMode()).knowledgeBase(kbase).classLoader(kieContainer.getClassLoader());
            builder.registerableItemsFactory(this.getRegisterableItemsFactory(auditLoggerBuilder, kieContainer, kmoduleUnit));
            this.commonDeploy(unit, deployedUnit, builder.get(), kieContainer);
            kmoduleUnit.setDeployed(true);
        }
        catch (Throwable e) {
            logger.warn("Unexpected error while deploying unit {}", (Object)unit.getIdentifier(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    protected RegisterableItemsFactory getRegisterableItemsFactory(AuditEventBuilder auditLoggerBuilder, KieContainer kieContainer, KModuleDeploymentUnit unit) {
        KModuleRegisterableItemsFactory factory = new KModuleRegisterableItemsFactory(kieContainer, unit.getKsessionName());
        factory.setAuditBuilder(auditLoggerBuilder);
        return factory;
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        if (!(unit instanceof KModuleDeploymentUnit)) {
            throw new IllegalArgumentException("Invalid deployment unit provided - " + unit.getClass().getName());
        }
        KModuleDeploymentUnit kmoduleUnit = (KModuleDeploymentUnit)unit;
        super.undeploy(unit);
        this.formManagerService.unRegisterForms(unit.getIdentifier());
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId = ks.newReleaseId(kmoduleUnit.getGroupId(), kmoduleUnit.getArtifactId(), kmoduleUnit.getVersion());
        ks.getRepository().removeKieModule(releaseId);
    }

    protected RuntimeEnvironmentBuilder boostrapRuntimeEnvironmentBuilder(KModuleDeploymentUnit deploymentUnit, DeployedUnit deployedUnit, KieContainer kieContainer, MergeMode mode) {
        List remoteableClasses;
        List requiredRoles;
        Iterator entry;
        List descriptorHierarchy;
        DeploymentDescriptorManager descriptorManager;
        DeploymentDescriptor descriptor = deploymentUnit.getDeploymentDescriptor();
        if (descriptor == null || ((DeploymentDescriptorImpl)descriptor).isEmpty()) {
            descriptorManager = new DeploymentDescriptorManager("org.jbpm.domain");
            descriptorHierarchy = descriptorManager.getDeploymentDescriptorHierarchy(kieContainer);
            descriptor = this.merger.merge(descriptorHierarchy, mode);
            deploymentUnit.setDeploymentDescriptor(descriptor);
        } else if (descriptor != null && !deploymentUnit.isDeployed()) {
            descriptorManager = new DeploymentDescriptorManager("org.jbpm.domain");
            descriptorHierarchy = descriptorManager.getDeploymentDescriptorHierarchy(kieContainer);
            descriptorHierarchy.add(0, descriptor);
            descriptor = this.merger.merge(descriptorHierarchy, mode);
            deploymentUnit.setDeploymentDescriptor(descriptor);
        }
        deploymentUnit.setStrategy(descriptor.getRuntimeStrategy());
        RuntimeEnvironmentBuilder builder = null;
        builder = descriptor.getPersistenceMode() == PersistenceMode.NONE ? RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder() : RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder();
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate(descriptor.getPersistenceUnit());
        builder.entityManagerFactory((Object)emf);
        HashMap<String, Object> contaxtParams = new HashMap<String, Object>();
        contaxtParams.put("entityManagerFactory", emf);
        contaxtParams.put("classLoader", kieContainer.getClassLoader());
        for (NamedObjectModel model : descriptor.getEnvironmentEntries()) {
            entry = this.getInstanceFromModel((ObjectModel)model, kieContainer, contaxtParams);
            builder.addEnvironmentEntry(model.getName(), (Object)entry);
        }
        for (NamedObjectModel model : descriptor.getConfiguration()) {
            entry = this.getInstanceFromModel((ObjectModel)model, kieContainer, contaxtParams);
            builder.addConfiguration(model.getName(), (String)((Object)entry));
        }
        ObjectMarshallingStrategy[] mStrategies = new ObjectMarshallingStrategy[descriptor.getMarshallingStrategies().size() + 1];
        int index = 0;
        for (Object model : descriptor.getMarshallingStrategies()) {
            Object strategy = this.getInstanceFromModel((ObjectModel)model, kieContainer, contaxtParams);
            mStrategies[index] = (ObjectMarshallingStrategy)strategy;
            ++index;
        }
        mStrategies[index] = new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT);
        builder.addEnvironmentEntry("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)mStrategies);
        builder.addEnvironmentEntry("KieDeploymentDescriptor", (Object)descriptor);
        builder.addEnvironmentEntry("KieContainer", (Object)kieContainer);
        if (this.executorService != null) {
            builder.addEnvironmentEntry("ExecutorService", (Object)this.executorService);
        }
        if (this.identityProvider != null) {
            builder.addEnvironmentEntry("org.kie.internal.identity.IdentityProvider", (Object)this.identityProvider);
        }
        if ((requiredRoles = descriptor.getRequiredRoles("view")) != null && !requiredRoles.isEmpty()) {
            for (DeployedAsset desc : deployedUnit.getDeployedAssets()) {
                if (!(desc instanceof ProcessAssetDesc)) continue;
                ((ProcessAssetDesc)desc).setRoles(requiredRoles);
            }
        }
        if ((remoteableClasses = descriptor.getClasses()) != null && !remoteableClasses.isEmpty()) {
            for (String className : remoteableClasses) {
                Class<?> descriptorClass = null;
                try {
                    descriptorClass = kieContainer.getClassLoader().loadClass(className);
                    logger.debug("Loaded {} into the classpath from deployment descriptor {}", (Object)className, (Object)kieContainer.getReleaseId().toExternalForm());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException("Class " + className + " not found in the project");
                }
                catch (NoClassDefFoundError e) {
                    throw new IllegalArgumentException("Class " + className + " not found in the project");
                }
                this.addClassToDeployedUnit(descriptorClass, (DeployedUnitImpl)deployedUnit);
            }
        }
        return builder;
    }

    protected Object getInstanceFromModel(ObjectModel model, KieContainer kieContainer, Map<String, Object> contaxtParams) {
        ObjectModelResolver resolver = ObjectModelResolverProvider.get((String)model.getResolver());
        if (resolver == null) {
            throw new IllegalStateException("Unable to find ObjectModelResolver for " + model.getResolver());
        }
        return resolver.getInstance(model, kieContainer.getClassLoader(), contaxtParams);
    }

    protected void processResources(InternalKieModule module, Collection<String> files, KieContainer kieContainer, DeploymentUnit unit, DeployedUnitImpl deployedUnit, ReleaseId releaseId, Map<String, ProcessDescriptor> processes) {
        boolean processClasses = ((KieContainerImpl)kieContainer).getKieProject() instanceof KieModuleKieProject;
        for (String fileName : files) {
            ProcessAssetDesc process;
            ProcessDescriptor processDesriptor;
            String processId;
            String processString;
            if (fileName.matches(".+bpmn[2]?$")) {
                try {
                    processString = new String(module.getBytes(fileName), "UTF-8");
                    processId = this.getProcessId(processString);
                    processDesriptor = processes.get(processId);
                    if (processDesriptor == null) continue;
                    process = processDesriptor.getProcess();
                    if (process == null) {
                        throw new IllegalArgumentException("Unable to read process " + fileName);
                    }
                    process.setEncodedProcessSource(Base64.encodeBase64String((byte[])processString.getBytes()));
                    process.setDeploymentId(unit.getIdentifier());
                    deployedUnit.addAssetLocation(process.getId(), process);
                    this.bpmn2Service.addProcessDefinition(unit.getIdentifier(), processId, (Object)processDesriptor, kieContainer);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Unsupported encoding while processing process " + fileName);
                }
            }
            if (fileName.matches(".+ftl$") || fileName.matches(".+form$") || fileName.matches(".+frm$")) {
                try {
                    String formContent = new String(module.getBytes(fileName), "UTF-8");
                    if (fileName.indexOf("/") != -1) {
                        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                    }
                    this.formManagerService.registerForm(unit.getIdentifier(), fileName, formContent);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Unsupported encoding while processing form " + fileName);
                }
            }
            if (processClasses && fileName.matches(".+class$")) {
                String className = fileName.replaceAll("/", ".");
                className = className.substring(0, fileName.length() - ".class".length());
                Class<?> deploymentClass = null;
                try {
                    deploymentClass = kieContainer.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException("Class " + className + " not found in the project");
                }
                catch (NoClassDefFoundError e) {
                    throw new IllegalArgumentException("Class " + className + " not found in the project");
                }
                this.addClassToDeployedUnit(deploymentClass, deployedUnit);
                continue;
            }
            if (!fileName.matches(".+cmmn$")) continue;
            try {
                processString = new String(module.getBytes(fileName), "UTF-8");
                processId = this.getCaseId(processString);
                processDesriptor = processes.get(processId);
                if (processDesriptor == null) continue;
                process = processDesriptor.getProcess();
                if (process == null) {
                    throw new IllegalArgumentException("Unable to read process " + fileName);
                }
                process.setEncodedProcessSource(Base64.encodeBase64String((byte[])processString.getBytes()));
                process.setDeploymentId(unit.getIdentifier());
                deployedUnit.addAssetLocation(process.getId(), process);
                this.bpmn2Service.addProcessDefinition(unit.getIdentifier(), processId, (Object)processDesriptor, kieContainer);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unsupported encoding while processing process " + fileName);
            }
        }
    }

    protected void addClassToDeployedUnit(Class deploymentClass, DeployedUnitImpl deployedUnit) {
        if (deploymentClass != null) {
            DeploymentDescriptor depDesc;
            DeploymentUnit unit = deployedUnit.getDeploymentUnit();
            Boolean limitClasses = false;
            if (unit != null && (depDesc = ((KModuleDeploymentUnit)unit).getDeploymentDescriptor()) != null) {
                limitClasses = depDesc.getLimitSerializationClasses();
            }
            if (limitClasses != null && limitClasses.booleanValue()) {
                KModuleDeploymentService.filterClassesAddedToDeployedUnit(deployedUnit, deploymentClass);
            } else {
                logger.debug("Loaded {} onto the classpath from deployment {}", (Object)deploymentClass.getName(), (Object)unit.getIdentifier());
                deployedUnit.addClass(deploymentClass);
            }
        }
    }

    protected void processClassloader(KieContainer kieContainer, DeployedUnitImpl deployedUnit) {
        ClassLoader parentCl;
        if (((KieContainerImpl)kieContainer).getKieProject() instanceof KieModuleKieProject && kieContainer.getClassLoader() instanceof ProjectClassLoader && (parentCl = kieContainer.getClassLoader().getParent()) instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)parentCl).getURLs();
            if (urls == null || urls.length == 0) {
                return;
            }
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.addUrls(urls);
            builder.addClassLoader(kieContainer.getClassLoader());
            Reflections reflections = new Reflections((Configuration)builder);
            Set xmlRootElemClasses = reflections.getTypesAnnotatedWith(XmlRootElement.class);
            Set xmlTypeClasses = reflections.getTypesAnnotatedWith(XmlType.class);
            Set remoteableClasses = reflections.getTypesAnnotatedWith(Remotable.class);
            HashSet allClasses = new HashSet();
            for (Set classesToAdd : new Set[]{xmlRootElemClasses, xmlTypeClasses, remoteableClasses}) {
                if (classesToAdd == null) continue;
                allClasses.addAll(classesToAdd);
            }
            for (Class clazz : allClasses) {
                KModuleDeploymentService.filterClassesAddedToDeployedUnit(deployedUnit, clazz);
            }
        }
    }

    private static void filterClassesAddedToDeployedUnit(DeployedUnit deployedUnit, Class classToAdd) {
        if (classToAdd.isInterface() || classToAdd.isAnnotation() || classToAdd.isLocalClass() || classToAdd.isMemberClass()) {
            return;
        }
        boolean jaxbClass = false;
        boolean remoteableClass = false;
        for (Annotation anno : classToAdd.getAnnotations()) {
            if (XmlRootElement.class.equals(anno.annotationType())) {
                jaxbClass = true;
                break;
            }
            if (!XmlType.class.equals(anno.annotationType())) continue;
            jaxbClass = true;
            break;
        }
        for (Annotation anno : classToAdd.getDeclaredAnnotations()) {
            if (!Remotable.class.equals(anno.annotationType())) continue;
            remoteableClass = true;
            break;
        }
        if (jaxbClass || remoteableClass) {
            DeployedUnitImpl deployedUnitImpl = (DeployedUnitImpl)deployedUnit;
            deployedUnitImpl.addClass(classToAdd);
        }
    }

    public void setBpmn2Service(DefinitionService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }

    public void setMerger(DeploymentDescriptorMerger merger) {
        this.merger = merger;
    }

    public void setFormManagerService(FormManagerService formManagerService) {
        this.formManagerService = formManagerService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void activate(String deploymentId) {
        DeployedUnit deployed = this.getDeployedUnit(deploymentId);
        if (deployed != null) {
            ((DeployedUnitImpl)deployed).setActive(true);
            ((InternalRuntimeManager)deployed.getRuntimeManager()).activate();
            this.notifyOnActivate(deployed.getDeploymentUnit(), deployed);
        }
    }

    public void deactivate(String deploymentId) {
        DeployedUnit deployed = this.getDeployedUnit(deploymentId);
        if (deployed != null && deployed.isActive()) {
            ((DeployedUnitImpl)deployed).setActive(false);
            ((InternalRuntimeManager)deployed.getRuntimeManager()).deactivate();
            this.notifyOnDeactivate(deployed.getDeploymentUnit(), deployed);
        }
    }

    protected String getProcessId(String processSource) {
        try {
            InputSource inputSource = new InputSource(new StringReader(processSource));
            String processId = (String)this.processIdXPathExpression.evaluate(inputSource, XPathConstants.STRING);
            return processId;
        }
        catch (XPathExpressionException e) {
            logger.error("Unable to find process id from process source due to {}", (Object)e.getMessage());
            return null;
        }
    }

    protected String getCaseId(String processSource) {
        try {
            InputSource inputSource = new InputSource(new StringReader(processSource));
            String caseId = (String)this.caseIdXPathExpression.evaluate(inputSource, XPathConstants.STRING);
            return caseId;
        }
        catch (XPathExpressionException e) {
            logger.error("Unable to find case id from case source due to {}", (Object)e.getMessage());
            return null;
        }
    }
}

