/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptor;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.UserTaskDefinition;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPMN2DataServiceImpl
implements DefinitionService,
DeploymentEventListener {
    private static final Logger logger = LoggerFactory.getLogger(BPMN2DataServiceImpl.class);
    private ConcurrentMap<String, Map<String, ProcessDescriptor>> definitionCache = new ConcurrentHashMap<String, Map<String, ProcessDescriptor>>();

    public BPMN2DataServiceImpl() {
        ServiceRegistry.get().register(DefinitionService.class.getSimpleName(), (Object)this);
    }

    private void validateNonEmptyDeploymentIdAndProcessId(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessIdAndTaskName(deploymentId, processId, "x");
    }

    private void validateNonEmptyDeploymentIdAndProcessIdAndTaskName(String deploymentId, String processId, String taskName) {
        boolean emptyDepId = StringUtils.isEmpty((CharSequence)deploymentId);
        boolean emptyProcId = StringUtils.isEmpty((CharSequence)processId);
        boolean emptyTaskName = StringUtils.isEmpty((CharSequence)taskName);
        if (emptyDepId || emptyProcId || emptyTaskName) {
            StringBuffer msg = new StringBuffer("The ");
            if (emptyDepId) {
                msg.append("deployment id ");
            }
            if (emptyDepId && (emptyProcId || emptyTaskName)) {
                msg.append("and the ");
            }
            if (emptyProcId) {
                msg.append("process id ");
            }
            if (emptyDepId && emptyTaskName) {
                msg.append("and the ");
            }
            if (emptyTaskName) {
                msg.append("task name ");
            }
            msg.append("may not be empty or null!");
            throw new IllegalStateException(msg.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessDefinition(String deploymentId, String processId, Object processDescriptor, KieContainer kieContainer) {
        ConcurrentHashMap<String, ProcessDescriptor> definitions = null;
        ConcurrentMap<String, Map<String, ProcessDescriptor>> concurrentMap = this.definitionCache;
        synchronized (concurrentMap) {
            ConcurrentHashMap<String, ProcessDescriptor> newDef = new ConcurrentHashMap<String, ProcessDescriptor>();
            definitions = this.definitionCache.putIfAbsent(deploymentId, newDef);
            if (definitions == null) {
                definitions = newDef;
            }
            ProcessDescriptor descriptor = (ProcessDescriptor)processDescriptor;
            this.fillProcessDefinition(descriptor, kieContainer);
            definitions.put(processId, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessDefinition buildProcessDefinition(String deploymentId, String bpmn2Content, KieContainer kieContainer, boolean cache) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)bpmn2Content)) {
            return null;
        }
        KnowledgeBuilder kbuilder = null;
        if (kieContainer != null && kieContainer.getClassLoader() != null) {
            KnowledgeBuilderConfigurationImpl pconf = new KnowledgeBuilderConfigurationImpl(new ClassLoader[]{kieContainer.getClassLoader()});
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pconf);
        } else {
            kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        }
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                logger.error("Error: {}", (Object)error.getMessage());
            }
            logger.debug("Process Cannot be Parsed! \n {} \n", (Object)bpmn2Content);
            return null;
        }
        KiePackage pckg = (KiePackage)kbuilder.getKnowledgePackages().iterator().next();
        Process process = (Process)pckg.getProcesses().iterator().next();
        ProcessDescriptor helper = (ProcessDescriptor)process.getMetaData().get("ProcessDescriptor");
        ProcessAssetDesc definition = this.fillProcessDefinition(helper, kieContainer);
        if (cache) {
            this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, "no proc id");
            ConcurrentHashMap<String, ProcessDescriptor> definitions = null;
            ConcurrentMap<String, Map<String, ProcessDescriptor>> concurrentMap = this.definitionCache;
            synchronized (concurrentMap) {
                ConcurrentHashMap<String, ProcessDescriptor> newDef = new ConcurrentHashMap<String, ProcessDescriptor>();
                definitions = this.definitionCache.putIfAbsent(deploymentId, newDef);
                if (definitions == null) {
                    definitions = newDef;
                }
                definitions.put(process.getId(), helper);
            }
        }
        return definition;
    }

    private ProcessAssetDesc fillProcessDefinition(ProcessDescriptor helper, KieContainer kieContainer) {
        ProcessAssetDesc definition = helper.getProcess();
        definition.setAssociatedEntities(helper.getTaskAssignments());
        definition.setProcessVariables(helper.getInputs());
        definition.setServiceTasks(helper.getServiceTasks());
        definition.setSignals(helper.getSignals());
        definition.setGlobals(helper.getGlobals());
        definition.setReferencedRules(helper.getReferencedRules());
        if (kieContainer != null && helper.hasUnresolvedReusableSubProcessNames()) {
            helper.resolveReusableSubProcessNames(kieContainer.getKieBase().getProcesses());
        }
        definition.setReusableSubProcesses(helper.getReusableSubProcesses());
        return definition;
    }

    public Map<String, String> getServiceTasks(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return Collections.unmodifiableMap(helper.getServiceTasks());
        }
        return Collections.emptyMap();
    }

    public ProcessDefinition getProcessDefinition(String deploymentId, String processId) {
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper != null && helper.getProcess() != null) {
                return helper.getProcess();
            }
            throw new ProcessDefinitionNotFoundException("No process available with given id : " + processId);
        }
        throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
    }

    public Collection<String> getReusableSubProcesses(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getReusableSubProcesses() != null) {
                return new ArrayList<String>(helper.getReusableSubProcesses());
            }
        }
        return Collections.emptyList();
    }

    public Map<String, String> getProcessVariables(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getInputs() != null) {
                return Collections.unmodifiableMap(helper.getInputs());
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, Collection<String>> getAssociatedEntities(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskAssignments() != null) {
                return Collections.unmodifiableMap(helper.getTaskAssignments());
            }
        }
        return Collections.emptyMap();
    }

    public Collection<UserTaskDefinition> getTasksDefinitions(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTasks() != null) {
                return new ArrayList<UserTaskDefinition>(helper.getTasks().values());
            }
        }
        return Collections.emptyList();
    }

    public Map<String, String> getTaskInputMappings(String deploymentId, String processId, String taskName) {
        this.validateNonEmptyDeploymentIdAndProcessIdAndTaskName(deploymentId, processId, taskName);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskInputMappings().containsKey(taskName)) {
                return Collections.unmodifiableMap(helper.getTaskInputMappings().get(taskName));
            }
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getTaskOutputMappings(String deploymentId, String processId, String taskName) {
        this.validateNonEmptyDeploymentIdAndProcessIdAndTaskName(deploymentId, processId, taskName);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            if (helper.getTaskOutputMappings().containsKey(taskName)) {
                return Collections.unmodifiableMap(helper.getTaskOutputMappings().get(taskName));
            }
        }
        return Collections.emptyMap();
    }

    public void onDeploy(DeploymentEvent event) {
    }

    public void onUnDeploy(DeploymentEvent event) {
        this.definitionCache.remove(event.getDeploymentId());
    }

    public void onActivate(DeploymentEvent event) {
    }

    public void onDeactivate(DeploymentEvent event) {
    }

    public Set<String> getJavaClasses(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return Collections.unmodifiableSet(helper.getReferencedClasses());
        }
        return Collections.emptySet();
    }

    public Set<String> getRuleSets(String deploymentId, String processId) {
        this.validateNonEmptyDeploymentIdAndProcessId(deploymentId, processId);
        if (this.definitionCache.containsKey(deploymentId)) {
            ProcessDescriptor helper = (ProcessDescriptor)((Map)this.definitionCache.get(deploymentId)).get(processId);
            if (helper == null) {
                throw new IllegalStateException("No process available with given id : " + processId);
            }
            return Collections.unmodifiableSet(helper.getReferencedRules());
        }
        return Collections.emptySet();
    }
}

