/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.cmd;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="start-process-instance-with-parent-command")
public class StartProcessInstanceWithParentCommand
implements ExecutableCommand<ProcessInstance>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = 7634752111656248015L;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="long")
    private Long processInstanceId;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="long")
    private Long parentProcessInstanceId;

    public StartProcessInstanceWithParentCommand() {
    }

    public StartProcessInstanceWithParentCommand(Long processInstanceId, Long parentProcessInstanceId) {
        this.processInstanceId = processInstanceId;
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public Long getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(Long parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ProcessInstance execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId.longValue());
        if (this.parentProcessInstanceId > 0L) {
            ((ProcessInstanceImpl)processInstance).setMetaData("ParentProcessInstanceId", (Object)this.parentProcessInstanceId);
        }
        return ksession.startProcessInstance(this.processInstanceId.longValue());
    }
}

