/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.wih;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.drools.core.ClassObjectFilter;
import org.jbpm.casemgmt.api.event.CaseCancelEvent;
import org.jbpm.casemgmt.api.event.CaseCloseEvent;
import org.jbpm.casemgmt.api.event.CaseDestroyEvent;
import org.jbpm.casemgmt.api.event.CaseEvent;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.service.ServiceRegistry;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyParentCaseEventListener
extends DefaultProcessEventListener
implements CaseEventListener,
Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(NotifyParentCaseEventListener.class);
    private IdentityProvider identityProvider;

    public NotifyParentCaseEventListener(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void afterCaseClosed(CaseCloseEvent event) {
        this.notifyParentOnCompletion((CaseEvent)event);
    }

    public void afterCaseCancelled(CaseCancelEvent event) {
        this.notifyParentOnCompletion((CaseEvent)event);
    }

    public void afterCaseDestroyed(CaseDestroyEvent event) {
        this.notifyParentOnCompletion((CaseEvent)event);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        CaseFileInstance caseFile = this.getCaseFile((KieSession)event.getKieRuntime());
        if (caseFile != null) {
            String caseId = ((WorkflowProcessInstanceImpl)event.getProcessInstance()).getCorrelationKey();
            if (caseFile.getCaseId().equals(caseId)) {
                logger.debug("Process instance {} that represents main case instance {} has completed/was aborted, notify parent if exists", (Object)event.getProcessInstance().getId(), (Object)caseId);
                Object caseEvent = null;
                caseEvent = event.getProcessInstance().getState() == 2 ? new CaseCloseEvent(this.identityProvider.getName(), caseId, caseFile, "") : new CaseCancelEvent(this.identityProvider.getName(), caseId, caseFile, Arrays.asList(event.getProcessInstance().getId()));
                this.notifyParentOnCompletion((CaseEvent)caseEvent);
            }
        }
    }

    protected void notifyParentOnCompletion(CaseEvent event) {
        CaseFileInstanceImpl caseFileInstance = (CaseFileInstanceImpl)event.getCaseFile();
        if (caseFileInstance == null) {
            return;
        }
        if (caseFileInstance.getParentInstanceId() != null && caseFileInstance.getParentWorkItemId() != null) {
            logger.debug("Case {} has defined parent information instance {}, work item {}, going to notify it", new Object[]{event.getCaseId(), caseFileInstance.getParentInstanceId(), caseFileInstance.getParentWorkItemId()});
            ProcessService processService = (ProcessService)ServiceRegistry.get().service(ServiceRegistry.PROCESS_SERVICE);
            HashMap<String, Object> results = new HashMap<String, Object>(caseFileInstance.getData());
            results.put("CaseId", event.getCaseId());
            processService.completeWorkItem(caseFileInstance.getParentWorkItemId(), results);
            logger.debug("Parent instance id {}, work item id {}, has been successfully notified about case {} completion", new Object[]{caseFileInstance.getParentInstanceId(), caseFileInstance.getParentWorkItemId(), event.getCaseId()});
            caseFileInstance.setParentInstanceId(null);
            caseFileInstance.setParentWorkItemId(null);
        }
    }

    protected CaseFileInstance getCaseFile(KieSession ksession) {
        Collection caseFiles = ksession.getObjects((ObjectFilter)new ClassObjectFilter(CaseFileInstance.class));
        if (caseFiles.size() == 0) {
            return null;
        }
        CaseFileInstance caseFile = (CaseFileInstance)caseFiles.iterator().next();
        return caseFile;
    }

    public void close() {
    }
}

