/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import org.dashbuilder.dataset.engine.Chronometer;

public class ChronometerImpl
implements Chronometer {
    protected Long startTime;
    protected Long stopTime;

    public long start() {
        this.startTime = System.nanoTime();
        this.stopTime = null;
        return this.startTime;
    }

    public long stop() {
        this.stopTime = System.nanoTime();
        return this.stopTime;
    }

    public long elapsedTime() {
        long stop = this.stopTime != null ? this.stopTime : System.nanoTime();
        return stop - this.startTime;
    }

    public String formatElapsedTime(long millis) {
        long milliseconds = millis;
        long seconds = milliseconds / 1000L;
        milliseconds %= 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        long days = hours / 24L;
        hours %= 24L;
        long weeks = days / 7L;
        days %= 7L;
        double secondsd = (double)(seconds * 1000L + milliseconds) / 1000.0;
        StringBuilder buf = new StringBuilder();
        if (weeks > 0L) {
            buf.append(weeks).append(" weeks ");
        }
        if (days > 0L) {
            buf.append(days).append("d ");
        }
        if (hours > 0L) {
            buf.append(hours).append("h ");
        }
        if (minutes > 0L) {
            buf.append(minutes).append("m ");
        }
        if (secondsd > 0.0) {
            buf.append(secondsd).append("s");
        }
        if (buf.length() == 0) {
            return "0s";
        }
        return buf.toString();
    }
}

