/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.assembler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.dmn.api.core.DMNCompiler;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.assembler.DMNResource;
import org.kie.dmn.core.assembler.DMNResourceDependenciesSorter;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.compiler.ImportDMNResolverUtil;
import org.kie.dmn.core.compiler.profiles.ExtendedDMNProfile;
import org.kie.dmn.core.impl.DMNKnowledgeBuilderError;
import org.kie.dmn.core.impl.DMNPackageImpl;
import org.kie.dmn.feel.util.Either;
import org.kie.dmn.feel.util.EvalHelper;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNAssemblerService
implements KieAssemblerService {
    private static final Logger logger = LoggerFactory.getLogger(DMNAssemblerService.class);
    public static final String ORG_KIE_DMN_PREFIX = "org.kie.dmn";
    public static final String DMN_PROFILE_PREFIX = "org.kie.dmn.profiles.";
    public static final String DMN_COMPILER_CACHE_KEY = "DMN_COMPILER_CACHE_KEY";
    public static final String DMN_PROFILES_CACHE_KEY = "DMN_PROFILES_CACHE_KEY";
    private DMNCompilerConfigurationImpl externalCompilerConfiguration;

    public DMNAssemblerService(DMNCompilerConfigurationImpl externalCompilerConfiguration) {
        this.externalCompilerConfiguration = externalCompilerConfiguration;
    }

    public DMNAssemblerService() {
    }

    public ResourceType getResourceType() {
        return ResourceType.DMN;
    }

    public void addResources(Object kbuilder, Collection<ResourceWithConfiguration> resources, ResourceType type) throws Exception {
        EvalHelper.clearGenericAccessorCache();
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
        DMNCompilerImpl dmnCompiler = (DMNCompilerImpl)kbuilderImpl.getCachedOrCreate(DMN_COMPILER_CACHE_KEY, () -> this.getCompiler(kbuilderImpl));
        DMNMarshaller dmnMarshaller = dmnCompiler.getMarshaller();
        if (resources.size() == 1) {
            this.internalAddResource(kbuilderImpl, dmnCompiler, resources.iterator().next(), Collections.emptyList());
            return;
        }
        ArrayList<DMNResource> dmnResources = new ArrayList<DMNResource>();
        for (ResourceWithConfiguration r : resources) {
            Definitions definitions = dmnMarshaller.unmarshal(r.getResource().getReader());
            QName modelID = new QName(definitions.getNamespace(), definitions.getName());
            DMNResource dmnResource = new DMNResource(modelID, r, definitions);
            dmnResources.add(dmnResource);
        }
        DMNAssemblerService.enrichDMNResourcesWithImportsDependencies(dmnResources);
        List<DMNResource> sortedDmnResources = DMNResourceDependenciesSorter.sort(dmnResources);
        ArrayList<DMNModel> dmnModels = new ArrayList<DMNModel>();
        for (DMNResource dmnRes : sortedDmnResources) {
            DMNModel dmnModel = this.internalAddResource(kbuilderImpl, dmnCompiler, dmnRes.getResAndConfig(), dmnModels);
            dmnModels.add(dmnModel);
        }
    }

    public static void enrichDMNResourcesWithImportsDependencies(List<DMNResource> dmnResources) {
        for (DMNResource r : dmnResources) {
            for (Import i : r.getDefinitions().getImport()) {
                if (ImportDMNResolverUtil.whichImportType(i) != ImportDMNResolverUtil.ImportType.DMN) continue;
                Either<String, DMNResource> resolvedResult = ImportDMNResolverUtil.resolveImportDMN(i, dmnResources, DMNResource::getModelID);
                DMNResource located = (DMNResource)resolvedResult.getOrElseThrow(RuntimeException::new);
                r.addDependency(located.getModelID());
            }
        }
    }

    private DMNModel internalAddResource(KnowledgeBuilderImpl kbuilder, DMNCompiler dmnCompiler, ResourceWithConfiguration r, Collection<DMNModel> dmnModels) throws Exception {
        r.getBeforeAdd().accept(kbuilder);
        DMNModel dmnModel = this.compileResourceToModel(kbuilder, dmnCompiler, r.getResource(), dmnModels);
        r.getAfterAdd().accept(kbuilder);
        return dmnModel;
    }

    public void addResource(Object kbuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        logger.warn("invoked legacy addResource (no control on the order of the assembler compilation): " + resource.getSourcePath());
        KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
        DMNCompiler dmnCompiler = (DMNCompiler)kbuilderImpl.getCachedOrCreate(DMN_COMPILER_CACHE_KEY, () -> this.getCompiler(kbuilderImpl));
        ArrayList<DMNModel> dmnModels = new ArrayList<DMNModel>();
        for (PackageRegistry pr : kbuilderImpl.getPackageRegistry().values()) {
            ResourceTypePackage resourceTypePackage = (ResourceTypePackage)pr.getPackage().getResourceTypePackages().get(ResourceType.DMN);
            if (resourceTypePackage == null) continue;
            DMNPackageImpl dmnpkg = (DMNPackageImpl)resourceTypePackage;
            dmnModels.addAll(dmnpkg.getAllModels().values());
        }
        this.compileResourceToModel(kbuilderImpl, dmnCompiler, resource, dmnModels);
    }

    private DMNModel compileResourceToModel(KnowledgeBuilderImpl kbuilderImpl, DMNCompiler dmnCompiler, Resource resource, Collection<DMNModel> dmnModels) {
        DMNModel model = dmnCompiler.compile(resource, dmnModels);
        if (model != null) {
            String namespace = model.getNamespace();
            PackageRegistry pkgReg = kbuilderImpl.getOrCreatePackageRegistry(new PackageDescr(namespace));
            InternalKnowledgePackage kpkgs = pkgReg.getPackage();
            kpkgs.addCloningResource(DMN_COMPILER_CACHE_KEY, (Object)dmnCompiler);
            Map rpkg = kpkgs.getResourceTypePackages();
            DMNPackageImpl dmnpkg = (DMNPackageImpl)rpkg.get(ResourceType.DMN);
            if (dmnpkg == null) {
                dmnpkg = new DMNPackageImpl(namespace);
                rpkg.put(ResourceType.DMN, dmnpkg);
            } else if (dmnpkg.getModel(model.getName()) != null) {
                kbuilderImpl.addBuilderResult((KnowledgeBuilderResult)new DMNKnowledgeBuilderError(ResultSeverity.ERROR, resource, namespace, "Duplicate model name " + model.getName() + " in namespace " + namespace));
                logger.error("Duplicate model name {} in namespace {}", (Object)model.getName(), (Object)namespace);
            }
            dmnpkg.addModel(model.getName(), model);
            dmnpkg.addProfiles((List)kbuilderImpl.getCachedOrCreate(DMN_PROFILES_CACHE_KEY, () -> this.getDMNProfiles(kbuilderImpl)));
        } else {
            kbuilderImpl.addBuilderResult((KnowledgeBuilderResult)new DMNKnowledgeBuilderError(ResultSeverity.ERROR, resource, "Unable to compile DMN model for the resource"));
            logger.error("Unable to compile DMN model for resource {}", (Object)resource.getSourcePath());
        }
        return model;
    }

    private List<DMNProfile> getDMNProfiles(KnowledgeBuilderImpl kbuilderImpl) {
        ChainedProperties chainedProperties = kbuilderImpl.getBuilderConfiguration().getChainedProperties();
        ArrayList<DMNProfile> dmnProfiles = new ArrayList<DMNProfile>();
        dmnProfiles.addAll(DMNAssemblerService.getDefaultDMNProfiles(chainedProperties));
        HashMap dmnProfileProperties = new HashMap();
        chainedProperties.mapStartsWith(dmnProfileProperties, DMN_PROFILE_PREFIX, false);
        if (!dmnProfileProperties.isEmpty()) {
            try {
                for (Map.Entry dmnProfileProperty : dmnProfileProperties.entrySet()) {
                    DMNProfile dmnProfile = (DMNProfile)kbuilderImpl.getRootClassLoader().loadClass((String)dmnProfileProperty.getValue()).newInstance();
                    dmnProfiles.add(dmnProfile);
                }
                return dmnProfiles;
            }
            catch (Exception e) {
                kbuilderImpl.addBuilderResult((KnowledgeBuilderResult)new DMNKnowledgeBuilderError(ResultSeverity.WARNING, "Trying to load a non-existing Kie DMN profile " + e.getLocalizedMessage()));
                logger.error("Trying to load a non-existing Kie DMN profile {}", (Object)e.getLocalizedMessage(), (Object)e);
                kbuilderImpl.addBuilderResult((KnowledgeBuilderResult)new DMNKnowledgeBuilderError(ResultSeverity.WARNING, "DMN Compiler configuration contained errors, will fall-back using empty-configuration compiler."));
                logger.warn("DMN Compiler configuration contained errors, will fall-back using empty-configuration compiler.");
            }
        }
        return dmnProfiles;
    }

    public static List<DMNProfile> getDefaultDMNProfiles(ChainedProperties properties) {
        if (!DMNAssemblerService.isStrictMode(properties)) {
            return Arrays.asList(new ExtendedDMNProfile());
        }
        return Collections.emptyList();
    }

    public static boolean isStrictMode(ChainedProperties properties) {
        String val = properties.getProperty("org.kie.dmn.strictConformance", "false");
        return "".equals(val) || Boolean.parseBoolean(val);
    }

    private DMNCompiler getCompiler(KnowledgeBuilderImpl kbuilderImpl) {
        List dmnProfiles = (List)kbuilderImpl.getCachedOrCreate(DMN_PROFILES_CACHE_KEY, () -> this.getDMNProfiles(kbuilderImpl));
        DMNCompilerConfigurationImpl compilerConfiguration = this.externalCompilerConfiguration == null ? DMNAssemblerService.compilerConfigWithKModulePrefs(kbuilderImpl.getRootClassLoader(), kbuilderImpl.getBuilderConfiguration().getChainedProperties(), dmnProfiles, (DMNCompilerConfigurationImpl)DMNFactory.newCompilerConfiguration()) : this.externalCompilerConfiguration;
        return DMNFactory.newCompiler(compilerConfiguration);
    }

    public static DMNCompilerConfigurationImpl compilerConfigWithKModulePrefs(ClassLoader classLoader, ChainedProperties chainedProperties, List<DMNProfile> dmnProfiles, DMNCompilerConfigurationImpl config) {
        config.setRootClassLoader(classLoader);
        HashMap<String, String> dmnPrefs = new HashMap<String, String>();
        chainedProperties.mapStartsWith(dmnPrefs, ORG_KIE_DMN_PREFIX, true);
        config.setProperties(dmnPrefs);
        for (DMNProfile dmnProfile : dmnProfiles) {
            config.addExtensions(dmnProfile.getExtensionRegisters());
            config.addDRGElementCompilers(dmnProfile.getDRGElementCompilers());
            config.addFEELProfile(dmnProfile);
        }
        return config;
    }
}

