/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import org.drools.core.command.impl.RegistryContext;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.services.api.NodeNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerNodeCommand
implements ExecutableCommand<Void>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = -8252686458877022331L;
    private static final Logger logger = LoggerFactory.getLogger(TriggerNodeCommand.class);
    private long processInstanceId;
    private long nodeId;

    public TriggerNodeCommand(long processInstanceId, long nodeId) {
        this.processInstanceId = processInstanceId;
        this.nodeId = nodeId;
    }

    public Void execute(Context context) {
        KieSession kieSession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        logger.debug("About to trigger (create) node instance for node {} in process instance {}", (Object)this.nodeId, (Object)this.processInstanceId);
        RuleFlowProcessInstance wfp = (RuleFlowProcessInstance)kieSession.getProcessInstance(this.processInstanceId, false);
        if (wfp == null) {
            throw new ProcessInstanceNotFoundException("Process instance with id " + this.processInstanceId + " not found");
        }
        Node node = wfp.getRuleFlowProcess().getNodesRecursively().stream().filter(ni -> ni.getId() == this.nodeId).findFirst().orElse(null);
        if (node == null) {
            throw new NodeNotFoundException("Node instance with id " + this.nodeId + " not found");
        }
        logger.debug("Triggering node {} on process instance {}", (Object)node, (Object)wfp);
        wfp.getNodeInstance(node).trigger(null, "DROOLS_DEFAULT");
        logger.debug("Node {} successfully triggered", (Object)node);
        return null;
    }

    public void setProcessInstanceId(Long procInstId) {
        this.processInstanceId = procInstId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }
}

