/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.ejb.impl.query;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jbpm.kie.services.impl.query.QueryServiceImpl;
import org.jbpm.services.api.query.QueryAlreadyRegisteredException;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.jbpm.services.api.query.model.QueryDefinition;
import org.jbpm.services.ejb.api.query.QueryServiceEJBLocal;
import org.jbpm.services.ejb.api.query.QueryServiceEJBRemote;
import org.jbpm.services.ejb.impl.identity.EJBContextIdentityProvider;
import org.jbpm.services.ejb.impl.tx.TransactionalCommandServiceEJBImpl;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@Lock(value=LockType.READ)
public class QueryServiceEJBImpl
extends QueryServiceImpl
implements QueryServiceEJBLocal,
QueryServiceEJBRemote {
    @Inject
    private Instance<IdentityProvider> identityProvider;
    @Inject
    private Instance<UserGroupCallback> userGroupCallback;
    @Resource
    private EJBContext context;

    @PostConstruct
    public void configure() {
        if (this.identityProvider.isUnsatisfied()) {
            this.setIdentityProvider(new EJBContextIdentityProvider(this.context));
        } else {
            this.setIdentityProvider((IdentityProvider)this.identityProvider.get());
        }
        if (!this.userGroupCallback.isUnsatisfied()) {
            this.setUserGroupCallback((UserGroupCallback)this.userGroupCallback.get());
        }
        super.init();
    }

    @EJB(beanInterface=TransactionalCommandServiceEJBImpl.class)
    public void setCommandService(TransactionalCommandService commandService) {
        super.setCommandService(commandService);
    }

    @Lock(value=LockType.WRITE)
    public void registerQuery(QueryDefinition queryDefinition) throws QueryAlreadyRegisteredException {
        super.registerQuery(queryDefinition);
    }

    @Lock(value=LockType.WRITE)
    public void replaceQuery(QueryDefinition queryDefinition) {
        super.replaceQuery(queryDefinition);
    }

    @Lock(value=LockType.WRITE)
    public void unregisterQuery(String uniqueQueryName) throws QueryNotFoundException {
        super.unregisterQuery(uniqueQueryName);
    }
}

