/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.drlxparse;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.drools.core.util.index.IndexUtil;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.EnclosedExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.AbstractDrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.util.ClassUtil;

public class SingleDrlxParseSuccess
extends AbstractDrlxParseSuccess {
    private final Class<?> patternType;
    private Expression expr;
    private final Type exprType;
    private final String exprId;
    private String patternBinding;
    private boolean isPatternBindingUnification = false;
    private String exprBinding;
    private IndexUtil.ConstraintType decodeConstraintType;
    private Collection<String> usedDeclarations = new LinkedHashSet<String>();
    private Collection<String> usedDeclarationsOnLeft;
    private Set<String> reactOnProperties = Collections.emptySet();
    private TypedExpression left;
    private TypedExpression right;
    private Object rightLiteral;
    private boolean isStatic;
    private boolean isValidExpression;
    private boolean skipThisAsParam;
    private boolean isBetaNode;
    private boolean requiresSplit;
    private boolean unification;
    private boolean temporal;

    public SingleDrlxParseSuccess(Class<?> patternType, String exprId, String patternBinding, Expression expr, Type exprType) {
        this.patternType = patternType;
        this.exprId = exprId;
        this.patternBinding = patternBinding;
        this.expr = expr;
        this.exprType = exprType;
    }

    public SingleDrlxParseSuccess setDecodeConstraintType(IndexUtil.ConstraintType decodeConstraintType) {
        this.decodeConstraintType = decodeConstraintType;
        return this;
    }

    public SingleDrlxParseSuccess setUsedDeclarationsOnLeft(Collection<String> usedDeclarationsOnLeft) {
        this.usedDeclarationsOnLeft = usedDeclarationsOnLeft;
        return this;
    }

    public Collection<String> getUsedDeclarationsOnLeft() {
        return this.usedDeclarationsOnLeft != null ? this.usedDeclarationsOnLeft : this.usedDeclarations;
    }

    public SingleDrlxParseSuccess setUsedDeclarations(Collection<String> usedDeclarations) {
        this.usedDeclarations = new LinkedHashSet<String>(usedDeclarations);
        this.skipThisAsParam = usedDeclarations.contains(this.patternBinding);
        return this;
    }

    public SingleDrlxParseSuccess setReactOnProperties(Set<String> reactOnProperties) {
        if (this.patternType != null) {
            reactOnProperties.retainAll(ClassUtil.getAccessibleProperties(this.patternType));
            this.reactOnProperties = reactOnProperties;
        }
        return this;
    }

    public SingleDrlxParseSuccess setPatternBindingUnification(Boolean unification) {
        this.isPatternBindingUnification = unification;
        return this;
    }

    public SingleDrlxParseSuccess addReactOnProperty(String reactOnProperty) {
        if (this.patternType != null && ClassUtil.getAccessibleProperties(this.patternType).contains(reactOnProperty)) {
            if (this.reactOnProperties.isEmpty()) {
                this.reactOnProperties = new HashSet<String>();
            }
            this.reactOnProperties.add(reactOnProperty);
        }
        return this;
    }

    public SingleDrlxParseSuccess setLeft(TypedExpression left) {
        this.left = left;
        return this;
    }

    public SingleDrlxParseSuccess setRight(TypedExpression right) {
        this.right = right;
        return this;
    }

    public SingleDrlxParseSuccess setRightLiteral(Object rightLiteral) {
        this.rightLiteral = rightLiteral;
        return this;
    }

    public SingleDrlxParseSuccess setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public SingleDrlxParseSuccess setTemporal(boolean temporal) {
        this.temporal = temporal;
        return this;
    }

    public SingleDrlxParseSuccess setSkipThisAsParam(boolean skipThisAsParam) {
        this.skipThisAsParam = skipThisAsParam;
        return this;
    }

    public String getExprId() {
        return this.exprId;
    }

    public String getPatternBinding() {
        return this.patternBinding;
    }

    public void setExpr(Expression expr) {
        this.expr = expr;
    }

    public void setPatternBinding(String patternBinding) {
        this.patternBinding = patternBinding;
    }

    public SingleDrlxParseSuccess setExprBinding(String exprBinding) {
        this.exprBinding = exprBinding;
        return this;
    }

    public boolean hasUnificationVariable() {
        return Optional.ofNullable(this.left).flatMap(TypedExpression::getUnificationVariable).isPresent() || Optional.ofNullable(this.right).flatMap(TypedExpression::getUnificationVariable).isPresent();
    }

    public String getUnificationVariable() {
        return this.left.getUnificationVariable().isPresent() ? this.left.getUnificationVariable().get() : this.right.getUnificationVariable().get();
    }

    public String getUnificationName() {
        return this.left.getUnificationName().isPresent() ? this.left.getUnificationName().get() : this.right.getUnificationName().get();
    }

    public Class<?> getUnificationVariableType() {
        return this.left.getUnificationVariable().isPresent() ? this.right.getRawClass() : this.left.getRawClass();
    }

    @Override
    public Expression getExpr() {
        return this.expr;
    }

    @Override
    public String getExprBinding() {
        return this.exprBinding;
    }

    public Type getExprType() {
        return this.exprType;
    }

    public Class<?> getExprRawClass() {
        return ClassUtil.toRawClass(this.exprType);
    }

    public Class<?> getPatternType() {
        return this.patternType;
    }

    public boolean isPatternBindingUnification() {
        return this.isPatternBindingUnification;
    }

    public IndexUtil.ConstraintType getDecodeConstraintType() {
        return this.decodeConstraintType;
    }

    public Collection<String> getUsedDeclarations() {
        return this.usedDeclarations;
    }

    public Set<String> getReactOnProperties() {
        return this.reactOnProperties;
    }

    public TypedExpression getLeft() {
        return this.left;
    }

    public TypedExpression getRight() {
        return this.right;
    }

    public Object getRightLiteral() {
        return this.rightLiteral;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isTemporal() {
        return this.temporal;
    }

    @Override
    public boolean isValidExpression() {
        if (this.isValidExpression) {
            return true;
        }
        if (this.expr != null) {
            if (this.getExprType() == Boolean.class || this.getExprType() == Boolean.TYPE) {
                return true;
            }
            if (this.expr instanceof EnclosedExpr) {
                return this.isEnclosedExprValid(((EnclosedExpr)this.expr).getInner());
            }
            return this.right != null;
        }
        return false;
    }

    private boolean isEnclosedExprValid(Expression expr) {
        if (expr instanceof BinaryExpr) {
            BinaryExpr.Operator op = ((BinaryExpr)expr).getOperator();
            return op == BinaryExpr.Operator.AND || op == BinaryExpr.Operator.OR || op == BinaryExpr.Operator.EQUALS || op == BinaryExpr.Operator.NOT_EQUALS || op == BinaryExpr.Operator.LESS || op == BinaryExpr.Operator.GREATER || op == BinaryExpr.Operator.LESS_EQUALS || op == BinaryExpr.Operator.GREATER_EQUALS;
        }
        return false;
    }

    public boolean isSkipThisAsParam() {
        return this.skipThisAsParam;
    }

    public SingleDrlxParseSuccess setValidExpression(boolean validExpression) {
        this.isValidExpression = validExpression;
        return this;
    }

    public SingleDrlxParseSuccess setBetaNode(boolean betaNode) {
        this.isBetaNode = betaNode;
        return this;
    }

    public boolean isBetaNode() {
        return this.isBetaNode;
    }

    public SingleDrlxParseSuccess setRequiresSplit(boolean requiresSplit) {
        this.requiresSplit = requiresSplit;
        return this;
    }

    @Override
    public boolean isRequiresSplit() {
        return this.requiresSplit;
    }

    public SingleDrlxParseSuccess setUnification(boolean unification) {
        this.unification = unification;
        return this;
    }

    public boolean isUnification() {
        return this.unification;
    }

    @Override
    public DrlxParseResult combineWith(DrlxParseResult other, BinaryExpr.Operator operator) {
        if (!other.isSuccess()) {
            return other;
        }
        SingleDrlxParseSuccess otherDrlx = (SingleDrlxParseSuccess)other;
        LinkedHashSet<String> usedDeclarations = new LinkedHashSet<String>();
        usedDeclarations.addAll(this.usedDeclarations);
        usedDeclarations.addAll(otherDrlx.usedDeclarations);
        LinkedHashSet<String> usedDeclarationsOnLeft = null;
        if (this.usedDeclarationsOnLeft != null && otherDrlx.usedDeclarationsOnLeft != null) {
            usedDeclarationsOnLeft = new LinkedHashSet<String>();
            usedDeclarationsOnLeft.addAll(this.usedDeclarationsOnLeft);
            usedDeclarationsOnLeft.addAll(otherDrlx.usedDeclarationsOnLeft);
        }
        HashSet<String> reactOnProperties = new HashSet<String>();
        reactOnProperties.addAll(this.reactOnProperties);
        reactOnProperties.addAll(otherDrlx.reactOnProperties);
        return new SingleDrlxParseSuccess(this.patternType, this.exprId, this.patternBinding, (Expression)new BinaryExpr(this.expr, otherDrlx.expr, operator), this.exprType).setDecodeConstraintType(IndexUtil.ConstraintType.UNKNOWN).setUsedDeclarations(usedDeclarations).setUsedDeclarationsOnLeft(usedDeclarationsOnLeft).setUnification(this.isUnification() || otherDrlx.isUnification()).setReactOnProperties(reactOnProperties).setBetaNode(this.isBetaNode).setLeft(new TypedExpression(this.expr, Boolean.TYPE)).setRight(new TypedExpression(otherDrlx.expr, Boolean.TYPE));
    }
}

