/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.JavaToken;
import org.drools.javaparser.ParserConfiguration;
import org.drools.javaparser.Problem;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.comments.CommentsCollection;
import org.drools.javaparser.utils.Utils;

public class ParseResult<T> {
    private final T result;
    private final List<Problem> problems;
    private final List<JavaToken> tokens;
    private final CommentsCollection commentsCollection;

    public ParseResult(T result, List<Problem> problems, List<JavaToken> tokens, CommentsCollection commentsCollection) {
        this.commentsCollection = commentsCollection;
        this.result = result;
        this.problems = problems;
        this.tokens = tokens;
    }

    public boolean isSuccessful() {
        return this.problems.isEmpty() && this.result != null;
    }

    public void ifSuccessful(Consumer<T> consumer) {
        if (this.isSuccessful()) {
            consumer.accept(this.result);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public Problem getProblem(int i) {
        return this.getProblems().get(i);
    }

    @Deprecated
    public Optional<List<JavaToken>> getTokens() {
        return Optional.ofNullable(this.tokens);
    }

    public Optional<CommentsCollection> getCommentsCollection() {
        return Optional.ofNullable(this.commentsCollection);
    }

    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    public String toString() {
        if (this.isSuccessful()) {
            return "Parsing successful";
        }
        StringBuilder message = new StringBuilder("Parsing failed:").append(Utils.EOL);
        for (Problem problem : this.problems) {
            message.append(problem.toString()).append(Utils.EOL);
        }
        return message.toString();
    }

    public static interface PostProcessor {
        public void process(ParseResult<? extends Node> var1, ParserConfiguration var2);
    }
}

