/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.feel.FEEL;

public class FeelReturnValueEvaluator
implements ReturnValueEvaluator,
Externalizable {
    private static final long serialVersionUID = 630L;
    private String expr;

    public FeelReturnValueEvaluator() {
    }

    public FeelReturnValueEvaluator(String expr) {
        this.expr = expr;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expr = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.expr);
    }

    @Override
    public Object evaluate(ProcessContext context) throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("kcontext", context);
        Globals globals = context.getKieRuntime().getGlobals();
        if (globals != null && globals.getGlobalKeys() != null) {
            for (String gKey : globals.getGlobalKeys()) {
                variables.put(gKey, globals.get(gKey));
            }
        }
        if (context.getProcessInstance() != null && context.getProcessInstance().getProcess() != null) {
            VariableScopeInstance variableScope = (VariableScopeInstance)((WorkflowProcessInstance)context.getProcessInstance()).getContextInstance("VariableScope");
            if (variables != null) {
                variables.putAll(variableScope.getVariables());
            }
        }
        DMNRuntime runtime = (DMNRuntime)((KieSession)context.getKieRuntime()).getKieRuntime(DMNRuntime.class);
        List profiles = ((DMNRuntimeImpl)runtime).getProfiles();
        FEEL feel = FEEL.newInstance((ClassLoader)runtime.getRootClassLoader(), (List)profiles);
        Object value = feel.evaluate(this.expr, variables);
        if (!(value instanceof Boolean)) {
            throw new RuntimeException("Constraints must return boolean values: " + this.expr + " returns " + value + (value == null ? "" : " (type=" + value.getClass()));
        }
        return (boolean)((Boolean)value);
    }

    public String toString() {
        return this.expr;
    }
}

