/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;

public class DMNTypeRegistryV11
implements DMNTypeRegistry {
    private Map<String, Map<String, DMNType>> types = new HashMap<String, Map<String, DMNType>>();
    private static final DMNType UNKNOWN = new SimpleTypeImpl("http://www.omg.org/spec/FEEL/20140401", BuiltInType.UNKNOWN.getName(), null, true, null, null, (Type)BuiltInType.UNKNOWN);

    @Override
    public DMNType unknown() {
        return UNKNOWN;
    }

    public DMNTypeRegistryV11() {
        String feelNamespace = "http://www.omg.org/spec/FEEL/20140401";
        HashMap<String, DMNType> feelTypes = new HashMap<String, DMNType>();
        this.types.put(feelNamespace, feelTypes);
        for (String string : BuiltInType.UNKNOWN.getNames()) {
            feelTypes.put(string, UNKNOWN);
        }
        for (String string : BuiltInType.values()) {
            for (String name : string.getNames()) {
                if (string == BuiltInType.UNKNOWN) continue;
                BaseDMNTypeImpl feelPrimitiveType = string == BuiltInType.LIST ? new SimpleTypeImpl(feelNamespace, name, null, false, null, UNKNOWN, (Type)string) : (string == BuiltInType.CONTEXT ? new CompositeTypeImpl(feelNamespace, name, null, false, Collections.emptyMap(), null, (Type)string) : new SimpleTypeImpl(feelNamespace, name, null, false, null, null, (Type)string));
                feelTypes.put(name, feelPrimitiveType);
            }
        }
    }

    @Override
    public DMNType registerType(DMNType type) {
        if (type.getNamespace() == null && type.getName() == null) {
            throw new IllegalArgumentException("Unknown namespace or name. Unable to register type " + type);
        }
        Map<String, DMNType> typesMap = this.types.get(type.getNamespace());
        if (typesMap == null) {
            typesMap = new HashMap<String, DMNType>();
            this.types.put(type.getNamespace(), typesMap);
        }
        if (typesMap.containsKey(type.getName())) {
            return typesMap.get(type.getName());
        }
        typesMap.put(type.getName(), type);
        return type;
    }

    @Override
    public DMNType resolveType(String namespace, String name) {
        Map<String, DMNType> typeMap = this.types.get(namespace);
        if (typeMap != null) {
            return typeMap.get(name);
        }
        return null;
    }
}

