/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.AllFieldsConstructor;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.SimpleName;
import org.drools.javaparser.ast.nodeTypes.NodeWithSimpleName;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.visitor.CloneVisitor;
import org.drools.javaparser.ast.visitor.GenericVisitor;
import org.drools.javaparser.ast.visitor.VoidVisitor;
import org.drools.javaparser.metamodel.JavaParserMetaModel;
import org.drools.javaparser.metamodel.NameExprMetaModel;
import org.drools.javaparser.resolution.Resolvable;
import org.drools.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.drools.javaparser.utils.Utils;

public final class NameExpr
extends Expression
implements NodeWithSimpleName<NameExpr>,
Resolvable<ResolvedValueDeclaration> {
    private SimpleName name;
    private int backReferencesCount = 0;

    public NameExpr() {
        this(null, new SimpleName(), 0);
    }

    public NameExpr(String name) {
        this(null, new SimpleName(name), 0);
    }

    @AllFieldsConstructor
    public NameExpr(SimpleName name, int backReferencesCount) {
        this(name.getTokenRange().orElse(null), name, backReferencesCount);
        this.setRange(name.getRange().orElse(null));
    }

    public NameExpr(SimpleName name) {
        this(name, 0);
    }

    public NameExpr(TokenRange tokenRange, SimpleName name, int backReferencesCount) {
        super(tokenRange);
        this.setName(name);
        this.customInitialization();
        this.backReferencesCount = backReferencesCount;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public NameExpr setName(SimpleName name) {
        Utils.assertNotNull(name);
        if (name == this.name) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Override
    public NameExpr clone() {
        return (NameExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public NameExprMetaModel getMetaModel() {
        return JavaParserMetaModel.nameExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.name) {
            this.setName((SimpleName)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isNameExpr() {
        return true;
    }

    @Override
    public NameExpr asNameExpr() {
        return this;
    }

    @Override
    public void ifNameExpr(Consumer<NameExpr> action) {
        action.accept(this);
    }

    @Override
    public ResolvedValueDeclaration resolve() {
        return this.getSymbolResolver().resolveDeclaration(this, ResolvedValueDeclaration.class);
    }

    @Override
    public Optional<NameExpr> toNameExpr() {
        return Optional.of(this);
    }

    public int getBackReferencesCount() {
        return this.backReferencesCount;
    }

    public NameExpr setBackReferencesCount(int backReferencesCount) {
        if (backReferencesCount == this.backReferencesCount) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.BACK_REFERENCES_COUNT, this.backReferencesCount, backReferencesCount);
        this.backReferencesCount = backReferencesCount;
        return this;
    }
}

