/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.expression;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.drools.core.util.index.IndexUtil;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.ast.body.Parameter;
import org.drools.javaparser.ast.expr.BinaryExpr;
import org.drools.javaparser.ast.expr.ClassExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.expr.FieldAccessExpr;
import org.drools.javaparser.ast.expr.LambdaExpr;
import org.drools.javaparser.ast.expr.LiteralExpr;
import org.drools.javaparser.ast.expr.MethodCallExpr;
import org.drools.javaparser.ast.expr.NameExpr;
import org.drools.javaparser.ast.expr.StringLiteralExpr;
import org.drools.javaparser.ast.stmt.ExpressionStmt;
import org.drools.javaparser.ast.stmt.Statement;
import org.drools.javaparser.ast.type.UnknownType;
import org.drools.model.Index;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.MultipleDrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.SingleDrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.expression.AbstractExpressionBuilder;

public class PatternExpressionBuilder
extends AbstractExpressionBuilder {
    public static final String EXPR_CALL = "expr";
    public static final String REACT_ON_CALL = "D.reactOn";
    public static final String BIND_CALL = "bind";
    public static final String OR_CALL = "or";
    public static final String AND_CALL = "and";
    public static final String END_OR_CALL = "endOr";
    public static final String END_AND_CALL = "endAnd";

    public PatternExpressionBuilder(RuleContext context) {
        super(context);
    }

    @Override
    public MethodCallExpr buildExpressionWithIndexing(DrlxParseSuccess drlxParseResult) {
        if (drlxParseResult instanceof MultipleDrlxParseSuccess) {
            MultipleDrlxParseSuccess multi = (MultipleDrlxParseSuccess)drlxParseResult;
            MethodCallExpr exprDSL = new MethodCallExpr(null, multi.getOperator() == BinaryExpr.Operator.OR ? OR_CALL : AND_CALL);
            for (DrlxParseSuccess child : multi.getResults()) {
                MethodCallExpr childExpr = this.buildExpressionWithIndexing(child);
                childExpr.setScope((Expression)exprDSL);
                exprDSL = childExpr;
            }
            return new MethodCallExpr((Expression)exprDSL, multi.getOperator() == BinaryExpr.Operator.OR ? END_OR_CALL : END_AND_CALL);
        }
        return this.buildSingleExpressionWithIndexing((SingleDrlxParseSuccess)drlxParseResult);
    }

    private MethodCallExpr buildSingleExpressionWithIndexing(SingleDrlxParseSuccess drlxParseResult) {
        String exprId = drlxParseResult.getExprId();
        MethodCallExpr exprDSL = new MethodCallExpr(null, EXPR_CALL);
        if (exprId != null && !"".equals(exprId)) {
            exprDSL.addArgument((Expression)new StringLiteralExpr(exprId));
        }
        MethodCallExpr finalExprDSL = exprDSL = this.buildExpression(drlxParseResult, exprDSL);
        this.buildIndexedBy(drlxParseResult).ifPresent(arg_0 -> ((MethodCallExpr)finalExprDSL).addArgument(arg_0));
        this.buildReactOn(drlxParseResult).ifPresent(arg_0 -> ((MethodCallExpr)finalExprDSL).addArgument(arg_0));
        return exprDSL;
    }

    private MethodCallExpr buildExpression(SingleDrlxParseSuccess drlxParseResult, MethodCallExpr exprDSL) {
        ArrayList<String> usedDeclarationsWithUnification = new ArrayList<String>();
        usedDeclarationsWithUnification.addAll(drlxParseResult.getUsedDeclarations());
        if (drlxParseResult.isTemporal() && drlxParseResult.getLeft() != null && !(drlxParseResult.getLeft().getExpression() instanceof NameExpr)) {
            exprDSL.addArgument(DrlxParseUtil.generateLambdaWithoutParameters(drlxParseResult.getLeft().getExpression()));
        }
        usedDeclarationsWithUnification.stream().filter(s -> !drlxParseResult.isSkipThisAsParam() || !s.equals(drlxParseResult.getPatternBinding())).map(this.context::getVarExpr).forEach(arg_0 -> ((MethodCallExpr)exprDSL).addArgument(arg_0));
        if (drlxParseResult.getRightLiteral() != null) {
            exprDSL.addArgument("" + drlxParseResult.getRightLiteral());
        } else if (drlxParseResult.isTemporal() && drlxParseResult.getRight() != null && !(drlxParseResult.getRight().getExpression() instanceof NameExpr)) {
            exprDSL.addArgument(DrlxParseUtil.generateLambdaWithoutParameters(drlxParseResult.getRight().getExpression()));
        }
        exprDSL.addArgument(this.buildConstraintExpression(drlxParseResult, drlxParseResult.getExpr()));
        return exprDSL;
    }

    private Optional<MethodCallExpr> buildReactOn(SingleDrlxParseSuccess drlxParseResult) {
        if (!drlxParseResult.isTemporal() && !drlxParseResult.getReactOnProperties().isEmpty() && this.context.isPropertyReactive(drlxParseResult.getPatternType())) {
            MethodCallExpr reactOnDSL = new MethodCallExpr(null, REACT_ON_CALL);
            drlxParseResult.getReactOnProperties().stream().map(StringLiteralExpr::new).forEach(arg_0 -> ((MethodCallExpr)reactOnDSL).addArgument(arg_0));
            return Optional.of(reactOnDSL);
        }
        return Optional.empty();
    }

    @Override
    public MethodCallExpr buildBinding(SingleDrlxParseSuccess drlxParseResult) {
        SingleDrlxParseSuccess singleResult = drlxParseResult;
        MethodCallExpr bindDSL = new MethodCallExpr(null, BIND_CALL);
        if (drlxParseResult.hasUnificationVariable()) {
            bindDSL.addArgument(this.context.getVarExpr(drlxParseResult.getUnificationVariable()));
        } else {
            bindDSL.addArgument(this.context.getVarExpr(drlxParseResult.getExprBinding()));
        }
        Expression constraintExpression = this.getConstraintExpression(drlxParseResult);
        drlxParseResult.getUsedDeclarationsOnLeft().forEach(d -> {
            MethodCallExpr cfr_ignored_0 = (MethodCallExpr)bindDSL.addArgument(this.context.getVar((String)d));
        });
        bindDSL.addArgument(constraintExpression);
        Optional<MethodCallExpr> methodCallExpr = this.buildReactOn(singleResult);
        methodCallExpr.ifPresent(arg_0 -> ((MethodCallExpr)bindDSL).addArgument(arg_0));
        return bindDSL;
    }

    private Optional<MethodCallExpr> buildIndexedBy(SingleDrlxParseSuccess drlxParseResult) {
        if (drlxParseResult.isUnification()) {
            TypedExpression left = drlxParseResult.getLeft();
            TypedExpression right = drlxParseResult.getRight();
            LambdaExpr indexedBy_leftOperandExtractor = new LambdaExpr();
            indexedBy_leftOperandExtractor.addParameter(new Parameter((org.drools.javaparser.ast.type.Type)new UnknownType(), "_this"));
            boolean leftContainsThis = left.getExpression().toString().contains("_this");
            indexedBy_leftOperandExtractor.setBody((Statement)new ExpressionStmt(leftContainsThis ? left.getExpression() : right.getExpression()));
            MethodCallExpr indexedByDSL = new MethodCallExpr(null, drlxParseResult.isBetaNode() ? "D.betaIndexedBy" : "D.alphaIndexedBy");
            indexedByDSL.addArgument((Expression)new ClassExpr(JavaParser.parseType((String)this.getIndexType(left, right).getCanonicalName())));
            indexedByDSL.addArgument(Index.ConstraintType.class.getCanonicalName() + ".EQUAL");
            indexedByDSL.addArgument("-1");
            indexedByDSL.addArgument((Expression)indexedBy_leftOperandExtractor);
            indexedByDSL.addArgument("" + null);
            return Optional.of(indexedByDSL);
        }
        if (!this.hasIndex(drlxParseResult)) {
            return Optional.empty();
        }
        IndexUtil.ConstraintType decodeConstraintType = drlxParseResult.getDecodeConstraintType();
        TypedExpression left = drlxParseResult.getLeft();
        TypedExpression right = drlxParseResult.getRight();
        boolean isBeta = drlxParseResult.isBetaNode();
        if (!isBeta && !(right.getExpression() instanceof LiteralExpr)) {
            return Optional.empty();
        }
        FieldAccessExpr indexedBy_constraintType = new FieldAccessExpr((Expression)new NameExpr("org.drools.model.Index.ConstraintType"), decodeConstraintType.toString());
        LambdaExpr indexedBy_leftOperandExtractor = new LambdaExpr();
        indexedBy_leftOperandExtractor.addParameter(new Parameter((org.drools.javaparser.ast.type.Type)new UnknownType(), "_this"));
        boolean leftContainsThis = left.getExpression().toString().contains("_this");
        indexedBy_leftOperandExtractor.setBody((Statement)new ExpressionStmt(leftContainsThis ? left.getExpression() : right.getExpression()));
        MethodCallExpr indexedByDSL = new MethodCallExpr(null, isBeta ? "D.betaIndexedBy" : "D.alphaIndexedBy");
        indexedByDSL.addArgument((Expression)new ClassExpr(JavaParser.parseType((String)this.getIndexType(left, right).getCanonicalName())));
        indexedByDSL.addArgument((Expression)indexedBy_constraintType);
        indexedByDSL.addArgument("" + indexIdGenerator.getFieldId(drlxParseResult.getPatternType(), left.getFieldName()));
        indexedByDSL.addArgument((Expression)indexedBy_leftOperandExtractor);
        Collection<String> usedDeclarations = drlxParseResult.getUsedDeclarations();
        Type leftType = left.getType();
        if (this.isAlphaIndex(usedDeclarations)) {
            indexedByDSL.addArgument(this.narrowExpressionToType(right, left.getType()));
        } else if (usedDeclarations.size() == 1) {
            this.addIndexedByDeclaration(left, right, leftContainsThis, indexedByDSL, usedDeclarations, leftType);
        }
        return Optional.of(indexedByDSL);
    }
}

