/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.consequence;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.core.WorkingMemory;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Tuple;
import org.drools.core.util.ClassUtils;
import org.drools.model.Consequence;
import org.drools.model.Variable;
import org.drools.model.functions.ScriptBlock;
import org.drools.modelcompiler.RuleContext;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.CachingMapVariableResolverFactory;

public class MVELConsequence
implements org.drools.core.spi.Consequence {
    private final Consequence consequence;
    private final RuleContext context;
    private MVELCompilationUnit cu;
    private ExecutableStatement compiledExpression;

    public MVELConsequence(Consequence consequence, RuleContext context) {
        this.consequence = consequence;
        this.context = context;
        this.init();
    }

    public String getName() {
        return "default";
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
        HashMap<String, Object> mvelContext = new HashMap<String, Object>();
        mvelContext.put("this", knowledgeHelper);
        mvelContext.put("drools", knowledgeHelper);
        mvelContext.put("kcontext", knowledgeHelper);
        mvelContext.put("rule", knowledgeHelper.getRule());
        Tuple tuple = knowledgeHelper.getTuple();
        Declaration[] declarations = ((RuleTerminalNode)knowledgeHelper.getMatch().getTuple().getTupleSink()).getRequiredDeclarations();
        int declrCounter = 0;
        for (Variable var : this.consequence.getVariables()) {
            if (var.isFact()) {
                Declaration declaration = declarations[declrCounter++];
                InternalFactHandle fh = tuple.get(declaration);
                mvelContext.put(var.getName(), declaration.getValue((InternalWorkingMemory)workingMemory, fh.getObject()));
                continue;
            }
            mvelContext.put(var.getName(), workingMemory.getGlobal(var.getName()));
        }
        CachingMapVariableResolverFactory cachingFactory = new CachingMapVariableResolverFactory(mvelContext);
        VariableResolverFactory factory = this.cu.getFactory((Object)knowledgeHelper, ((AgendaItem)knowledgeHelper.getMatch()).getTerminalNode().getRequiredDeclarations(), (Rule)knowledgeHelper.getRule(), knowledgeHelper.getTuple(), null, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver());
        cachingFactory.setNextFactory(factory);
        MVEL.executeExpression((Object)this.compiledExpression, (Object)knowledgeHelper, (VariableResolverFactory)cachingFactory);
    }

    private void init() {
        Variable[] vars = this.consequence.getVariables();
        ScriptBlock scriptBlock = null;
        try {
            scriptBlock = (ScriptBlock)this.consequence.getBlock();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("I tried to access a ScriptBlock but it was not. So something is thinking is a MVEL consequence but did not set the MVEL script textual representation", e);
        }
        String originalRHS = scriptBlock.getScript();
        String name = this.context.getRule().getPackageName() + "." + this.context.getRule().getName();
        String expression = MVELConsequenceBuilder.processMacros((String)originalRHS);
        String[] globalIdentifiers = new String[]{};
        String[] default_inputIdentifiers = new String[]{"this", "drools", "kcontext", "rule"};
        String[] inputIdentifiers = Stream.concat(Arrays.asList(default_inputIdentifiers).stream(), Stream.of(vars).map(Variable::getName)).collect(Collectors.toList()).toArray(new String[0]);
        String[] default_inputTypes = new String[]{"org.drools.core.spi.KnowledgeHelper", "org.drools.core.spi.KnowledgeHelper", "org.drools.core.spi.KnowledgeHelper", "org.kie.api.definition.rule.Rule"};
        String[] inputTypes = Stream.concat(Arrays.asList(default_inputTypes).stream(), Stream.of(vars).map(var -> var.getType().getName())).collect(Collectors.toList()).toArray(new String[0]);
        boolean strictMode = true;
        boolean readLocalsFromTuple = false;
        EvaluatorWrapper[] operators = new EvaluatorWrapper[]{};
        Declaration[] previousDeclarations = new Declaration[]{};
        Declaration[] localDeclarations = new Declaration[]{};
        String[] otherIdentifiers = new String[]{};
        expression = MVELConsequenceBuilder.rewriteUpdates(this.context::getDeclarationClass, ClassUtils::getAccessibleProperties, (String)expression);
        this.cu = new MVELCompilationUnit(name, expression, globalIdentifiers, operators, previousDeclarations, localDeclarations, otherIdentifiers, inputIdentifiers, inputTypes, strictMode, readLocalsFromTuple);
        MVELDialectRuntimeData runtimeData = new MVELDialectRuntimeData();
        runtimeData.onAdd(null, Thread.currentThread().getContextClassLoader());
        runtimeData.addPackageImport(this.context.getPkg().getName());
        runtimeData.addPackageImport("java.lang");
        for (KiePackage kiePackage : this.context.getKnowledgePackages()) {
            if (kiePackage.getName().equals(this.context.getPkg().getName())) continue;
            runtimeData.addPackageImport(kiePackage.getName());
        }
        ParserConfiguration parserConfiguration = runtimeData.getParserConfiguration();
        parserConfiguration.setClassLoader(this.context.getClassLoader());
        Class clazz = scriptBlock.getRuleClass();
        if (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers())) continue;
                runtimeData.getParserConfiguration().addImport(m.getName(), m);
            }
        }
        this.compiledExpression = (ExecutableStatement)this.cu.getCompiledExpression(runtimeData);
    }
}

