/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.printer;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.drlx.OOPathChunk;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.drlx.RuleBody;
import org.drools.javaparser.ast.drlx.RuleDeclaration;
import org.drools.javaparser.ast.drlx.expr.CommaSeparatedMethodCallExpr;
import org.drools.javaparser.ast.drlx.expr.DrlxExpression;
import org.drools.javaparser.ast.drlx.expr.HalfBinaryExpr;
import org.drools.javaparser.ast.drlx.expr.HalfPointFreeExpr;
import org.drools.javaparser.ast.drlx.expr.InlineCastExpr;
import org.drools.javaparser.ast.drlx.expr.NullSafeFieldAccessExpr;
import org.drools.javaparser.ast.drlx.expr.NullSafeMethodCallExpr;
import org.drools.javaparser.ast.drlx.expr.PointFreeExpr;
import org.drools.javaparser.ast.drlx.expr.TemporalChunkExpr;
import org.drools.javaparser.ast.drlx.expr.TemporalLiteralChunkExpr;
import org.drools.javaparser.ast.drlx.expr.TemporalLiteralExpr;
import org.drools.javaparser.ast.drlx.expr.TemporalLiteralInfiniteChunkExpr;
import org.drools.javaparser.ast.expr.AnnotationExpr;
import org.drools.javaparser.ast.expr.BigDecimalLiteralExpr;
import org.drools.javaparser.ast.expr.BigIntegerLiteralExpr;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.visitor.AbstractVoidRuleVisitor;
import org.drools.javaparser.printer.PrettyPrintVisitor;

public class DrlxPrintVisitor
extends AbstractVoidRuleVisitor<Void, PrettyPrintVisitor> {
    public DrlxPrintVisitor(PrettyPrintVisitor visitor) {
        super(visitor);
    }

    @Override
    public void visit(RuleDeclaration n, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(n.getComment(), arg);
        for (AnnotationExpr ae : n.getAnnotations()) {
            ae.accept(this.visitor, arg);
            ((PrettyPrintVisitor)this.visitor).printer.print(" ");
        }
        ((PrettyPrintVisitor)this.visitor).printer.print("rule ");
        n.getName().accept(this.visitor, arg);
        ((PrettyPrintVisitor)this.visitor).printer.println(" {");
        n.getRuleBody().accept(this.visitor, arg);
        ((PrettyPrintVisitor)this.visitor).printer.println("}");
    }

    @Override
    public void visit(RuleBody ruleBody, Void arg) {
    }

    @Override
    public void visit(InlineCastExpr inlineCastExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(inlineCastExpr.getComment(), arg);
        inlineCastExpr.getExpression().accept(this.visitor, arg);
        ((PrettyPrintVisitor)this.visitor).printer.print("#");
        inlineCastExpr.getType().accept(this.visitor, arg);
    }

    @Override
    public void visit(NullSafeFieldAccessExpr nullSafeFieldAccessExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(nullSafeFieldAccessExpr.getComment(), arg);
        nullSafeFieldAccessExpr.getScope().accept(this.visitor, arg);
        ((PrettyPrintVisitor)this.visitor).printer.print("!.");
        nullSafeFieldAccessExpr.getName().accept(this.visitor, arg);
    }

    @Override
    public void visit(NullSafeMethodCallExpr nullSafeMethodCallExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(nullSafeMethodCallExpr.getComment(), arg);
        if (nullSafeMethodCallExpr.getScope().isPresent()) {
            nullSafeMethodCallExpr.getScope().get().accept(this.visitor, arg);
            ((PrettyPrintVisitor)this.visitor).printer.print("!.");
        }
        ((PrettyPrintVisitor)this.visitor).printTypeArgs(nullSafeMethodCallExpr, arg);
        nullSafeMethodCallExpr.getName().accept(this.visitor, arg);
        ((PrettyPrintVisitor)this.visitor).printArguments(nullSafeMethodCallExpr.getArguments(), arg);
    }

    @Override
    public void visit(PointFreeExpr pointFreeExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(pointFreeExpr.getComment(), arg);
        pointFreeExpr.getLeft().accept(this.visitor, arg);
        if (pointFreeExpr.isNegated()) {
            ((PrettyPrintVisitor)this.visitor).printer.print(" not");
        }
        ((PrettyPrintVisitor)this.visitor).printer.print(" ");
        pointFreeExpr.getOperator().accept(this.visitor, arg);
        if (pointFreeExpr.getArg1() != null) {
            ((PrettyPrintVisitor)this.visitor).printer.print("[");
            pointFreeExpr.getArg1().accept(this.visitor, arg);
            if (pointFreeExpr.getArg2() != null) {
                ((PrettyPrintVisitor)this.visitor).printer.print(",");
                pointFreeExpr.getArg2().accept(this.visitor, arg);
            }
            if (pointFreeExpr.getArg3() != null) {
                ((PrettyPrintVisitor)this.visitor).printer.print(",");
                pointFreeExpr.getArg3().accept(this.visitor, arg);
            }
            if (pointFreeExpr.getArg4() != null) {
                ((PrettyPrintVisitor)this.visitor).printer.print(",");
                pointFreeExpr.getArg4().accept(this.visitor, arg);
            }
            ((PrettyPrintVisitor)this.visitor).printer.print("]");
        }
        ((PrettyPrintVisitor)this.visitor).printer.print(" ");
        NodeList<Expression> rightExprs = pointFreeExpr.getRight();
        if (rightExprs.size() == 1) {
            ((Expression)rightExprs.get(0)).accept(this.visitor, arg);
        } else {
            ((PrettyPrintVisitor)this.visitor).printer.print("(");
            if (rightExprs.isNonEmpty()) {
                ((Expression)rightExprs.get(0)).accept(this.visitor, arg);
            }
            for (int i = 1; i < rightExprs.size(); ++i) {
                ((PrettyPrintVisitor)this.visitor).printer.print(", ");
                ((Expression)rightExprs.get(i)).accept(this.visitor, arg);
            }
            ((PrettyPrintVisitor)this.visitor).printer.print(")");
        }
    }

    @Override
    public void visit(TemporalLiteralExpr temporalLiteralExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(temporalLiteralExpr.getComment(), arg);
        NodeList<TemporalChunkExpr> chunks = temporalLiteralExpr.getChunks();
        for (TemporalChunkExpr c : chunks) {
            c.accept(this.visitor, arg);
        }
    }

    @Override
    public void visit(TemporalLiteralChunkExpr temporalLiteralExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(temporalLiteralExpr.getComment(), arg);
        ((PrettyPrintVisitor)this.visitor).printer.print("" + temporalLiteralExpr.getValue());
        switch (temporalLiteralExpr.getTimeUnit()) {
            case MILLISECONDS: {
                ((PrettyPrintVisitor)this.visitor).printer.print("ms");
                break;
            }
            case SECONDS: {
                ((PrettyPrintVisitor)this.visitor).printer.print("s");
                break;
            }
            case MINUTES: {
                ((PrettyPrintVisitor)this.visitor).printer.print("m");
                break;
            }
            case HOURS: {
                ((PrettyPrintVisitor)this.visitor).printer.print("h");
                break;
            }
            case DAYS: {
                ((PrettyPrintVisitor)this.visitor).printer.print("d");
            }
        }
    }

    @Override
    public void visit(TemporalLiteralInfiniteChunkExpr temporalLiteralInfiniteChunkExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printer.print("*");
    }

    @Override
    public void visit(DrlxExpression expr, Void arg) {
        if (expr.getBind() != null) {
            expr.getBind().accept(this.visitor, arg);
            ((PrettyPrintVisitor)this.visitor).printer.print(" : ");
        }
        expr.getExpr().accept(this.visitor, arg);
    }

    @Override
    public void visit(OOPathExpr oopathExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(oopathExpr.getComment(), arg);
        ((PrettyPrintVisitor)this.visitor).printer.print("/");
        NodeList<OOPathChunk> chunks = oopathExpr.getChunks();
        for (int i = 0; i < chunks.size(); ++i) {
            OOPathChunk chunk = (OOPathChunk)chunks.get(i);
            chunk.accept(this.visitor, arg);
            ((PrettyPrintVisitor)this.visitor).printer.print(chunk.getField().toString());
            List<Expression> condition = chunk.getConditions();
            Iterator<Expression> iterator = condition.iterator();
            if (!condition.isEmpty()) {
                ((PrettyPrintVisitor)this.visitor).printer.print("[");
                Expression first = iterator.next();
                first.accept(this.visitor, arg);
                while (iterator.hasNext()) {
                    ((PrettyPrintVisitor)this.visitor).printer.print(",");
                    iterator.next().accept(this.visitor, arg);
                }
                ((PrettyPrintVisitor)this.visitor).printer.print("]");
            }
            if (i == chunks.size() - 1) continue;
            ((PrettyPrintVisitor)this.visitor).printer.print("/");
        }
    }

    @Override
    public void visit(HalfBinaryExpr n, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(n.getComment(), arg);
        ((PrettyPrintVisitor)this.visitor).printer.print(n.getOperator().asString());
        ((PrettyPrintVisitor)this.visitor).printer.print(" ");
        n.getRight().accept(this.visitor, arg);
    }

    @Override
    public void visit(HalfPointFreeExpr pointFreeExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printComment(pointFreeExpr.getComment(), arg);
        if (pointFreeExpr.isNegated()) {
            ((PrettyPrintVisitor)this.visitor).printer.print("not ");
        }
        pointFreeExpr.getOperator().accept(this.visitor, arg);
        if (pointFreeExpr.getArg1() != null) {
            ((PrettyPrintVisitor)this.visitor).printer.print("[");
            pointFreeExpr.getArg1().accept(this.visitor, arg);
            if (pointFreeExpr.getArg2() != null) {
                ((PrettyPrintVisitor)this.visitor).printer.print(",");
                pointFreeExpr.getArg2().accept(this.visitor, arg);
            }
            if (pointFreeExpr.getArg3() != null) {
                ((PrettyPrintVisitor)this.visitor).printer.print(",");
                pointFreeExpr.getArg3().accept(this.visitor, arg);
            }
            if (pointFreeExpr.getArg4() != null) {
                ((PrettyPrintVisitor)this.visitor).printer.print(",");
                pointFreeExpr.getArg4().accept(this.visitor, arg);
            }
            ((PrettyPrintVisitor)this.visitor).printer.print("]");
        }
        ((PrettyPrintVisitor)this.visitor).printer.print(" ");
        NodeList<Expression> rightExprs = pointFreeExpr.getRight();
        if (rightExprs.size() == 1) {
            ((Expression)rightExprs.get(0)).accept(this.visitor, arg);
        } else {
            ((PrettyPrintVisitor)this.visitor).printer.print("(");
            ((Expression)rightExprs.get(0)).accept(this.visitor, arg);
            for (int i = 1; i < rightExprs.size(); ++i) {
                ((PrettyPrintVisitor)this.visitor).printer.print(", ");
                ((Expression)rightExprs.get(i)).accept(this.visitor, arg);
            }
            ((PrettyPrintVisitor)this.visitor).printer.print(")");
        }
    }

    @Override
    public void visit(BigDecimalLiteralExpr bigDecimalLiteralExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printer.print(bigDecimalLiteralExpr.asBigDecimal().toString());
        ((PrettyPrintVisitor)this.visitor).printer.print("B");
    }

    @Override
    public void visit(BigIntegerLiteralExpr bigIntegerLiteralExpr, Void arg) {
        ((PrettyPrintVisitor)this.visitor).printer.print(bigIntegerLiteralExpr.asBigInteger().toString());
        ((PrettyPrintVisitor)this.visitor).printer.print("I");
    }

    @Override
    public void visit(CommaSeparatedMethodCallExpr commaSeparatedMethodCallExpr, Void arg) {
        String expressionWithComma = commaSeparatedMethodCallExpr.getExpressions().stream().map(Node::toString).collect(Collectors.joining(", "));
        ((PrettyPrintVisitor)this.visitor).printer.print(expressionWithComma);
        ((PrettyPrintVisitor)this.visitor).printer.print(";");
    }
}

