/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.PatternSourceDescr;
import org.drools.constraint.parser.ast.expr.DrlNameExpr;
import org.drools.constraint.parser.ast.expr.DrlxExpression;
import org.drools.constraint.parser.printer.PrintUtil;
import org.drools.core.rule.Pattern;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.errors.InvalidExpressionErrorResult;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.drlxparse.SingleDrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.expressiontyper.ExpressionTyper;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class FromVisitor {
    private final RuleContext context;
    private final PackageModel packageModel;
    private final Class<?> patternType;

    public FromVisitor(RuleContext context, PackageModel packageModel, Class<?> patternType) {
        this.context = context;
        this.packageModel = packageModel;
        this.patternType = patternType;
    }

    public Optional<Expression> visit(PatternSourceDescr sourceDescr) {
        if (sourceDescr instanceof FromDescr) {
            String expression = ((FromDescr)sourceDescr).getDataSource().toString();
            boolean isEnumeratedList = expression.startsWith("[") && expression.endsWith("]");
            return isEnumeratedList ? this.createEnumeratedFrom(expression.substring(1, expression.length() - 1)) : this.createSingleFrom(expression);
        }
        return Optional.empty();
    }

    private Optional<Expression> createSingleFrom(String expression) {
        Expression parsedExpression = DrlxParseUtil.parseExpression(expression).getExpr();
        if (parsedExpression instanceof FieldAccessExpr || parsedExpression instanceof NameExpr || parsedExpression instanceof DrlNameExpr) {
            return this.fromFieldOrName(expression);
        }
        if (parsedExpression instanceof MethodCallExpr) {
            MethodCallExpr sanitized = DrlxParseUtil.sanitizeDrlNameExpr((MethodCallExpr)parsedExpression);
            return this.fromMethodExpr(expression, sanitized);
        }
        if (parsedExpression instanceof ObjectCreationExpr) {
            return this.fromConstructorExpr(expression, (ObjectCreationExpr)parsedExpression);
        }
        if (parsedExpression instanceof LiteralExpr) {
            MethodCallExpr fromCall = new MethodCallExpr(null, "D.from");
            fromCall.addArgument(parsedExpression);
            return Optional.of(fromCall);
        }
        return Optional.empty();
    }

    private Optional<Expression> createEnumeratedFrom(String expressions) {
        MethodCallExpr fromCall = new MethodCallExpr(null, "D.from");
        MethodCallExpr asListCall = new MethodCallExpr(null, "java.util.Arrays.asList");
        ArrayList<String> usedDeclarations = new ArrayList<String>();
        for (String expr : expressions.split(",")) {
            Optional<DeclarationSpec> optContainsBinding = this.context.getDeclarationById(expr);
            if (optContainsBinding.isPresent()) {
                String bindingId = optContainsBinding.get().getBindingId();
                fromCall.addArgument(this.context.getVarExpr(bindingId));
                usedDeclarations.add(expr);
            }
            asListCall.addArgument(expr);
        }
        fromCall.addArgument(DrlxParseUtil.generateLambdaWithoutParameters(usedDeclarations, (Expression)asListCall, true));
        return Optional.of(fromCall);
    }

    private Optional<Expression> fromMethodExpr(String expression, MethodCallExpr parsedExpression) {
        return this.fromExpressionViaScope(expression, (Expression)parsedExpression).map(Optional::of).orElseGet(() -> this.fromExpressionUsingArguments(expression, (NodeWithArguments<?>)parsedExpression));
    }

    private Optional<Expression> fromConstructorExpr(String expression, ObjectCreationExpr parsedExpression) {
        MethodCallExpr fromCall = new MethodCallExpr(null, "D.from");
        ArrayList<String> bindingIds = new ArrayList<String>();
        for (Expression argument : parsedExpression.getArguments()) {
            String argumentName = PrintUtil.printConstraint((Node)argument);
            if (!this.contextHasDeclaration(argumentName)) continue;
            bindingIds.add(argumentName);
            fromCall.addArgument(this.context.getVarExpr(argumentName));
        }
        fromCall.addArgument(DrlxParseUtil.generateLambdaWithoutParameters(bindingIds, (Expression)parsedExpression, true));
        return Optional.of(fromCall);
    }

    private Optional<Expression> fromFieldOrName(String expression) {
        Optional staticField;
        Optional<String> optContainsBinding = DrlxParseUtil.findBindingIdFromDotExpression(expression);
        String bindingId = optContainsBinding.orElse(expression);
        DrlxExpression drlxExpression = DrlxParseUtil.parseExpression(expression);
        Expression parsedExpression = drlxExpression.getExpr();
        Optional<Object> optional = staticField = parsedExpression instanceof FieldAccessExpr ? ExpressionTyper.tryParseAsConstantField(this.context.getTypeResolver(), ((FieldAccessExpr)parsedExpression).getScope(), ((FieldAccessExpr)parsedExpression).getNameAsString()) : Optional.empty();
        if (staticField.isPresent()) {
            return Optional.of(this.createSupplier(parsedExpression));
        }
        if (this.contextHasDeclaration(bindingId)) {
            return Optional.of(this.createFromCall(expression, bindingId, optContainsBinding.isPresent()));
        }
        return Optional.of(this.createUnitDataCall(bindingId));
    }

    private Expression createSupplier(Expression parsedExpression) {
        LambdaExpr lambdaExpr = new LambdaExpr(NodeList.nodeList((Node[])new Parameter[0]), (Statement)new ExpressionStmt(parsedExpression), true);
        MethodCallExpr fromCall = new MethodCallExpr(null, "D.from");
        fromCall.addArgument((Expression)lambdaExpr);
        return fromCall;
    }

    private Optional<Expression> fromExpressionUsingArguments(String expression, NodeWithArguments<?> methodCallExpr) {
        MethodCallExpr fromCall = new MethodCallExpr(null, "D.from");
        String bindingId = null;
        for (Expression argument : methodCallExpr.getArguments()) {
            String argumentName = PrintUtil.printConstraint((Node)argument);
            if (!this.contextHasDeclaration(argumentName)) continue;
            if (bindingId == null) {
                bindingId = argumentName;
            }
            fromCall.addArgument(this.context.getVarExpr(argumentName));
        }
        return bindingId != null ? Optional.of(this.addLambdaToFromExpression(expression, bindingId, fromCall)) : Optional.of(this.addNoArgLambdaToFromExpression(expression, fromCall));
    }

    private Optional<Expression> fromExpressionViaScope(String expression, Expression methodCallExpr) {
        Expression sanitizedMethodCallExpr = (Expression)DrlxParseUtil.transformDrlNameExprToNameExpr((Node)methodCallExpr);
        return DrlxParseUtil.findViaScopeWithPredicate(sanitizedMethodCallExpr, e -> {
            if (e instanceof NameExpr) {
                return this.contextHasDeclaration(((NameExpr)e).getName().toString());
            }
            return false;
        }).filter(Expression::isNameExpr).map(e -> this.createFromCall(expression, e.asNameExpr().toString(), true));
    }

    private boolean contextHasDeclaration(String name) {
        return this.context.hasDeclaration(name) || this.packageModel.hasDeclaration(name);
    }

    private Expression createFromCall(String expression, String bindingId, boolean hasBinding) {
        MethodCallExpr fromCall = new MethodCallExpr(null, "D.from");
        fromCall.addArgument(this.context.getVarExpr(bindingId));
        return hasBinding ? this.addLambdaToFromExpression(expression, bindingId, fromCall) : fromCall;
    }

    private Expression addLambdaToFromExpression(String expression, String bindingId, MethodCallExpr fromCall) {
        Expression exprArg = this.createArg(expression, bindingId);
        if (exprArg != null) {
            fromCall.addArgument(exprArg);
        }
        return fromCall;
    }

    private Expression addNoArgLambdaToFromExpression(String expression, MethodCallExpr fromCall) {
        fromCall.addArgument(DrlxParseUtil.generateLambdaWithoutParameters(Collections.emptyList(), DrlxParseUtil.parseExpression(expression).getExpr(), true));
        return fromCall;
    }

    private Expression createArg(String expression, String bindingId) {
        if (bindingId != null) {
            DeclarationSpec declarationSpec = this.context.getDeclarationById(bindingId).orElseThrow(RuntimeException::new);
            Class<?> clazz = declarationSpec.getDeclarationClass();
            DrlxParseResult drlxParseResult = new ConstraintParser(this.context, this.packageModel).drlxParse(clazz, bindingId, expression);
            return drlxParseResult.acceptWithReturnValue(drlxParseSuccess -> {
                SingleDrlxParseSuccess singleResult = (SingleDrlxParseSuccess)drlxParseResult;
                TypedExpression left = singleResult.getLeft();
                if (left != null && !Pattern.isCompatibleWithFromReturnType(this.patternType, left.getRawClass())) {
                    this.context.addCompilationError((KnowledgeBuilderResult)new InvalidExpressionErrorResult("Pattern of type: '" + this.patternType.getCanonicalName() + "' on rule '" + this.context.getRuleName() + "' is not compatible with type " + left.getRawClass().getCanonicalName() + " returned by source"));
                }
                Expression parsedExpression = drlxParseSuccess.getExpr();
                return DrlxParseUtil.generateLambdaWithoutParameters(singleResult.getUsedDeclarations(), parsedExpression);
            });
        }
        return null;
    }

    private Expression createUnitDataCall(String bindingId) {
        return JavaParser.parseExpression((String)DrlxParseUtil.toVar(bindingId));
    }
}

