/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidInfo;
import org.stringtemplate.v4.ST;

@SupportedAnnotationTypes(value={"org.jbpm.process.workitem.core.util.Wid"})
public class WidProcessor
extends AbstractProcessor {
    private Map<String, List<Wid>> processingResults;
    private boolean resetResults = true;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.resetResults) {
            this.processingResults = new HashMap<String, List<Wid>>();
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Wid.class)) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, MessageFormat.format("Wid Processor : processing class {0}.", typeElement.asType().toString()));
            this.processingResults.put(typeElement.asType().toString(), new ArrayList());
            if (typeElement.getInterfaces() != null && typeElement.getInterfaces().size() > 0) {
                for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                    if (typeMirror.getAnnotation(Wid.class) == null) continue;
                    this.processingResults.get(typeElement.asType().toString()).add(typeMirror.getAnnotation(Wid.class));
                }
            }
            this.processingResults.get(typeElement.asType().toString()).add(typeElement.getAnnotation(Wid.class));
        }
        return this.postProcessWorkItemDefinition();
    }

    public boolean postProcessWorkItemDefinition() {
        if (this.processingResults == null || this.processingResults.size() < 1) {
            return false;
        }
        try {
            HashMap<String, WidInfo> wrappedResults = new HashMap<String, WidInfo>();
            for (String key : this.processingResults.keySet()) {
                wrappedResults.put(key, new WidInfo(this.processingResults.get(key)));
            }
            String widName = "WorkDefinitions";
            if (this.processingEnv.getOptions().containsKey("widName")) {
                widName = this.processingEnv.getOptions().get("widName");
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Unable to find option \"widName\", using default (WorkDefinitions)");
            }
            boolean generateTemplates = false;
            if (this.processingEnv.getOptions().containsKey("generateTemplates")) {
                generateTemplates = Boolean.parseBoolean(this.processingEnv.getOptions().get("generateTemplates"));
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Unable to find option \"generateTemplates\", using default (false).");
            }
            if (generateTemplates) {
                if (this.processingEnv.getOptions().containsKey("templateResources")) {
                    List<String> templateResourceList = Arrays.asList(this.processingEnv.getOptions().get("templateResources").split(","));
                    for (String templateResource : templateResourceList) {
                        String[] templateInfo = templateResource.split(":");
                        this.writeStream(this.getFileObject("", templateInfo[0]), this.getTemplateData(templateInfo[1], wrappedResults));
                    }
                } else {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Unable to find option \"templateResources\", using default (none).");
                }
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Not generating templates.");
            }
            boolean generateWids = false;
            if (this.processingEnv.getOptions().containsKey("generateWids")) {
                generateWids = Boolean.parseBoolean(this.processingEnv.getOptions().get("generateWids"));
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Unable to find option \"generateWids\", using default (false).");
            }
            if (generateWids) {
                if (this.processingEnv.getOptions().containsKey("widsResources")) {
                    String[] widInfo = this.processingEnv.getOptions().get("widsResources").split(":");
                    this.generateWids(widInfo, wrappedResults);
                } else {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Unable to find option \"widsResources\", using default (none).");
                }
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Not generating wids.");
            }
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, MessageFormat.format("Error post-processing workitem annotations: {0}.", e.getMessage()));
        }
        return true;
    }

    public void generateWids(String[] widInfo, Map<String, WidInfo> wrappedResults) throws IOException {
        this.writeStream(this.getFileObject("", widInfo[0]), this.getTemplateData(widInfo[1], wrappedResults));
        Set<String> resultKeys = wrappedResults.keySet();
        for (String key : resultKeys) {
            HashMap<String, WidInfo> keyMap = new HashMap<String, WidInfo>();
            keyMap.put(key, wrappedResults.get(key));
            this.writeStream(this.getFileObject("", wrappedResults.get(key).getName() + ".wid"), this.getTemplateData(widInfo[1], keyMap));
        }
    }

    public byte[] getTemplateData(String templateResource, Map<String, WidInfo> widInfoMap) throws IOException {
        ST stTemplate = new ST(this.getTemplateResourceFileAsString(templateResource), '$', '$');
        stTemplate.add("widInfo", widInfoMap);
        stTemplate.add("openbracket", (Object)"{");
        stTemplate.add("closebracket", (Object)"}");
        return stTemplate.render().getBytes();
    }

    public void writeStream(FileObject fileObject, byte[] data) throws IOException {
        OutputStream stream = fileObject.openOutputStream();
        stream.write(data);
        stream.close();
    }

    public FileObject getFileObject(String pkg, String name) throws IOException {
        return this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, pkg, name, new Element[0]);
    }

    public void setResetResults(boolean resetResults) {
        this.resetResults = resetResults;
    }

    public Map<String, List<Wid>> getProcessingResults() {
        return this.processingResults;
    }

    public void setProcessingResults(Map<String, List<Wid>> processingResults) {
        this.processingResults = processingResults;
    }

    public String getTemplateResourceFileAsString(String resourceFileName) throws IOException {
        FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", resourceFileName);
        return fileObject.getCharContent(true).toString();
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }
}

