/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.instance.StartProcessHelper;
import org.jbpm.services.api.model.UserTaskDefinition;
import org.kie.api.definition.process.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDescriptor
implements Serializable {
    private static final long serialVersionUID = -6304675827486128074L;
    private static final Logger logger = LoggerFactory.getLogger(ProcessDescriptor.class);
    private ProcessAssetDesc process;
    private Map<String, UserTaskDefinition> tasks = new HashMap<String, UserTaskDefinition>();
    private Map<String, Map<String, String>> taskInputMappings = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> taskOutputMappings = new HashMap<String, Map<String, String>>();
    private Map<String, String> inputs = new HashMap<String, String>();
    private Map<String, Collection<String>> taskAssignments = new HashMap<String, Collection<String>>();
    private Map<String, String> itemDefinitions = new HashMap<String, String>();
    private Map<String, String> serviceTasks = new HashMap<String, String>();
    private Map<String, String> globalItemDefinitions = new HashMap<String, String>();
    private Collection<String> reusableSubProcesses = new HashSet<String>(1);
    private Set<String> referencedClasses = new HashSet<String>(1);
    private Set<String> unqualifiedClasses = new HashSet<String>(1);
    private Set<String> referencedRules = new HashSet<String>(1);
    private Collection<String> signals = Collections.emptySet();
    private Collection<String> globals = Collections.emptySet();
    private Queue<String> unresolvedReusableSubProcessNames = new ArrayDeque<String>();

    public void setProcess(ProcessAssetDesc process) {
        this.process = process;
    }

    public boolean hasUnresolvedReusableSubProcessNames() {
        return !this.unresolvedReusableSubProcessNames.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveReusableSubProcessNames(Collection<Process> deploymentProcesses) {
        String processName;
        HashMap<String, Process> processNameProcessIdMap = new HashMap<String, Process>(deploymentProcesses.size());
        for (Process process : deploymentProcesses) {
            Comparator processComparator;
            processName = process.getName();
            Process previousProcess = processNameProcessIdMap.put(processName, process);
            if (previousProcess == null || (processComparator = StartProcessHelper.getComparator((String)processName)).compare(previousProcess, process) <= 0) continue;
            processNameProcessIdMap.put(processName, previousProcess);
        }
        Queue<String> queue = this.unresolvedReusableSubProcessNames;
        synchronized (queue) {
            Iterator iter = this.unresolvedReusableSubProcessNames.iterator();
            while (iter.hasNext()) {
                processName = (String)iter.next();
                Process deploymentProcess = (Process)processNameProcessIdMap.get(processName);
                if (deploymentProcess == null) {
                    logger.error("Unable to resolve process name '{}' called in process '{}'", (Object)processName, (Object)this.getProcess().getId());
                    continue;
                }
                String processIdForProcessName = deploymentProcess.getId();
                this.reusableSubProcesses.add(processIdForProcessName);
                iter.remove();
            }
        }
    }

    public ProcessAssetDesc getProcess() {
        return this.process;
    }

    public Map<String, UserTaskDefinition> getTasks() {
        return this.tasks;
    }

    public Map<String, Map<String, String>> getTaskInputMappings() {
        return this.taskInputMappings;
    }

    public Map<String, Map<String, String>> getTaskOutputMappings() {
        return this.taskOutputMappings;
    }

    public Map<String, String> getInputs() {
        return this.inputs;
    }

    public Map<String, Collection<String>> getTaskAssignments() {
        return this.taskAssignments;
    }

    public Map<String, String> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public Map<String, String> getServiceTasks() {
        return this.serviceTasks;
    }

    public Map<String, String> getGlobalItemDefinitions() {
        return this.globalItemDefinitions;
    }

    public Collection<String> getReusableSubProcesses() {
        return this.reusableSubProcesses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReusableSubProcessName(String processName) {
        Queue<String> queue = this.unresolvedReusableSubProcessNames;
        synchronized (queue) {
            this.unresolvedReusableSubProcessNames.add(processName);
        }
    }

    public Set<String> getReferencedClasses() {
        return this.referencedClasses;
    }

    public Set<String> getUnqualifiedClasses() {
        return this.unqualifiedClasses;
    }

    public Set<String> getReferencedRules() {
        return this.referencedRules;
    }

    public Collection<String> getSignals() {
        return this.signals;
    }

    public void setSignals(Collection<String> signals) {
        this.signals = signals;
    }

    public Collection<String> getGlobals() {
        return this.globals;
    }

    public void setGlobals(Collection<String> globals) {
        this.globals = globals;
    }

    public void clear() {
        this.process = null;
        this.tasks.clear();
        this.taskInputMappings.clear();
        this.taskOutputMappings.clear();
        this.inputs.clear();
        this.taskAssignments.clear();
        this.reusableSubProcesses.clear();
        this.itemDefinitions.clear();
        this.serviceTasks.clear();
        this.globalItemDefinitions.clear();
        this.referencedClasses.clear();
        this.referencedRules.clear();
    }
}

