/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManagerFactory;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.runtime.ChainableRunner;
import org.jbpm.services.task.assignment.AssignmentServiceProvider;
import org.jbpm.services.task.assignment.impl.AssignmentTaskEventListener;
import org.jbpm.services.task.commands.TaskCommandExecutorImpl;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.identity.DefaultUserInfo;
import org.jbpm.services.task.identity.MvelUserGroupCallbackImpl;
import org.jbpm.services.task.impl.TaskDeadlinesServiceImpl;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskConfigurator.class);
    private static final String DEFAULT_INTERCEPTOR = "org.jbpm.services.task.persistence.TaskTransactionInterceptor";
    private static final String TX_LOCK_INTERCEPTOR = "org.drools.persistence.jta.TransactionLockInterceptor";
    private static final String OPTIMISTIC_LOCK_INTERCEPTOR = "org.drools.persistence.jpa.OptimisticLockRetryInterceptor";
    private static final String ERROR_HANDLING_INTERCEPTOR = "org.jbpm.runtime.manager.impl.error.ExecutionErrorHandlerInterceptor";
    private TaskService service;
    private TaskCommandExecutorImpl commandExecutor;
    private Environment environment = EnvironmentFactory.newEnvironment();
    private UserGroupCallback userGroupCallback;
    private UserInfo userInfo;
    private Set<PriorityInterceptor> interceptors = new TreeSet<PriorityInterceptor>();
    private Set<TaskLifeCycleEventListener> listeners = new HashSet<TaskLifeCycleEventListener>();

    public HumanTaskConfigurator interceptor(int priority, ChainableRunner interceptor) {
        if (interceptor == null) {
            return this;
        }
        this.interceptors.add(new PriorityInterceptor(priority, interceptor));
        return this;
    }

    public HumanTaskConfigurator listener(TaskLifeCycleEventListener listener) {
        if (listener == null) {
            return this;
        }
        this.listeners.add(listener);
        return this;
    }

    public HumanTaskConfigurator environment(Environment environment) {
        if (environment == null) {
            return this;
        }
        this.environment = environment;
        return this;
    }

    public HumanTaskConfigurator entityManagerFactory(EntityManagerFactory emf) {
        if (emf == null) {
            return this;
        }
        this.environment.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)emf);
        return this;
    }

    public HumanTaskConfigurator userInfo(UserInfo userInfo) {
        if (userInfo == null) {
            return this;
        }
        this.userInfo = userInfo;
        return this;
    }

    public HumanTaskConfigurator userGroupCallback(UserGroupCallback userGroupCallback) {
        if (userGroupCallback == null) {
            return this;
        }
        this.userGroupCallback = userGroupCallback;
        return this;
    }

    public TaskService getTaskService() {
        if (this.service == null) {
            TaskEventSupport taskEventSupport = new TaskEventSupport();
            this.commandExecutor = new TaskCommandExecutorImpl(this.environment, taskEventSupport);
            if (this.userGroupCallback == null) {
                this.userGroupCallback = new MvelUserGroupCallbackImpl(true);
            }
            this.environment.set("org.kie.api.task.UserGroupCallback", (Object)this.userGroupCallback);
            if (this.userInfo == null) {
                this.userInfo = new DefaultUserInfo(true);
            }
            this.environment.set("org.kie.api.task.UserInfo", (Object)this.userInfo);
            this.addDefaultInterceptor();
            this.addTransactionLockInterceptor();
            this.addOptimisticLockInterceptor();
            this.addErrorHandlingInterceptor();
            for (PriorityInterceptor pInterceptor : this.interceptors) {
                this.commandExecutor.addInterceptor(pInterceptor.getInterceptor());
            }
            this.service = new CommandBasedTaskService((ExecutableRunner)this.commandExecutor, taskEventSupport);
            for (TaskLifeCycleEventListener listener : this.listeners) {
                ((EventService)this.service).registerTaskEventListener((Object)listener);
            }
            if (AssignmentServiceProvider.get().isEnabled()) {
                ((EventService)this.service).registerTaskEventListener((Object)new AssignmentTaskEventListener());
            }
            if (TaskDeadlinesServiceImpl.getInstance() == null) {
                TaskDeadlinesServiceImpl.initialize((CommandExecutor)this.commandExecutor);
            }
        }
        return this.service;
    }

    protected void addDefaultInterceptor() {
        try {
            Class<?> defaultInterceptorClass = Class.forName(DEFAULT_INTERCEPTOR);
            Constructor<?> constructor = defaultInterceptorClass.getConstructor(Environment.class);
            ChainableRunner defaultInterceptor = (ChainableRunner)constructor.newInstance(this.environment);
            this.interceptor(5, defaultInterceptor);
        }
        catch (Exception e) {
            logger.warn("No default interceptor found of type {} might be mssing jbpm-human-task-jpa module on classpath (error {}", new Object[]{DEFAULT_INTERCEPTOR, e.getMessage(), e});
        }
    }

    protected void addTransactionLockInterceptor() {
        try {
            Class<?> defaultInterceptorClass = Class.forName(TX_LOCK_INTERCEPTOR);
            Constructor<?> constructor = defaultInterceptorClass.getConstructor(Environment.class, String.class);
            ChainableRunner defaultInterceptor = (ChainableRunner)constructor.newInstance(this.environment, "task-service-tx-unlock");
            this.interceptor(6, defaultInterceptor);
        }
        catch (Exception e) {
            logger.warn("No tx lock interceptor found of type {} might be mssing drools-persistence-jpa module on classpath (error {}", new Object[]{TX_LOCK_INTERCEPTOR, e.getMessage(), e});
        }
    }

    protected void addOptimisticLockInterceptor() {
        try {
            Class<?> defaultInterceptorClass = Class.forName(OPTIMISTIC_LOCK_INTERCEPTOR);
            Constructor<?> constructor = defaultInterceptorClass.getConstructor(new Class[0]);
            ChainableRunner defaultInterceptor = (ChainableRunner)constructor.newInstance(new Object[0]);
            this.interceptor(7, defaultInterceptor);
        }
        catch (Exception e) {
            logger.warn("No optimistic lock interceptor found of type {} might be mssing drools-persistence-jpa module on classpath (error {}", new Object[]{OPTIMISTIC_LOCK_INTERCEPTOR, e.getMessage(), e});
        }
    }

    protected void addErrorHandlingInterceptor() {
        try {
            Class<?> defaultInterceptorClass = Class.forName(ERROR_HANDLING_INTERCEPTOR);
            Constructor<?> constructor = defaultInterceptorClass.getConstructor(Environment.class);
            ChainableRunner defaultInterceptor = (ChainableRunner)constructor.newInstance(this.environment);
            this.interceptor(8, defaultInterceptor);
        }
        catch (Exception e) {
            logger.debug("No error handling interceptor found of type {} might be missing jbpm-runtime-manager module on classpath (error {}", new Object[]{ERROR_HANDLING_INTERCEPTOR, e.getMessage(), e});
        }
    }

    private static class PriorityInterceptor
    implements Comparable<PriorityInterceptor> {
        private Integer priority;
        private ChainableRunner interceptor;

        PriorityInterceptor(Integer priority, ChainableRunner interceptor) {
            this.priority = priority;
            this.interceptor = interceptor;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public ChainableRunner getInterceptor() {
            return this.interceptor;
        }

        @Override
        public int compareTo(PriorityInterceptor other) {
            return this.getPriority().compareTo(other.getPriority());
        }

        public String toString() {
            return "PriorityInterceptor [priority=" + this.priority + ", interceptor=" + this.interceptor + "]";
        }
    }
}

