/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionSynchronization;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManagedTransactionDisposeCommand
implements ExecutableCommand<Void> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ContainerManagedTransactionDisposeCommand.class);

    public Void execute(Context context) {
        final KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        logger.debug("Trying to dispose KieSession ({}). Checking for active transactions.", (Object)ksession);
        TransactionManager tm = (TransactionManager)ksession.getEnvironment().get("org.kie.transaction.TransactionManager");
        int txStatus = 3;
        if (tm != null) {
            txStatus = tm.getStatus();
        }
        if (txStatus == 3) {
            logger.debug("No active transaction: disposing KieSession ({}) directly", (Object)ksession);
            ksession.dispose();
            logger.debug("KieSession disposed {}", (Object)ksession);
        } else {
            try {
                logger.debug("Active transaction: registering KieSession ({}) for dispose", (Object)ksession);
                tm.registerTransactionSynchronization(new TransactionSynchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int arg0) {
                        ksession.dispose();
                        logger.debug("KieSession disposed {}", (Object)ksession);
                    }
                });
            }
            catch (Exception e) {
                logger.error("Error while registering transaction synchronization for cmt dispose: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }
}

