/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.base.DefaultKnowledgeHelper;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.TupleSets;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Salience;
import org.drools.core.spi.Tuple;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.MatchCancelledCause;

public class PhreakRuleTerminalNode {
    public void doNode(TerminalNode rtnNode, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(agenda, srcLeftTuples, executor);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(rtnNode, agenda, srcLeftTuples, executor);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(rtnNode, agenda, srcLeftTuples, executor);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(TerminalNode rtnNode, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        int salienceInt = 0;
        Salience salience = ruleAgendaItem.getRule().getSalience();
        if (!salience.isDynamic()) {
            salienceInt = salience.getValue();
            salience = null;
        }
        if (rtnNode.getRule().getAutoFocus() && !ruleAgendaItem.getAgendaGroup().isActive()) {
            agenda.setFocus(ruleAgendaItem.getAgendaGroup());
        }
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftTupleInsert(rtnNode, executor, agenda, ruleAgendaItem, salienceInt, salience, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftTupleInsert(TerminalNode rtnNode, RuleExecutor executor, InternalAgenda agenda, RuleAgendaItem ruleAgendaItem, int salienceInt, Salience salience, LeftTuple leftTuple) {
        PropagationContext pctx = leftTuple.getPropagationContext();
        pctx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, pctx);
        if (rtnNode.getRule().isNoLoop() && rtnNode.equals(pctx.getTerminalNodeOrigin())) {
            return;
        }
        InternalWorkingMemory wm = agenda.getWorkingMemory();
        if (salience != null) {
            salienceInt = salience.getValue(new DefaultKnowledgeHelper((AgendaItem)((Object)leftTuple), wm), (Rule)rtnNode.getRule(), wm);
        }
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)leftTuple;
        agenda.createAgendaItem(rtnLeftTuple, salienceInt, pctx, ruleAgendaItem, ruleAgendaItem.getAgendaGroup());
        InternalWorkingMemory es = wm;
        es.getAgendaEventSupport().fireActivationCreated(rtnLeftTuple, wm);
        if (rtnNode.getRule().isLockOnActive() && leftTuple.getPropagationContext().getType() != PropagationContext.Type.RULE_ADDITION) {
            long handleRecency = pctx.getFactHandle().getRecency();
            InternalAgendaGroup agendaGroup = executor.getRuleAgendaItem().getAgendaGroup();
            if (PhreakRuleTerminalNode.blockedByLockOnActive(rtnNode.getRule(), pctx, handleRecency, agendaGroup)) {
                es.getAgendaEventSupport().fireActivationCancelled(rtnLeftTuple, wm, MatchCancelledCause.FILTER);
                return;
            }
        }
        if (agenda.getActivationsFilter() != null && !agenda.getActivationsFilter().accept(rtnLeftTuple, wm, rtnNode)) {
            return;
        }
        agenda.addItemToActivationGroup(rtnLeftTuple);
        executor.addLeftTuple(leftTuple);
        leftTuple.increaseActivationCountForEvents();
        if (!rtnNode.isFireDirect() && executor.isDeclarativeAgendaEnabled()) {
            agenda.insertAndStageActivation(rtnLeftTuple);
        }
    }

    public void doLeftUpdates(TerminalNode rtnNode, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        RuleAgendaItem ruleAgendaItem = executor.getRuleAgendaItem();
        if (rtnNode.getRule().getAutoFocus() && !ruleAgendaItem.getAgendaGroup().isActive()) {
            agenda.setFocus(ruleAgendaItem.getAgendaGroup());
        }
        int salienceInt = 0;
        Salience salience = ruleAgendaItem.getRule().getSalience();
        if (!salience.isDynamic()) {
            salienceInt = salience.getValue();
            salience = null;
        }
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftTupleUpdate(rtnNode, executor, agenda, salienceInt, salience, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftTupleUpdate(TerminalNode rtnNode, RuleExecutor executor, InternalAgenda agenda, int salienceInt, Salience salience, LeftTuple leftTuple) {
        PropagationContext pctx = leftTuple.getPropagationContext();
        pctx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, pctx);
        boolean blocked = false;
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)leftTuple;
        if (executor.isDeclarativeAgendaEnabled()) {
            if (rtnLeftTuple.getBlockers() != null && !rtnLeftTuple.getBlockers().isEmpty()) {
                blocked = true;
            }
        } else {
            blocked = rtnNode.getRule().isNoLoop() && rtnNode.equals(pctx.getTerminalNodeOrigin());
        }
        InternalWorkingMemory wm = agenda.getWorkingMemory();
        if (salience != null) {
            salienceInt = salience.getValue(new DefaultKnowledgeHelper(rtnLeftTuple, wm), (Rule)rtnNode.getRule(), wm);
        }
        if (agenda.getActivationsFilter() != null && !agenda.getActivationsFilter().accept(rtnLeftTuple, wm, rtnNode)) {
            return;
        }
        if (!blocked) {
            boolean addToExector = true;
            if (rtnNode.getRule().isLockOnActive() && pctx.getType() != PropagationContext.Type.RULE_ADDITION) {
                long handleRecency = pctx.getFactHandle().getRecency();
                InternalAgendaGroup agendaGroup = executor.getRuleAgendaItem().getAgendaGroup();
                if (PhreakRuleTerminalNode.blockedByLockOnActive(rtnNode.getRule(), pctx, handleRecency, agendaGroup)) {
                    addToExector = false;
                }
            }
            if (addToExector && !rtnLeftTuple.isQueued()) {
                InternalWorkingMemory es = wm;
                es.getAgendaEventSupport().fireActivationCreated(rtnLeftTuple, wm);
                rtnLeftTuple.update(salienceInt, pctx);
                executor.addLeftTuple(leftTuple);
                wm.getRuleEventSupport().onUpdateMatch(rtnLeftTuple);
            }
        } else {
            rtnLeftTuple.update(salienceInt, pctx);
        }
        if (!rtnNode.isFireDirect() && executor.isDeclarativeAgendaEnabled()) {
            agenda.modifyActivation(rtnLeftTuple, rtnLeftTuple.isQueued());
        }
    }

    public void doLeftDeletes(InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, RuleExecutor executor) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            PhreakRuleTerminalNode.doLeftDelete(agenda, executor, leftTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void doLeftDelete(InternalAgenda agenda, RuleExecutor executor, Tuple leftTuple) {
        PropagationContext pctx = leftTuple.getPropagationContext();
        pctx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, pctx);
        RuleTerminalNodeLeftTuple rtnLt = (RuleTerminalNodeLeftTuple)leftTuple;
        rtnLt.setMatched(false);
        agenda.cancelActivation(leftTuple, pctx, rtnLt, rtnLt.getTerminalNode());
        if (leftTuple.getMemory() != null) {
            executor.removeLeftTuple(leftTuple);
        }
        leftTuple.setContextObject(null);
    }

    private static boolean blockedByLockOnActive(RuleImpl rule, PropagationContext pctx, long handleRecency, InternalAgendaGroup agendaGroup) {
        if (rule.isLockOnActive()) {
            boolean isActive = agendaGroup.isActive();
            long activatedForRecency = agendaGroup.getActivatedForRecency();
            long clearedForRecency = agendaGroup.getClearedForRecency();
            if (isActive && activatedForRecency < handleRecency && agendaGroup.getAutoFocusActivator() != pctx) {
                return true;
            }
            if (clearedForRecency != -1L && clearedForRecency >= handleRecency) {
                return true;
            }
        }
        return false;
    }
}

