/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin.commands;

import java.util.Arrays;
import java.util.List;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.events.TaskEventSupport;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.runtime.Context;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.model.InternalPeopleAssignments;

public class AddPeopleAssignmentsCommand
extends UserGroupCallbackTaskCommand<Void> {
    private static final long serialVersionUID = -1856489382099976731L;
    private int type;
    private OrganizationalEntity[] entities;
    private boolean removeExisting;

    public AddPeopleAssignmentsCommand(String userId, long taskId, int type, OrganizationalEntity[] entities, boolean removeExisting) {
        this.setUserId(userId);
        this.setTaskId(taskId);
        this.type = type;
        this.entities = entities;
        this.removeExisting = removeExisting;
    }

    public Void execute(Context cntxt) {
        org.jbpm.services.task.commands.TaskContext context = (org.jbpm.services.task.commands.TaskContext)cntxt;
        TaskEventSupport taskEventSupport = context.getTaskEventSupport();
        Task task = context.getTaskQueryService().getTaskInstanceById(this.taskId.longValue());
        if (!this.isBusinessAdmin(this.userId, task.getPeopleAssignments().getBusinessAdministrators(), (TaskContext)context)) {
            throw new PermissionDeniedException("User " + this.userId + " is not business admin of task " + this.taskId);
        }
        List<OrganizationalEntity> entityList = Arrays.asList(this.entities);
        TaskLifeCycleEventListener.AssignmentType assignmentType = null;
        switch (this.type) {
            case 0: {
                if (this.removeExisting) {
                    task.getPeopleAssignments().getPotentialOwners().clear();
                }
                task.getPeopleAssignments().getPotentialOwners().addAll(entityList);
                assignmentType = TaskLifeCycleEventListener.AssignmentType.POT_OWNER;
                break;
            }
            case 1: {
                if (this.removeExisting) {
                    ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners().clear();
                }
                ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners().addAll(entityList);
                assignmentType = TaskLifeCycleEventListener.AssignmentType.EXCL_OWNER;
                break;
            }
            case 2: {
                if (this.removeExisting) {
                    task.getPeopleAssignments().getBusinessAdministrators().clear();
                }
                task.getPeopleAssignments().getBusinessAdministrators().addAll(entityList);
                assignmentType = TaskLifeCycleEventListener.AssignmentType.ADMIN;
                break;
            }
        }
        taskEventSupport.fireBeforeTaskAssignmentsAddedEvent(task, (TaskContext)context, assignmentType, entityList);
        this.doCallbackOperationForPeopleAssignments((InternalPeopleAssignments)task.getPeopleAssignments(), (TaskContext)context);
        taskEventSupport.fireAfterTaskAssignmentsAddedEvent(task, (TaskContext)context, assignmentType, entityList);
        return null;
    }
}

