/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.event.ExecutorEventSupportImpl;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.commands.FindObjectCommand;
import org.jbpm.shared.services.impl.commands.FunctionCommand;
import org.jbpm.shared.services.impl.commands.MergeObjectCommand;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.jbpm.shared.services.impl.commands.RemoveObjectCommand;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.ExecutorStoreService;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Context;

public class JPAExecutorStoreService
implements ExecutorStoreService {
    private EntityManagerFactory emf;
    private CommandExecutor commandService;
    private ExecutorEventSupportImpl eventSupport = new ExecutorEventSupportImpl();

    public JPAExecutorStoreService(boolean active) {
    }

    public void setEventSupport(ExecutorEventSupportImpl eventSupport) {
        this.eventSupport = eventSupport;
    }

    public void setCommandService(CommandExecutor commandService) {
        this.commandService = commandService;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void persistRequest(org.kie.api.executor.RequestInfo request, Consumer<Object> function) {
        this.commandService.execute((Command)new FunctionCommand((ExecutableCommand)new PersistObjectCommand(new Object[]{request}), function));
    }

    public void updateRequest(org.kie.api.executor.RequestInfo request, Consumer<Object> function) {
        this.commandService.execute((Command)new FunctionCommand((ExecutableCommand)new MergeObjectCommand(new Object[]{request}), function));
    }

    public org.kie.api.executor.RequestInfo removeRequest(Long requestId, Consumer<Object> function) {
        return (org.kie.api.executor.RequestInfo)this.commandService.execute((Command)new FunctionCommand((ExecutableCommand)new LockAndCancelRequestInfoCommand(requestId), function));
    }

    public org.kie.api.executor.RequestInfo findRequest(Long id) {
        return (org.kie.api.executor.RequestInfo)this.commandService.execute((Command)new FindObjectCommand((Object)id, RequestInfo.class));
    }

    public void persistError(ErrorInfo error) {
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{error}));
    }

    public void updateError(ErrorInfo error) {
        this.commandService.execute((Command)new MergeObjectCommand(new Object[]{error}));
    }

    public ErrorInfo removeError(Long errorId) {
        ErrorInfo error = this.findError(errorId);
        this.commandService.execute((Command)new RemoveObjectCommand(new Object[]{error}));
        return error;
    }

    public ErrorInfo findError(Long id) {
        return (ErrorInfo)this.commandService.execute((Command)new FindObjectCommand((Object)id, ErrorInfo.class));
    }

    public List<org.kie.api.executor.RequestInfo> loadRequests() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("owner", ExecutorService.EXECUTOR_ID);
        return (List)this.commandService.execute((Command)new QueryNameCommand("LoadPendingRequests", params));
    }

    private class LockAndCancelRequestInfoCommand
    implements ExecutableCommand<org.kie.api.executor.RequestInfo> {
        private static final long serialVersionUID = 8670412133363766161L;
        private Long requestId;

        LockAndCancelRequestInfoCommand(Long requestId) {
            this.requestId = requestId;
        }

        public org.kie.api.executor.RequestInfo execute(Context context) {
            HashMap<String, Number> params = new HashMap<String, Number>();
            params.put("id", this.requestId);
            params.put("firstResult", 0);
            params.put("maxResults", 1);
            org.kie.api.executor.RequestInfo request = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                request = (org.kie.api.executor.RequestInfo)ctx.queryAndLockWithParametersInTransaction("EligibleRequestById", params, true, org.kie.api.executor.RequestInfo.class);
                if (request != null) {
                    request.setStatus(STATUS.CANCELLED);
                    ctx.merge((Object)request);
                }
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            return request;
        }
    }
}

