/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.impl;

import org.drools.core.command.impl.AbstractInterceptor;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.fluent.impl.Batch;
import org.drools.core.fluent.impl.InternalExecutable;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.RequestContext;

public class FireAllRulesInterceptor
extends AbstractInterceptor {
    @Override
    public RequestContext execute(Executable executable, RequestContext ctx) {
        this.executeNext(executable, (Context)ctx);
        if (this.requiresFireAllRules((InternalExecutable)executable)) {
            new FireAllRulesCommand().execute((Context)ctx);
        }
        return ctx;
    }

    protected boolean requiresFireAllRules(InternalExecutable executable) {
        for (Batch batch : executable.getBatches()) {
            for (Command command : batch.getCommands()) {
                if (!this.requiresFireAllRules(command)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean requiresFireAllRules(Command command) {
        return command instanceof AbortWorkItemCommand || command instanceof CompleteWorkItemCommand || command instanceof SignalEventCommand || command instanceof StartProcessCommand || command instanceof StartProcessInstanceCommand;
    }
}

