/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.FactHandleFactory;

public abstract class AbstractFactHandleFactory
implements FactHandleFactory {
    private IdsGenerator idGen;
    private AtomicLong counter;

    public AbstractFactHandleFactory() {
        this.idGen = new IdsGenerator(0);
        this.counter = new AtomicLong(0L);
    }

    public AbstractFactHandleFactory(int id, long counter) {
        this.idGen = new IdsGenerator(id);
        this.counter = new AtomicLong(counter);
    }

    @Override
    public final InternalFactHandle newFactHandle(Object object, ObjectTypeConf conf, InternalWorkingMemory workingMemory, WorkingMemoryEntryPoint wmEntryPoint) {
        return this.newFactHandle(this.getNextId(), object, conf, workingMemory, wmEntryPoint);
    }

    public final InternalFactHandle newFactHandle(int id, Object object, ObjectTypeConf conf, InternalWorkingMemory workingMemory, WorkingMemoryEntryPoint wmEntryPoint) {
        return this.newFactHandle(id, object, this.getNextRecency(), conf, workingMemory, wmEntryPoint);
    }

    @Override
    public abstract InternalFactHandle newFactHandle(int var1, Object var2, long var3, ObjectTypeConf var5, InternalWorkingMemory var6, WorkingMemoryEntryPoint var7);

    @Override
    public final void increaseFactHandleRecency(InternalFactHandle factHandle) {
        factHandle.setRecency(this.getNextRecency());
    }

    @Override
    public void destroyFactHandle(InternalFactHandle factHandle) {
        factHandle.invalidate();
    }

    @Override
    public abstract FactHandleFactory newInstance();

    @Override
    public int getNextId() {
        return this.idGen.getNextId();
    }

    @Override
    public long getNextRecency() {
        return this.counter.incrementAndGet();
    }

    @Override
    public int getId() {
        return this.idGen.getId();
    }

    @Override
    public long getRecency() {
        return this.counter.get();
    }

    @Override
    public void clear(int id, long counter) {
        this.idGen = new IdsGenerator(id);
        this.counter = new AtomicLong(counter);
    }

    @Override
    public void doRecycleIds(Collection<Integer> usedIds) {
        this.idGen.doRecycle(usedIds);
    }

    @Override
    public void stopRecycleIds() {
        this.idGen.stopRecycle();
    }

    private static class IdsGenerator {
        private AtomicInteger id;
        private Queue<Integer> usedIds;
        private int recycledId;

        private IdsGenerator(int startId) {
            this.id = new AtomicInteger(startId);
        }

        public int getNextId() {
            int n;
            if (this.hasRecycledId()) {
                int n2 = this.recycledId;
                n = n2;
                this.recycledId = n2 + 1;
            } else {
                n = this.id.incrementAndGet();
            }
            return n;
        }

        private boolean hasRecycledId() {
            if (this.usedIds != null) {
                while (!this.usedIds.isEmpty()) {
                    int firstUsedId = this.usedIds.peek();
                    if (this.recycledId < firstUsedId) {
                        return true;
                    }
                    if (this.recycledId == firstUsedId) {
                        ++this.recycledId;
                    }
                    this.usedIds.poll();
                }
                this.usedIds = null;
            }
            return false;
        }

        public int getId() {
            return this.id.get();
        }

        public void doRecycle(Collection<Integer> usedIds) {
            this.usedIds = usedIds.stream().sorted().collect(Collectors.toCollection(LinkedList::new));
            this.usedIds.add(this.id.get() + 1);
            this.recycledId = 1;
        }

        public void stopRecycle() {
            this.usedIds = null;
        }
    }
}

