/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PatternSourceDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.drools.compiler.lang.descr.WindowReferenceDescr;
import org.drools.model.WindowDefinition;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseFail;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.ParseResultVisitor;
import org.drools.modelcompiler.builder.generator.drlxparse.SingleDrlxParseSuccess;
import org.drools.mvel.parser.DrlxParser;
import org.drools.mvel.parser.ast.expr.TemporalLiteralChunkExpr;
import org.drools.mvel.parser.ast.expr.TemporalLiteralExpr;
import org.kie.soup.project.datamodel.commons.types.TypeResolver;

public class WindowReferenceGenerator {
    final PackageModel packageModel;
    final TypeResolver typeResolver;

    public WindowReferenceGenerator(PackageModel packageModel, TypeResolver typeResolver) {
        this.packageModel = packageModel;
        this.typeResolver = typeResolver;
    }

    public Optional<Expression> visit(PatternSourceDescr sourceDescr) {
        if (sourceDescr instanceof WindowReferenceDescr) {
            WindowReferenceDescr source = (WindowReferenceDescr)sourceDescr;
            String windowVariable = DrlxParseUtil.toVar(source.getName());
            if (this.packageModel.getWindowReferences().containsKey(windowVariable)) {
                return Optional.of(new NameExpr(windowVariable));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public void addWindowReferences(KnowledgeBuilderImpl kbuilder, Set<WindowDeclarationDescr> windowReferences) {
        for (WindowDeclarationDescr descr : windowReferences) {
            this.addField(kbuilder, this.packageModel, descr);
        }
    }

    private void addField(KnowledgeBuilderImpl kbuilder, PackageModel packageModel, WindowDeclarationDescr descr) {
        String windowName = DrlxParseUtil.toVar(descr.getName());
        MethodCallExpr initializer = new MethodCallExpr(null, "D.window");
        PatternDescr pattern = descr.getPattern();
        ParsedBehavior behavior = pattern.getBehaviors().stream().map(this::parseTypeFromBehavior).findFirst().orElseThrow(RuntimeException::new);
        WindowDefinition.Type windowType = behavior.windowType;
        initializer.addArgument((Expression)new NameExpr(windowType.getDeclaringClass().getCanonicalName() + "." + windowType.toString()));
        initializer.addArgument((Expression)new IntegerLiteralExpr(behavior.duration.getValue()));
        TimeUnit timeUnit = behavior.duration.getTimeUnit();
        initializer.addArgument((Expression)new NameExpr(timeUnit.getDeclaringClass().getCanonicalName() + "." + timeUnit.name()));
        Class<?> initClass = DrlxParseUtil.getClassFromContext(this.typeResolver, pattern.getObjectType());
        Type initType = StaticJavaParser.parseType((String)initClass.getCanonicalName());
        initializer.addArgument((Expression)new ClassExpr(initType));
        if (pattern.getSource() != null) {
            String epName = ((EntryPointDescr)pattern.getSource()).getEntryId();
            MethodCallExpr entryPointCall = new MethodCallExpr(null, "D.entryPoint");
            entryPointCall.addArgument((Expression)new StringLiteralExpr(epName));
            initializer.addArgument((Expression)entryPointCall);
        }
        this.parseConditions(kbuilder, packageModel, pattern, initClass).forEach(arg_0 -> ((MethodCallExpr)initializer).addArgument(arg_0));
        packageModel.addAllWindowReferences(windowName, initializer);
    }

    private List<Expression> parseConditions(KnowledgeBuilderImpl kbuilder, PackageModel packageModel, PatternDescr pattern, Class<?> patternType) {
        List descrs = pattern.getConstraint().getDescrs();
        if (descrs == null) {
            return Collections.emptyList();
        }
        return descrs.stream().map(descr -> {
            String expression = descr.toString();
            RuleContext context = new RuleContext(kbuilder, packageModel, this.typeResolver, true);
            DrlxParseResult drlxParseResult = new ConstraintParser(context, packageModel).drlxParse(patternType, pattern.getIdentifier(), expression);
            return drlxParseResult.acceptWithReturnValue(new ParseResultVisitor<Optional<Expression>>(){

                @Override
                public Optional<Expression> onSuccess(DrlxParseSuccess drlxParseResult) {
                    return Optional.of(DrlxParseUtil.generateLambdaWithoutParameters(((SingleDrlxParseSuccess)drlxParseResult).getUsedDeclarations(), drlxParseResult.getExpr()));
                }

                @Override
                public Optional<Expression> onFail(DrlxParseFail failure) {
                    return Optional.empty();
                }
            });
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private ParsedBehavior parseTypeFromBehavior(BehaviorDescr descr) {
        WindowDefinition.Type windowType = WindowDefinition.Type.valueOf((String)descr.getSubType().toUpperCase());
        TemporalLiteralChunkExpr duration = WindowReferenceGenerator.parseDuration((String)descr.getParameters().get(0));
        ParsedBehavior parsedBehavior = new ParsedBehavior();
        parsedBehavior.windowType = windowType;
        parsedBehavior.duration = duration;
        return parsedBehavior;
    }

    public static TemporalLiteralChunkExpr parseDuration(String duration) {
        TemporalLiteralExpr te = DrlxParser.parseTemporalLiteral((String)duration);
        return (TemporalLiteralChunkExpr)te.getChunks().iterator().next();
    }

    static class ParsedBehavior {
        WindowDefinition.Type windowType;
        TemporalLiteralChunkExpr duration;

        ParsedBehavior() {
        }
    }
}

