/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.expressiontyper;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.util.ArrayList;
import java.util.List;
import org.drools.mvel.parser.ast.expr.InlineCastExpr;
import org.drools.mvel.parser.ast.expr.NullSafeFieldAccessExpr;
import org.drools.mvel.parser.ast.expr.NullSafeMethodCallExpr;

public class FlattenScope {
    public static List<Node> flattenScope(Expression expressionWithScope) {
        ArrayList<Node> res = new ArrayList<Node>();
        if (expressionWithScope instanceof FieldAccessExpr) {
            FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)expressionWithScope;
            res.addAll(FlattenScope.flattenScope(fieldAccessExpr.getScope()));
            res.add((Node)fieldAccessExpr.getName());
        } else if (expressionWithScope instanceof NullSafeFieldAccessExpr) {
            NullSafeFieldAccessExpr fieldAccessExpr = (NullSafeFieldAccessExpr)expressionWithScope;
            res.addAll(FlattenScope.flattenScope(fieldAccessExpr.getScope()));
            res.add((Node)fieldAccessExpr.getName());
        } else if (expressionWithScope instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)expressionWithScope;
            if (methodCallExpr.getScope().isPresent()) {
                res.addAll(FlattenScope.flattenScope((Expression)methodCallExpr.getScope().orElseThrow(() -> new IllegalStateException("Scope expression is not present!"))));
            }
            res.add((Node)methodCallExpr);
        } else if (expressionWithScope instanceof NullSafeMethodCallExpr) {
            NullSafeMethodCallExpr methodCallExpr = (NullSafeMethodCallExpr)expressionWithScope;
            if (methodCallExpr.getScope().isPresent()) {
                res.addAll(FlattenScope.flattenScope((Expression)methodCallExpr.getScope().orElseThrow(() -> new IllegalStateException("Scope expression is not present!"))));
            }
            res.add((Node)methodCallExpr);
        } else if (expressionWithScope instanceof InlineCastExpr && ((InlineCastExpr)expressionWithScope).getExpression() instanceof FieldAccessExpr) {
            InlineCastExpr inlineCastExpr = (InlineCastExpr)expressionWithScope;
            Expression internalScope = ((FieldAccessExpr)inlineCastExpr.getExpression()).getScope();
            res.addAll(FlattenScope.flattenScope(internalScope));
            res.add((Node)expressionWithScope);
        } else if (expressionWithScope instanceof ArrayAccessExpr) {
            ArrayAccessExpr arrayAccessExpr = (ArrayAccessExpr)expressionWithScope;
            res.addAll(FlattenScope.flattenScope(arrayAccessExpr.getName()));
            res.add((Node)arrayAccessExpr);
        } else {
            res.add((Node)expressionWithScope);
        }
        return res;
    }
}

