/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.core.util.Drools;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.builder.AccumulateClassWriter;
import org.drools.modelcompiler.builder.DeclaredTypeWriter;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.PackageModelWriter;
import org.drools.modelcompiler.builder.RuleWriter;
import org.kie.api.builder.ReleaseId;

public class ModelWriter {
    private final String basePath;

    public ModelWriter() {
        this("src/main/java");
    }

    public ModelWriter(String basePath) {
        this.basePath = basePath;
    }

    public Result writeModel(MemoryFileSystem srcMfs, Collection<PackageModel> packageModels) {
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        ArrayList<String> modelFiles = new ArrayList<String>();
        for (PackageModel pkgModel : packageModels) {
            PackageModelWriter packageModelWriter = new PackageModelWriter(pkgModel);
            for (DeclaredTypeWriter declaredType : packageModelWriter.getDeclaredTypes()) {
                generatedFiles.add(new GeneratedFile(declaredType.getName(), declaredType.getSource()));
            }
            for (AccumulateClassWriter accumulateClassWriter : packageModelWriter.getAccumulateClasses()) {
                generatedFiles.add(new GeneratedFile(accumulateClassWriter.getName(), accumulateClassWriter.getSource()));
            }
            RuleWriter rules = packageModelWriter.getRules();
            generatedFiles.add(new GeneratedFile(rules.getName(), rules.getMainSource()));
            modelFiles.add(rules.getClassName());
            for (RuleWriter.RuleFileSource ruleSource : rules.getRuleSources()) {
                generatedFiles.add(new GeneratedFile(ruleSource.getName(), ruleSource.getSource()));
            }
        }
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (GeneratedFile generatedFile : generatedFiles) {
            String path = this.basePath + "/" + generatedFile.getPath();
            sourceFiles.add(path);
            srcMfs.write(path, generatedFile.getData());
        }
        return new Result(sourceFiles, modelFiles);
    }

    private String pojoName(String folderName, String nameAsString) {
        return this.basePath + "/" + folderName + "/" + nameAsString + ".java";
    }

    public void writeModelFile(Collection<String> modelSources, MemoryFileSystem trgMfs, ReleaseId releaseId) {
        String pkgNames = "Drools-Model-Version:" + Drools.getFullVersion() + "\n";
        if (!modelSources.isEmpty()) {
            pkgNames = pkgNames + modelSources.stream().collect(Collectors.joining("\n"));
        }
        trgMfs.write(CanonicalKieModule.getModelFileWithGAV(releaseId), pkgNames.getBytes());
    }

    public static class Result {
        private final List<String> sourceFiles;
        private final List<String> modelFiles;

        public Result(List<String> sourceFiles, List<String> modelFiles) {
            this.sourceFiles = sourceFiles;
            this.modelFiles = modelFiles;
        }

        public String[] getSources() {
            return this.sourceFiles.toArray(new String[this.sourceFiles.size()]);
        }

        public List<String> getSourceFiles() {
            return this.sourceFiles;
        }

        public List<String> getModelFiles() {
            return this.modelFiles;
        }
    }

    private static class GeneratedFile {
        final String path;
        final byte[] data;

        private GeneratedFile(String path, String data) {
            this.path = path;
            this.data = data.getBytes(StandardCharsets.UTF_8);
        }

        private GeneratedFile(String path, byte[] data) {
            this.path = path;
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return "GeneratedFile{path='" + this.path + '\'' + '}';
        }
    }
}

