/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.util.StringUtils;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.Rule;
import org.drools.model.WindowReference;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.generator.DRLIdGenerator;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.QueryGenerator;
import org.drools.modelcompiler.builder.generator.QueryParameter;
import org.drools.modelcompiler.util.StringUtil;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageModel {
    private static final Logger logger = LoggerFactory.getLogger(PackageModel.class);
    public static final String DATE_TIME_FORMATTER_FIELD = "DATE_TIME_FORMATTER";
    public static final String STRING_TO_DATE_METHOD = "string_2_date";
    private static final String RULES_FILE_NAME = "Rules";
    private static final int RULES_DECLARATION_PER_CLASS = 1000;
    private final String name;
    private final boolean isPattern;
    private final DialectCompiletimeRegistry dialectCompiletimeRegistry;
    private final String rulesFileName;
    private Set<String> imports = new HashSet<String>();
    private Set<String> staticImports = new HashSet<String>();
    private Set<String> entryPoints = new HashSet<String>();
    private Map<String, Method> staticMethods;
    private Map<String, Class<?>> globals = new HashMap();
    private Map<String, MethodDeclaration> ruleMethods = new LinkedHashMap<String, MethodDeclaration>();
    private Map<String, MethodDeclaration> queryMethods = new HashMap<String, MethodDeclaration>();
    private Map<String, QueryGenerator.QueryDefWithType> queryDefWithType = new HashMap<String, QueryGenerator.QueryDefWithType>();
    private Map<String, MethodCallExpr> windowReferences = new HashMap<String, MethodCallExpr>();
    private Map<String, List<QueryParameter>> queryVariables = new HashMap<String, List<QueryParameter>>();
    private List<MethodDeclaration> functions = new ArrayList<MethodDeclaration>();
    private List<ClassOrInterfaceDeclaration> generatedPOJOs = new ArrayList<ClassOrInterfaceDeclaration>();
    private List<GeneratedClassWithPackage> generatedAccumulateClasses = new ArrayList<GeneratedClassWithPackage>();
    private List<Expression> typeMetaDataExpressions = new ArrayList<Expression>();
    private DRLIdGenerator exprIdGenerator;
    private KnowledgeBuilderConfigurationImpl configuration;
    private Map<String, AccumulateFunction> accumulateFunctions;
    private InternalKnowledgePackage pkg;
    private final String pkgUUID;
    static final Type WINDOW_REFERENCE_TYPE = StaticJavaParser.parseType((String)WindowReference.class.getCanonicalName());

    public PackageModel(String name, KnowledgeBuilderConfigurationImpl configuration, boolean isPattern, DialectCompiletimeRegistry dialectCompiletimeRegistry, DRLIdGenerator exprIdGenerator) {
        this(null, name, configuration, isPattern, dialectCompiletimeRegistry, exprIdGenerator);
    }

    public PackageModel(ReleaseId releaseId, String name, KnowledgeBuilderConfigurationImpl configuration, boolean isPattern, DialectCompiletimeRegistry dialectCompiletimeRegistry, DRLIdGenerator exprIdGenerator) {
        this.name = name;
        this.pkgUUID = releaseId != null && !releaseId.isSnapshot() ? StringUtil.md5Hash(releaseId.toString() + name) : StringUtils.generateUUID();
        this.isPattern = isPattern;
        this.rulesFileName = RULES_FILE_NAME + this.pkgUUID;
        this.configuration = configuration;
        this.exprIdGenerator = exprIdGenerator;
        this.dialectCompiletimeRegistry = dialectCompiletimeRegistry;
    }

    public String getPackageUUID() {
        return this.pkgUUID;
    }

    public String getRulesFileName() {
        return this.rulesFileName;
    }

    public KnowledgeBuilderConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public String getPathName() {
        return this.name.replace('.', '/');
    }

    public DRLIdGenerator getExprIdGenerator() {
        return this.exprIdGenerator;
    }

    public void addImports(Collection<String> imports) {
        this.imports.addAll(imports);
    }

    public Collection<String> getImports() {
        return this.imports;
    }

    public void addStaticImports(Collection<String> imports) {
        this.staticImports.addAll(imports);
    }

    public void addEntryPoints(Collection<EntryPointDeclarationDescr> entryPoints) {
        entryPoints.stream().map(EntryPointDeclarationDescr::getEntryPointId).forEach(this.entryPoints::add);
    }

    public Collection<String> getStaticImports() {
        return this.staticImports;
    }

    public Method getStaticMethod(String methodName) {
        return this.getStaticMethods().get(methodName);
    }

    private Map<String, Method> getStaticMethods() {
        if (this.staticMethods == null) {
            this.staticMethods = new HashMap<String, Method>();
            block4: for (String i : this.staticImports) {
                if (i.endsWith(".*")) {
                    String className = i.substring(0, i.length() - 2);
                    try {
                        Class importedClass = this.pkg.getTypeResolver().resolveType(className);
                        for (Method m : importedClass.getMethods()) {
                            if (!java.lang.reflect.Modifier.isStatic(m.getModifiers())) continue;
                            this.staticMethods.put(m.getName(), m);
                        }
                        continue;
                    }
                    catch (ClassNotFoundException e1) {
                        throw new UnsupportedOperationException("Class not found", e1);
                    }
                }
                int splitPoint = i.lastIndexOf(46);
                String className = i.substring(0, splitPoint);
                String methodName = i.substring(splitPoint + 1);
                try {
                    Class importedClass = this.pkg.getTypeResolver().resolveType(className);
                    for (Method m : importedClass.getMethods()) {
                        if (!java.lang.reflect.Modifier.isStatic(m.getModifiers()) || !m.getName().equals(methodName)) continue;
                        this.staticMethods.put(methodName, m);
                        continue block4;
                    }
                }
                catch (ClassNotFoundException e1) {
                    throw new UnsupportedOperationException("Class not found", e1);
                }
            }
        }
        return this.staticMethods;
    }

    public void addGlobals(InternalKnowledgePackage pkg) {
        Map<String, Class> transformed = pkg.getGlobals().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            try {
                return pkg.getTypeResolver().resolveType((String)e.getValue());
            }
            catch (ClassNotFoundException e1) {
                throw new UnsupportedOperationException("Class not found", e1);
            }
        }));
        this.globals.putAll(transformed);
    }

    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    public void addTypeMetaDataExpressions(Expression typeMetaDataExpression) {
        this.typeMetaDataExpressions.add(typeMetaDataExpression);
    }

    public void putRuleMethod(String methodName, MethodDeclaration ruleMethod) {
        this.ruleMethods.put(methodName, ruleMethod);
    }

    public void putQueryMethod(MethodDeclaration queryMethod) {
        this.queryMethods.put(queryMethod.getNameAsString(), queryMethod);
    }

    public MethodDeclaration getQueryMethod(String key) {
        return this.queryMethods.get(key);
    }

    public void putQueryVariable(String queryName, QueryParameter qp) {
        this.queryVariables.computeIfAbsent(queryName, k -> new ArrayList());
        this.queryVariables.get(queryName).add(qp);
    }

    public List<QueryParameter> queryVariables(String queryName) {
        return this.queryVariables.get(queryName);
    }

    public Map<String, QueryGenerator.QueryDefWithType> getQueryDefWithType() {
        return this.queryDefWithType;
    }

    public void addAllFunctions(List<MethodDeclaration> functions) {
        this.functions.addAll(functions);
    }

    public void addGeneratedPOJO(ClassOrInterfaceDeclaration pojo) {
        this.generatedPOJOs.add(pojo);
    }

    public List<ClassOrInterfaceDeclaration> getGeneratedPOJOsSource() {
        return this.generatedPOJOs;
    }

    public void addGeneratedAccumulateClasses(GeneratedClassWithPackage clazz) {
        this.generatedAccumulateClasses.add(clazz);
    }

    public List<GeneratedClassWithPackage> getGeneratedAccumulateClasses() {
        return this.generatedAccumulateClasses;
    }

    public void addAllWindowReferences(String methodName, MethodCallExpr windowMethod) {
        this.windowReferences.put(methodName, windowMethod);
    }

    public Map<String, MethodCallExpr> getWindowReferences() {
        return this.windowReferences;
    }

    public List<MethodDeclaration> getFunctions() {
        return this.functions;
    }

    public Map<String, AccumulateFunction> getAccumulateFunctions() {
        return this.accumulateFunctions;
    }

    public void setInternalKnowledgePackage(InternalKnowledgePackage pkg) {
        this.pkg = pkg;
    }

    public InternalKnowledgePackage getPkg() {
        return this.pkg;
    }

    public DialectCompiletimeRegistry getDialectCompiletimeRegistry() {
        return this.dialectCompiletimeRegistry;
    }

    public RuleSourceResult getRulesSource() {
        BodyDeclaration typeMetaDatasList;
        FieldDeclaration field;
        CompilationUnit cu = new CompilationUnit();
        cu.setPackageDeclaration(this.name);
        this.manageImportForCompilationUnit(cu);
        ClassOrInterfaceDeclaration rulesClass = cu.addClass(this.rulesFileName);
        rulesClass.addImplementedType(Model.class);
        BodyDeclaration dateFormatter = StaticJavaParser.parseBodyDeclaration((String)"public final static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.getDateFormatMask(), Locale.ENGLISH);\n");
        rulesClass.addMember(dateFormatter);
        BodyDeclaration string2dateMethodMethod = StaticJavaParser.parseBodyDeclaration((String)("    @Override\n        public String getName() {\n        return \"" + this.name + "\";\n    }\n"));
        rulesClass.addMember(string2dateMethodMethod);
        BodyDeclaration getNameMethod = StaticJavaParser.parseBodyDeclaration((String)"    public static Date string_2_date(String s) {\n        return GregorianCalendar.from(LocalDate.parse(s, DATE_TIME_FORMATTER).atStartOfDay(ZoneId.systemDefault())).getTime();\n    }\n");
        rulesClass.addMember(getNameMethod);
        BodyDeclaration getRulesMethod = StaticJavaParser.parseBodyDeclaration((String)"    @Override\n    public List<org.drools.model.Rule> getRules() {\n        return rules;\n    }\n");
        rulesClass.addMember(getRulesMethod);
        String entryPointsBuilder = this.entryPoints.isEmpty() ? "Collections.emptyList()" : "Arrays.asList(D.entryPoint(\"" + this.entryPoints.stream().collect(Collectors.joining("\"), D.entryPoint(\"")) + "\"))";
        BodyDeclaration getEntryPointsMethod = StaticJavaParser.parseBodyDeclaration((String)("    @Override\n    public List<org.drools.model.EntryPoint> getEntryPoints() {\n        return " + entryPointsBuilder + ";\n    }\n"));
        rulesClass.addMember(getEntryPointsMethod);
        StringBuilder sb = new StringBuilder("\n");
        sb.append("With the following expression ID:\n");
        sb.append(this.exprIdGenerator.toString());
        sb.append("\n");
        JavadocComment exprIdComment = new JavadocComment(sb.toString());
        getRulesMethod.setComment((Comment)exprIdComment);
        BodyDeclaration getGlobalsMethod = StaticJavaParser.parseBodyDeclaration((String)"    @Override\n    public List<org.drools.model.Global> getGlobals() {\n        return globals;\n    }\n");
        rulesClass.addMember(getGlobalsMethod);
        BodyDeclaration getQueriesMethod = StaticJavaParser.parseBodyDeclaration((String)"    @Override\n    public List<org.drools.model.Query> getQueries() {\n        return queries;\n    }\n");
        rulesClass.addMember(getQueriesMethod);
        BodyDeclaration getTypeMetaDataMethod = StaticJavaParser.parseBodyDeclaration((String)"    @Override\n    public List<org.drools.model.TypeMetaData> getTypeMetaDatas() {\n        return typeMetaDatas;\n    }\n");
        rulesClass.addMember(getTypeMetaDataMethod);
        for (Map.Entry<String, MethodCallExpr> entry : this.windowReferences.entrySet()) {
            FieldDeclaration f = rulesClass.addField(WINDOW_REFERENCE_TYPE, entry.getKey(), new Modifier.Keyword[]{Modifier.publicModifier().getKeyword(), Modifier.staticModifier().getKeyword(), Modifier.finalModifier().getKeyword()});
            ((VariableDeclarator)f.getVariables().get(0)).setInitializer((Expression)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getGlobals().entrySet()) {
            PackageModel.addGlobalField(rulesClass, this.getName(), entry.getKey(), (Class)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.queryDefWithType.entrySet()) {
            field = rulesClass.addField((Type)((QueryGenerator.QueryDefWithType)entry.getValue()).getQueryType(), entry.getKey(), new Modifier.Keyword[]{Modifier.publicModifier().getKeyword(), Modifier.staticModifier().getKeyword(), Modifier.finalModifier().getKeyword()});
            ((VariableDeclarator)field.getVariables().get(0)).setInitializer((Expression)((QueryGenerator.QueryDefWithType)entry.getValue()).getMethodCallExpr());
        }
        for (Map.Entry<String, Object> entry : this.queryMethods.entrySet()) {
            field = rulesClass.addField(((MethodDeclaration)entry.getValue()).getType(), entry.getKey(), new Modifier.Keyword[]{Modifier.finalModifier().getKeyword()});
            ((VariableDeclarator)field.getVariables().get(0)).setInitializer((Expression)new MethodCallExpr(null, entry.getKey()));
        }
        InitializerDeclaration rulesListInitializer = new InitializerDeclaration();
        BlockStmt blockStmt = new BlockStmt();
        rulesListInitializer.setBody(blockStmt);
        this.queryMethods.values().forEach(arg_0 -> ((ClassOrInterfaceDeclaration)rulesClass).addMember(arg_0));
        this.buildArtifactsDeclaration(this.queryMethods.keySet(), rulesClass, blockStmt, "org.drools.model.Query", "queries", false);
        this.buildArtifactsDeclaration(this.getGlobals().keySet(), rulesClass, blockStmt, "org.drools.model.Global", "globals", true);
        if (!this.typeMetaDataExpressions.isEmpty()) {
            typeMetaDatasList = StaticJavaParser.parseBodyDeclaration((String)"List<org.drools.model.TypeMetaData> typeMetaDatas = new ArrayList<>();");
            rulesClass.addMember(typeMetaDatasList);
            for (Expression expr : this.typeMetaDataExpressions) {
                this.addInitStatement(blockStmt, expr, "typeMetaDatas");
            }
        } else {
            typeMetaDatasList = StaticJavaParser.parseBodyDeclaration((String)"List<org.drools.model.TypeMetaData> typeMetaDatas = Collections.emptyList();");
            rulesClass.addMember(typeMetaDatasList);
        }
        this.functions.forEach(arg_0 -> ((ClassOrInterfaceDeclaration)rulesClass).addMember(arg_0));
        RuleSourceResult results = new RuleSourceResult(cu);
        int ruleCount = this.ruleMethods.size();
        boolean requiresMultipleRulesLists = ruleCount >= 999;
        MethodCallExpr rules = this.buildRulesField(rulesClass);
        if (requiresMultipleRulesLists) {
            this.addRulesList(blockStmt, "rulesList");
        }
        this.ruleMethods.values().parallelStream().forEach(DrlxParseUtil::transformDrlNameExprToNameExpr);
        int maxLength = this.ruleMethods.values().parallelStream().map(Node::toString).mapToInt(String::length).max().orElse(1);
        int rulesPerClass = Math.max(50000 / maxLength, 1);
        int count = -1;
        LinkedHashMap<Integer, ClassOrInterfaceDeclaration> splitted = new LinkedHashMap<Integer, ClassOrInterfaceDeclaration>();
        for (Map.Entry<String, MethodDeclaration> ruleMethodKV : this.ruleMethods.entrySet()) {
            ClassOrInterfaceDeclaration rulesMethodClass = splitted.computeIfAbsent(++count / rulesPerClass, i -> {
                CompilationUnit cuRulesMethod = new CompilationUnit();
                results.with(cuRulesMethod);
                cuRulesMethod.setPackageDeclaration(this.name);
                this.manageImportForCompilationUnit(cuRulesMethod);
                cuRulesMethod.addImport(this.name + "." + this.rulesFileName, true, true);
                String currentRulesMethodClassName = this.rulesFileName + "RuleMethods" + i;
                return cuRulesMethod.addClass(currentRulesMethodClassName);
            });
            rulesMethodClass.addMember((BodyDeclaration)ruleMethodKV.getValue());
            if (count % 1000 == 999) {
                int index = count / 1000;
                rules = this.buildRulesField(results, index);
                this.addRulesList(blockStmt, this.rulesFileName + RULES_FILE_NAME + index + ".rulesList");
            }
            rules.addArgument((Expression)new MethodCallExpr((Expression)new NameExpr(rulesMethodClass.getNameAsString()), ruleMethodKV.getKey()));
        }
        BodyDeclaration rulesList = requiresMultipleRulesLists ? StaticJavaParser.parseBodyDeclaration((String)("List<org.drools.model.Rule> rules = new ArrayList<>(" + ruleCount + ");")) : StaticJavaParser.parseBodyDeclaration((String)"List<org.drools.model.Rule> rules = rulesList;");
        rulesClass.addMember(rulesList);
        if (!rulesListInitializer.getBody().getStatements().isEmpty()) {
            rulesClass.addMember((BodyDeclaration)rulesListInitializer);
        }
        return results;
    }

    private void buildArtifactsDeclaration(Collection<String> artifacts, ClassOrInterfaceDeclaration rulesClass, BlockStmt rulesListInitializerBody, String type, String fieldName, boolean needsToVar) {
        if (!artifacts.isEmpty()) {
            BodyDeclaration queriesList = StaticJavaParser.parseBodyDeclaration((String)("List<" + type + "> " + fieldName + " = new ArrayList<>();"));
            rulesClass.addMember(queriesList);
            for (String name : artifacts) {
                this.addInitStatement(rulesListInitializerBody, (Expression)new NameExpr(needsToVar ? DrlxParseUtil.toVar(name) : name), fieldName);
            }
        } else {
            BodyDeclaration queriesList = StaticJavaParser.parseBodyDeclaration((String)("List<" + type + "> " + fieldName + " = Collections.emptyList();"));
            rulesClass.addMember(queriesList);
        }
    }

    private void addInitStatement(BlockStmt rulesListInitializerBody, Expression expr, String fieldName) {
        NameExpr rulesFieldName = new NameExpr(fieldName);
        MethodCallExpr add = new MethodCallExpr((Expression)rulesFieldName, "add");
        add.addArgument(expr);
        rulesListInitializerBody.addStatement((Expression)add);
    }

    private void addRulesList(BlockStmt rulesListInitializerBody, String listName) {
        MethodCallExpr add = new MethodCallExpr((Expression)new NameExpr("rules"), "addAll");
        add.addArgument(listName);
        rulesListInitializerBody.addStatement((Expression)add);
    }

    private MethodCallExpr buildRulesField(RuleSourceResult results, int index) {
        CompilationUnit cu = new CompilationUnit();
        results.with(cu);
        cu.setPackageDeclaration(this.name);
        cu.addImport(Arrays.class.getCanonicalName());
        cu.addImport(List.class.getCanonicalName());
        cu.addImport(Rule.class.getCanonicalName());
        String currentRulesMethodClassName = this.rulesFileName + RULES_FILE_NAME + index;
        ClassOrInterfaceDeclaration rulesClass = cu.addClass(currentRulesMethodClassName);
        return this.buildRulesField(rulesClass);
    }

    private MethodCallExpr buildRulesField(ClassOrInterfaceDeclaration rulesClass) {
        MethodCallExpr rulesInit = new MethodCallExpr(null, "Arrays.asList");
        ClassOrInterfaceType rulesType = new ClassOrInterfaceType(null, new SimpleName("List"), new NodeList((Node[])new Type[]{new ClassOrInterfaceType(null, "Rule")}));
        VariableDeclarator rulesVar = new VariableDeclarator((Type)rulesType, "rulesList", (Expression)rulesInit);
        rulesClass.addMember((BodyDeclaration)new FieldDeclaration(NodeList.nodeList((Node[])new Modifier[]{Modifier.publicModifier(), Modifier.staticModifier()}), rulesVar));
        return rulesInit;
    }

    private void manageImportForCompilationUnit(CompilationUnit cu) {
        cu.addImport("java.util.*");
        cu.addImport("org.drools.model.*");
        if (this.isPattern) {
            cu.addImport("org.drools.modelcompiler.dsl.pattern.D");
        } else {
            cu.addImport("org.drools.modelcompiler.dsl.flow.D");
        }
        cu.addImport("org.drools.model.Index.ConstraintType");
        cu.addImport("java.time.*");
        cu.addImport("java.time.format.*");
        cu.addImport("java.text.*");
        cu.addImport("org.drools.core.util.*");
        for (String i : this.imports) {
            if (i.equals(this.name + ".*")) continue;
            cu.addImport(i);
        }
        for (String i : this.staticImports) {
            cu.addImport(i, true, false);
        }
    }

    private static void addGlobalField(ClassOrInterfaceDeclaration classDeclaration, String packageName, String globalName, Class<?> globalClass) {
        ClassOrInterfaceType varType = DrlxParseUtil.toClassOrInterfaceType(Global.class);
        varType.setTypeArguments(new Type[]{DrlxParseUtil.classToReferenceType(globalClass)});
        Type declType = DrlxParseUtil.classToReferenceType(globalClass);
        MethodCallExpr declarationOfCall = new MethodCallExpr(null, "D.globalOf");
        declarationOfCall.addArgument((Expression)new ClassExpr(declType));
        declarationOfCall.addArgument((Expression)new StringLiteralExpr(packageName));
        declarationOfCall.addArgument((Expression)new StringLiteralExpr(globalName));
        FieldDeclaration field = classDeclaration.addField((Type)varType, DrlxParseUtil.toVar(globalName), new Modifier.Keyword[]{Modifier.publicModifier().getKeyword(), Modifier.staticModifier().getKeyword(), Modifier.finalModifier().getKeyword()});
        ((VariableDeclarator)field.getVariables().get(0)).setInitializer((Expression)declarationOfCall);
    }

    public void logRule(String source) {
        if (logger.isDebugEnabled()) {
            logger.debug("=====");
            logger.debug(source);
            logger.debug("=====");
        }
    }

    public void addAccumulateFunctions(Map<String, AccumulateFunction> accumulateFunctions) {
        this.accumulateFunctions = accumulateFunctions;
    }

    public boolean hasDeclaration(String id) {
        return this.globals.get(id) != null;
    }

    public static class RuleSourceResult {
        private final CompilationUnit mainRuleClass;
        private Collection<CompilationUnit> splitted = new ArrayList<CompilationUnit>();

        public RuleSourceResult(CompilationUnit mainRuleClass) {
            this.mainRuleClass = mainRuleClass;
        }

        public CompilationUnit getMainRuleClass() {
            return this.mainRuleClass;
        }

        public RuleSourceResult with(CompilationUnit additionalCU) {
            this.splitted.add(additionalCU);
            return this;
        }

        public Collection<CompilationUnit> getSplitted() {
            return Collections.unmodifiableCollection(this.splitted);
        }
    }
}

