/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.printer.PrettyPrinter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.drools.modelcompiler.builder.JavaParserCompiler;
import org.drools.modelcompiler.builder.PackageModel;

public class RuleWriter {
    private final PrettyPrinter prettyPrinter = JavaParserCompiler.getPrettyPrinter();
    private final CompilationUnit generatedPojo;
    private final PackageModel pkgModel;
    private final String rulesFileName;
    private final PackageModel.RuleSourceResult rulesSource;

    public RuleWriter(String rulesFileName, PackageModel.RuleSourceResult rulesSource, PackageModel pkgModel) {
        this.rulesFileName = rulesFileName;
        this.rulesSource = rulesSource;
        this.generatedPojo = rulesSource.getMainRuleClass();
        this.pkgModel = pkgModel;
    }

    public String getName() {
        return this.pkgModel.getPathName() + "/" + this.rulesFileName + ".java";
    }

    public String getClassName() {
        return this.pkgModel.getName() + "." + this.rulesFileName;
    }

    public String getMainSource() {
        return this.prettyPrinter.print((Node)this.generatedPojo);
    }

    public List<RuleFileSource> getRuleSources() {
        ArrayList<RuleFileSource> rules = new ArrayList<RuleFileSource>();
        for (CompilationUnit cu : this.rulesSource.getSplitted()) {
            Optional classOptional = cu.findFirst(ClassOrInterfaceDeclaration.class);
            if (!classOptional.isPresent()) continue;
            String addFileName = ((ClassOrInterfaceDeclaration)classOptional.get()).getNameAsString();
            rules.add(new RuleFileSource(addFileName, cu));
        }
        return rules;
    }

    public class RuleFileSource {
        protected final CompilationUnit source;
        private final String name;

        private RuleFileSource(String name, CompilationUnit source) {
            this.name = name;
            this.source = source;
        }

        public String getName() {
            return RuleWriter.this.pkgModel.getPathName() + "/" + this.name + ".java";
        }

        public String getSource() {
            String code = RuleWriter.this.prettyPrinter.print((Node)this.source);
            RuleWriter.this.pkgModel.logRule(code);
            return code;
        }
    }
}

