/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.drlxparse;

import com.github.javaparser.ast.expr.BinaryExpr;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.NumberComparisonWithCast;
import org.drools.modelcompiler.builder.generator.drlxparse.NumberComparisonWithoutCast;
import org.drools.modelcompiler.builder.generator.drlxparse.PlainEvaluation;
import org.drools.modelcompiler.builder.generator.drlxparse.StringAsNumber;

abstract class SpecialComparisonCase {
    TypedExpression left;
    TypedExpression right;

    SpecialComparisonCase(TypedExpression left, TypedExpression right) {
        this.left = left;
        this.right = right;
    }

    String getMethodName(BinaryExpr.Operator operator) {
        return "org.drools.modelcompiler.util.EvaluationUtil." + ConstraintParser.operatorToName(operator);
    }

    abstract ConstraintParser.SpecialComparisonResult createCompareMethod(BinaryExpr.Operator var1);

    static SpecialComparisonCase specialComparisonFactory(TypedExpression left, TypedExpression right) {
        if (left.getType() == String.class && right.getType() == String.class) {
            return new StringAsNumber(left, right);
        }
        if (ConstraintParser.isNumber(left).booleanValue() || ConstraintParser.isNumber(right).booleanValue()) {
            Optional<Class<?>> leftCast = SpecialComparisonCase.typeNeedsCast(left.getType());
            Optional<Class<?>> rightCast = SpecialComparisonCase.typeNeedsCast(right.getType());
            if (leftCast.isPresent() || rightCast.isPresent()) {
                return new NumberComparisonWithCast(left, right, leftCast, rightCast);
            }
            return new NumberComparisonWithoutCast(left, right);
        }
        return new PlainEvaluation(left, right);
    }

    private static Optional<Class<?>> typeNeedsCast(Type t) {
        boolean needCast;
        boolean bl = needCast = t.equals(Object.class) || Map.class.isAssignableFrom((Class)t) || List.class.isAssignableFrom((Class)t);
        if (needCast) {
            return Optional.of((Class)t);
        }
        return Optional.empty();
    }

    public TypedExpression getLeft() {
        return this.left;
    }

    public TypedExpression getRight() {
        return this.right;
    }
}

