/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.modelcompiler.builder.AccumulateClassWriter;
import org.drools.modelcompiler.builder.DeclaredTypeWriter;
import org.drools.modelcompiler.builder.GeneratedClassWithPackage;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.RuleWriter;

public class PackageModelWriter {
    private final PackageModel packageModel;
    private final List<DeclaredTypeWriter> declaredTypes;
    private final List<AccumulateClassWriter> accumulateClasses;
    private final RuleWriter ruleWriter;

    public PackageModelWriter(PackageModel packageModel) {
        this.packageModel = packageModel;
        this.declaredTypes = PackageModelWriter.toDeclaredTypeWriters(packageModel);
        this.accumulateClasses = this.toAccumulateClassWriters(packageModel);
        this.ruleWriter = new RuleWriter(packageModel.getRulesFileName(), packageModel.getRulesSource(), packageModel);
    }

    public List<DeclaredTypeWriter> getDeclaredTypes() {
        return this.declaredTypes;
    }

    public List<AccumulateClassWriter> getAccumulateClasses() {
        return this.accumulateClasses;
    }

    public RuleWriter getRules() {
        return this.ruleWriter;
    }

    private List<AccumulateClassWriter> toAccumulateClassWriters(PackageModel packageModel) {
        return packageModel.getGeneratedAccumulateClasses().stream().map(pojo -> new AccumulateClassWriter((GeneratedClassWithPackage)pojo, packageModel)).collect(Collectors.toList());
    }

    private static List<DeclaredTypeWriter> toDeclaredTypeWriters(PackageModel packageModel) {
        return packageModel.getGeneratedPOJOsSource().stream().map(pojo -> new DeclaredTypeWriter((ClassOrInterfaceDeclaration)pojo, packageModel)).collect(Collectors.toList());
    }
}

