/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.drlxparse;

import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.util.Optional;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.TypedExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.SpecialComparisonCase;

class NumberComparisonWithCast
extends SpecialComparisonCase {
    Optional<Class<?>> leftTypeCast;
    Optional<Class<?>> rightTypeCast;

    NumberComparisonWithCast(TypedExpression left, TypedExpression right, Optional<Class<?>> leftTypeCast, Optional<Class<?>> rightTypeCast) {
        super(left, right);
        this.leftTypeCast = leftTypeCast;
        this.rightTypeCast = rightTypeCast;
    }

    @Override
    public ConstraintParser.SpecialComparisonResult createCompareMethod(BinaryExpr.Operator operator) {
        CastExpr castExpr;
        String methodName = this.getMethodName(operator) + "Numbers";
        MethodCallExpr compareMethod = new MethodCallExpr(null, methodName);
        ClassOrInterfaceType numberClass = DrlxParseUtil.toClassOrInterfaceType(Number.class);
        if (this.leftTypeCast.isPresent()) {
            castExpr = new CastExpr((Type)numberClass, this.left.getExpression());
            compareMethod.addArgument((Expression)castExpr);
            this.left = this.right.cloneWithNewExpression((Expression)castExpr);
        } else {
            compareMethod.addArgument(this.left.getExpression());
        }
        if (this.rightTypeCast.isPresent()) {
            castExpr = new CastExpr((Type)numberClass, this.right.getExpression());
            this.right = this.right.cloneWithNewExpression((Expression)castExpr);
            compareMethod.addArgument((Expression)castExpr);
        } else {
            compareMethod.addArgument(this.right.getExpression());
        }
        return new ConstraintParser.SpecialComparisonResult((Expression)compareMethod, this.left, this.right);
    }
}

