/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.builder.generator.visitor.pattern;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PatternSourceDescr;
import org.drools.core.util.ClassUtils;
import org.drools.model.impl.NamesGenerator;
import org.drools.modelcompiler.builder.PackageModel;
import org.drools.modelcompiler.builder.generator.DeclarationSpec;
import org.drools.modelcompiler.builder.generator.DrlxParseUtil;
import org.drools.modelcompiler.builder.generator.RuleContext;
import org.drools.modelcompiler.builder.generator.WindowReferenceGenerator;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintExpression;
import org.drools.modelcompiler.builder.generator.drlxparse.ConstraintParser;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseFail;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseResult;
import org.drools.modelcompiler.builder.generator.drlxparse.DrlxParseSuccess;
import org.drools.modelcompiler.builder.generator.drlxparse.ParseResultVoidVisitor;
import org.drools.modelcompiler.builder.generator.visitor.DSLNode;
import org.drools.modelcompiler.builder.generator.visitor.FromVisitor;
import org.drools.modelcompiler.builder.generator.visitor.pattern.ConstraintOOPath;
import org.drools.modelcompiler.builder.generator.visitor.pattern.PatternConstraintParseResult;
import org.drools.mvel.parser.ast.expr.OOPathExpr;
import org.drools.mvel.parser.printer.PrintUtil;
import org.kie.internal.builder.KnowledgeBuilderResult;

public abstract class PatternDSL
implements DSLNode {
    protected final RuleContext context;
    protected final PackageModel packageModel;
    protected final PatternDescr pattern;
    private final List<? extends BaseDescr> constraintDescrs;
    protected Class<?> patternType;

    PatternDSL(RuleContext context, PackageModel packageModel, PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, Class<?> patternType) {
        this.context = context;
        this.packageModel = packageModel;
        this.pattern = pattern;
        this.constraintDescrs = constraintDescrs;
        this.patternType = patternType;
    }

    public DeclarationSpec initPattern() {
        this.generatePatternIdentifierIfMissing();
        Optional<Expression> declarationSource = this.buildFromDeclaration(this.pattern);
        return this.context.addDeclaration(this.pattern.getIdentifier(), this.patternType, Optional.of(this.pattern), declarationSource);
    }

    private static boolean isPositional(BaseDescr constraint) {
        return constraint instanceof ExprConstraintDescr && ((ExprConstraintDescr)constraint).getType() == ExprConstraintDescr.Type.POSITIONAL && !constraint.getText().contains(":=");
    }

    private Optional<Expression> buildFromDeclaration(PatternDescr pattern) {
        Optional<PatternSourceDescr> source = Optional.ofNullable(pattern.getSource());
        try {
            this.patternType = this.context.getTypeResolver().resolveType(pattern.getObjectType());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Optional<Expression> declarationSourceFrom = source.flatMap(new FromVisitor(this.context, this.packageModel, this.patternType)::visit);
        if (declarationSourceFrom.isPresent()) {
            return declarationSourceFrom;
        }
        return source.flatMap(new WindowReferenceGenerator(this.packageModel, this.context.getTypeResolver())::visit);
    }

    private void generatePatternIdentifierIfMissing() {
        if (this.pattern.getIdentifier() == null) {
            String generatedName = NamesGenerator.generateName((String)("pattern_" + this.patternType.getSimpleName()));
            String patternNameAggregated = this.findFirstInnerBinding(this.constraintDescrs, this.patternType).map(ib -> this.context.getAggregatePatternMap().putIfAbsent((String)ib, generatedName)).orElse(generatedName);
            this.pattern.setIdentifier(patternNameAggregated);
        }
    }

    private Optional<String> findFirstInnerBinding(List<? extends BaseDescr> constraintDescrs, Class<?> patternType) {
        return constraintDescrs.stream().map(constraint -> ConstraintExpression.createConstraintExpression(patternType, constraint, PatternDSL.isPositional(constraint)).getExpression()).map(DrlxParseUtil::parseExpression).filter(drlx -> drlx.getBind() != null).map(drlx -> drlx.getBind().asString()).findFirst();
    }

    private List<PatternConstraintParseResult> findAllConstraint(PatternDescr pattern, List<? extends BaseDescr> constraintDescrs, Class<?> patternType) {
        ConstraintParser constraintParser = new ConstraintParser(this.context, this.packageModel);
        ArrayList<PatternConstraintParseResult> patternConstraintParseResults = new ArrayList<PatternConstraintParseResult>();
        for (BaseDescr baseDescr : constraintDescrs) {
            String patternIdentifier = pattern.getIdentifier();
            boolean isPositional = PatternDSL.isPositional(baseDescr);
            ConstraintExpression constraintExpression = ConstraintExpression.createConstraintExpression(patternType, baseDescr, isPositional);
            DrlxParseResult drlxParseResult = constraintParser.drlxParse(patternType, patternIdentifier, constraintExpression, isPositional);
            String expression = constraintExpression.getExpression();
            if (drlxParseResult.isSuccess() && ((DrlxParseSuccess)drlxParseResult).isRequiresSplit() && ((DrlxParseSuccess)drlxParseResult).getExpr().isBinaryExpr()) {
                BinaryExpr expr = ((DrlxParseSuccess)drlxParseResult).getExpr().asBinaryExpr();
                String leftExpression = PrintUtil.printConstraint((Node)expr.asBinaryExpr().getLeft());
                DrlxParseResult leftExpressionReparsed = constraintParser.drlxParse(patternType, patternIdentifier, leftExpression, isPositional);
                patternConstraintParseResults.add(new PatternConstraintParseResult(leftExpression, patternIdentifier, leftExpressionReparsed));
                String rightExpression = PrintUtil.printConstraint((Node)expr.asBinaryExpr().getRight());
                DrlxParseResult rightExpressionReparsed = constraintParser.drlxParse(patternType, patternIdentifier, rightExpression, isPositional);
                patternConstraintParseResults.add(new PatternConstraintParseResult(rightExpression, patternIdentifier, rightExpressionReparsed));
                continue;
            }
            patternConstraintParseResults.add(new PatternConstraintParseResult(expression, patternIdentifier, drlxParseResult));
        }
        return patternConstraintParseResults;
    }

    void buildConstraint(final PatternDescr pattern, final Class<?> patternType, final PatternConstraintParseResult patternConstraintParseResult) {
        DrlxParseResult drlxParseResult1 = patternConstraintParseResult.getDrlxParseResult();
        final String expression = patternConstraintParseResult.getExpression();
        drlxParseResult1.accept(new ParseResultVoidVisitor(){

            @Override
            public void onSuccess(DrlxParseSuccess drlxParseResult) {
                DSLNode constraint = drlxParseResult.getExpr() instanceof OOPathExpr ? new ConstraintOOPath(PatternDSL.this.context, PatternDSL.this.packageModel, pattern, patternType, patternConstraintParseResult, expression, drlxParseResult) : PatternDSL.this.createSimpleConstraint(drlxParseResult, pattern);
                constraint.buildPattern();
                PatternDSL.this.registerUsedBindingInOr(drlxParseResult.getExprBinding());
            }

            @Override
            public void onFail(DrlxParseFail failure) {
                if (failure.getError() != null) {
                    PatternDSL.this.context.addCompilationError((KnowledgeBuilderResult)failure.getError());
                }
            }
        });
    }

    private void registerUsedBindingInOr(String exprBinding) {
        if (this.context.isNestedInsideOr().booleanValue()) {
            this.context.getBindingOr().add((Object)exprBinding);
        }
    }

    @Override
    public void buildPattern() {
        DeclarationSpec declarationSpec = this.initPattern();
        if (this.constraintDescrs.isEmpty() && !(this.pattern.getSource() instanceof AccumulateDescr)) {
            this.context.addExpression((Expression)this.input(declarationSpec));
        } else {
            List<PatternConstraintParseResult> patternConstraintParseResults = this.findAllConstraint(this.pattern, this.constraintDescrs, this.patternType);
            List<String> allBindings = patternConstraintParseResults.stream().map(p -> p.getDrlxParseResult().acceptWithReturnValue(DrlxParseSuccess::getExprBinding)).filter(Objects::nonNull).collect(Collectors.toList());
            DrlxParseUtil.validateDuplicateBindings(this.context.getRuleName(), allBindings).ifPresent(this.context::addCompilationError);
            if (!this.context.hasErrors()) {
                this.buildPattern(declarationSpec, patternConstraintParseResults);
            }
        }
    }

    Set<String> getSettableWatchedProps() {
        HashSet<String> watchedProps = new HashSet<String>();
        watchedProps.addAll(this.context.getRuleDescr().lookAheadFieldsOfIdentifier(this.pattern));
        watchedProps.addAll(DrlxParseUtil.getPatternListenedProperties(this.pattern));
        if (watchedProps.isEmpty()) {
            return watchedProps;
        }
        List settableProps = ClassUtils.getAccessibleProperties(this.patternType);
        HashSet<String> settableWatchedProps = new HashSet<String>();
        for (String watchedProp : watchedProps) {
            String actualProp = watchedProp.startsWith("!") ? watchedProp.substring(1) : watchedProp;
            if (!settableProps.contains(actualProp)) continue;
            settableWatchedProps.add(watchedProp);
        }
        return settableWatchedProps;
    }

    protected abstract void buildPattern(DeclarationSpec var1, List<PatternConstraintParseResult> var2);

    protected abstract MethodCallExpr input(DeclarationSpec var1);

    protected abstract DSLNode createSimpleConstraint(DrlxParseSuccess var1, PatternDescr var2);
}

