/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.core.ast.ItemDefNode;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.compiler.DMNTypeRegistryV11;
import org.kie.dmn.core.compiler.DMNTypeRegistryV12;
import org.kie.dmn.core.pmml.DMNImportPMMLInfo;
import org.kie.dmn.core.util.DefaultDMNMessagesManager;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_1.TDefinitions;

public class DMNModelImpl
implements DMNModel,
DMNMessageManager,
Externalizable {
    private SerializationFormat serializedAs = SerializationFormat.DMN_XML;
    private Resource resource;
    private Definitions definitions;
    private Map<String, InputDataNode> inputs = new HashMap<String, InputDataNode>();
    private Map<String, DecisionNode> decisions = new HashMap<String, DecisionNode>();
    private Map<String, BusinessKnowledgeModelNode> bkms = new HashMap<String, BusinessKnowledgeModelNode>();
    private Map<String, ItemDefNode> itemDefs = new HashMap<String, ItemDefNode>();
    private Map<String, DecisionServiceNode> decisionServices = new HashMap<String, DecisionServiceNode>();
    private DMNMessageManager messages = new DefaultDMNMessagesManager();
    private DMNTypeRegistry types;
    private boolean runtimeTypeCheck = false;
    private Map<String, QName> importAliases = new HashMap<String, QName>();
    private ImportChain importChain;
    private Map<String, DMNImportPMMLInfo> pmmlImportInfo = new HashMap<String, DMNImportPMMLInfo>();

    public DMNModelImpl() {
    }

    public DMNModelImpl(Definitions definitions) {
        this.definitions = definitions;
        this.wireTypeRegistry(definitions);
        this.importChain = new ImportChain(this);
    }

    public DMNModelImpl(Definitions dmndefs, Resource resource) {
        this(dmndefs);
        this.setResource(resource);
    }

    private void wireTypeRegistry(Definitions definitions) {
        this.types = definitions instanceof TDefinitions ? new DMNTypeRegistryV11() : new DMNTypeRegistryV12();
    }

    public DMNTypeRegistry getTypeRegistry() {
        return this.types;
    }

    public String getNamespace() {
        return this.definitions != null ? this.definitions.getNamespace() : null;
    }

    public String getName() {
        return this.definitions != null ? this.definitions.getName() : null;
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Definitions definitions) {
        this.definitions = definitions;
    }

    public String nameInCurrentModel(DMNNode node) {
        if (node.getModelNamespace().equals(this.getNamespace())) {
            return node.getName();
        }
        Optional<String> lookupAlias = this.getImportAliasFor(node.getModelNamespace(), node.getModelName());
        if (lookupAlias.isPresent()) {
            return lookupAlias.get() + "." + node.getName();
        }
        return null;
    }

    public void addInput(InputDataNode idn) {
        this.inputs.put(this.computeDRGElementModelLocalId((DMNNode)idn), idn);
    }

    public InputDataNode getInputById(String id) {
        return this.inputs.get(id);
    }

    public InputDataNode getInputByName(String name) {
        if (name == null) {
            return null;
        }
        for (InputDataNode in : this.inputs.values()) {
            if (!Objects.equals(name, this.nameInCurrentModel((DMNNode)in))) continue;
            return in;
        }
        return null;
    }

    public Set<InputDataNode> getInputs() {
        return this.inputs.values().stream().collect(Collectors.toSet());
    }

    public void addDecision(DecisionNode dn) {
        this.decisions.put(this.computeDRGElementModelLocalId((DMNNode)dn), dn);
    }

    private String computeDRGElementModelLocalId(DMNNode node) {
        if (node.getModelNamespace().equals(this.definitions.getNamespace())) {
            return node.getId();
        }
        return node.getModelNamespace() + "#" + node.getId();
    }

    public DecisionNode getDecisionById(String id) {
        return this.decisions.get(id);
    }

    public DecisionNode getDecisionByName(String name) {
        if (name == null) {
            return null;
        }
        for (DecisionNode dn : this.decisions.values()) {
            if (!Objects.equals(name, this.nameInCurrentModel((DMNNode)dn))) continue;
            return dn;
        }
        return null;
    }

    public Set<DecisionNode> getDecisions() {
        return this.decisions.values().stream().collect(Collectors.toSet());
    }

    public Set<InputDataNode> getRequiredInputsForDecisionName(String decisionName) {
        DecisionNodeImpl decision = (DecisionNodeImpl)this.getDecisionByName(decisionName);
        HashSet<InputDataNode> inputs = new HashSet<InputDataNode>();
        if (decision != null) {
            this.collectRequiredInputs(decision.getDependencies().values(), inputs);
        }
        return inputs;
    }

    public Set<InputDataNode> getRequiredInputsForDecisionId(String decisionId) {
        DecisionNodeImpl decision = (DecisionNodeImpl)this.getDecisionById(decisionId);
        HashSet<InputDataNode> inputs = new HashSet<InputDataNode>();
        if (decision != null) {
            this.collectRequiredInputs(decision.getDependencies().values(), inputs);
        }
        return inputs;
    }

    public void addDecisionService(DecisionServiceNode dsn) {
        this.decisionServices.put(this.computeDRGElementModelLocalId((DMNNode)dsn), dsn);
    }

    public DecisionServiceNode getDecisionServiceById(String id) {
        return this.decisionServices.get(id);
    }

    public DecisionServiceNode getDecisionServiceByName(String name) {
        if (name == null) {
            return null;
        }
        for (DecisionServiceNode dn : this.decisionServices.values()) {
            if (!Objects.equals(name, dn.getName())) continue;
            return dn;
        }
        return null;
    }

    public Collection<DecisionServiceNode> getDecisionServices() {
        return this.decisionServices.values().stream().collect(Collectors.toSet());
    }

    public void addBusinessKnowledgeModel(BusinessKnowledgeModelNode bkm) {
        this.bkms.put(this.computeDRGElementModelLocalId((DMNNode)bkm), bkm);
    }

    public BusinessKnowledgeModelNode getBusinessKnowledgeModelById(String id) {
        return this.bkms.get(id);
    }

    public BusinessKnowledgeModelNode getBusinessKnowledgeModelByName(String name) {
        if (name == null) {
            return null;
        }
        for (BusinessKnowledgeModelNode bkm : this.bkms.values()) {
            if (!Objects.equals(name, bkm.getName())) continue;
            return bkm;
        }
        return null;
    }

    public Set<BusinessKnowledgeModelNode> getBusinessKnowledgeModels() {
        return this.bkms.values().stream().collect(Collectors.toSet());
    }

    private void collectRequiredInputs(Collection<DMNNode> deps, Set<InputDataNode> inputs) {
        deps.forEach(dep -> {
            if (dep instanceof InputDataNode) {
                inputs.add((InputDataNode)dep);
            } else if (dep instanceof DecisionNode) {
                this.collectRequiredInputs(((DecisionNodeImpl)dep).getDependencies().values(), inputs);
            } else if (dep instanceof BusinessKnowledgeModelNode) {
                this.collectRequiredInputs(((BusinessKnowledgeModelNodeImpl)dep).getDependencies().values(), inputs);
            }
        });
    }

    public void addItemDefinition(ItemDefNode idn) {
        this.itemDefs.put(idn.getId() != null ? idn.getId() : "_" + this.itemDefs.size(), idn);
    }

    public ItemDefNode getItemDefinitionById(String id) {
        return this.itemDefs.get(id);
    }

    public ItemDefNode getItemDefinitionByName(String name) {
        if (name == null) {
            return null;
        }
        for (ItemDefNode in : this.itemDefs.values()) {
            if (!Objects.equals(name, in.getName())) continue;
            return in;
        }
        return null;
    }

    public Set<ItemDefNode> getItemDefinitions() {
        return this.itemDefs.values().stream().collect(Collectors.toSet());
    }

    public List<DMNMessage> getMessages() {
        return this.messages.getMessages();
    }

    public List<DMNMessage> getMessages(DMNMessage.Severity ... sevs) {
        return this.messages.getMessages(sevs);
    }

    public boolean hasErrors() {
        return this.messages.hasErrors();
    }

    @Override
    public void addAll(List<? extends DMNMessage> messages) {
        this.messages.addAll(messages);
    }

    @Override
    public DMNMessage addMessage(DMNMessage msg) {
        return this.messages.addMessage(msg);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source) {
        return this.messages.addMessage(severity, message, messageType, source);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, Throwable exception) {
        return this.messages.addMessage(severity, message, messageType, source, exception);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, FEELEvent feelEvent) {
        return this.messages.addMessage(severity, message, messageType, source, feelEvent);
    }

    public boolean removeDMNNodeFromIndexes(DMNNode node) {
        if (node instanceof DecisionNode) {
            return this.decisions.entrySet().removeIf(kv -> ((DecisionNode)kv.getValue()).equals(node));
        }
        if (node instanceof BusinessKnowledgeModelNode) {
            return this.bkms.entrySet().removeIf(kv -> ((BusinessKnowledgeModelNode)kv.getValue()).equals(node));
        }
        if (node instanceof InputDataNode) {
            return this.inputs.entrySet().removeIf(kv -> ((InputDataNode)kv.getValue()).equals(node));
        }
        return false;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isRuntimeTypeCheck() {
        return this.runtimeTypeCheck;
    }

    public void setRuntimeTypeCheck(boolean runtimeTypeCheck) {
        this.runtimeTypeCheck = runtimeTypeCheck;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.serializedAs);
        out.writeObject(this.resource);
        if (!(out instanceof DroolsObjectOutputStream)) {
            throw new UnsupportedOperationException();
        }
        DroolsObjectOutputStream os = (DroolsObjectOutputStream)out;
        DMNCompilerImpl compiler = (DMNCompilerImpl)os.getCustomExtensions().get("DMN_COMPILER_CACHE_KEY");
        List<DMNExtensionRegister> dmnRegisteredExtensions = compiler.getRegisteredExtensions();
        String output = DMNMarshallerFactory.newMarshallerWithExtensions(dmnRegisteredExtensions).marshal((Object)this.definitions);
        out.writeObject(output);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Definitions definitions;
        this.serializedAs = (SerializationFormat)((Object)in.readObject());
        this.resource = (Resource)in.readObject();
        String xml = (String)in.readObject();
        if (!(in instanceof DroolsObjectInputStream)) {
            throw new UnsupportedOperationException();
        }
        DroolsObjectInputStream is = (DroolsObjectInputStream)in;
        DMNCompilerImpl compiler = (DMNCompilerImpl)is.getCustomExtensions().get("DMN_COMPILER_CACHE_KEY");
        List<DMNExtensionRegister> dmnRegisteredExtensions = compiler.getRegisteredExtensions();
        this.definitions = definitions = DMNMarshallerFactory.newMarshallerWithExtensions(dmnRegisteredExtensions).unmarshal(xml);
        this.wireTypeRegistry(definitions);
        DMNModelImpl compiledModel = (DMNModelImpl)compiler.compile(definitions);
        this.inputs = compiledModel.inputs;
        this.decisions = compiledModel.decisions;
        this.bkms = compiledModel.bkms;
        this.itemDefs = compiledModel.itemDefs;
        this.messages = compiledModel.messages;
        this.types = compiledModel.types;
        this.runtimeTypeCheck = compiledModel.runtimeTypeCheck;
        this.importAliases = compiledModel.importAliases;
    }

    public void setImportAliasForNS(String iAlias, String iNS, String iModelName) {
        if (!this.getImportAliasFor(iNS, iModelName).isPresent()) {
            this.importAliases.put(iAlias, new QName(iNS, iModelName));
        }
    }

    public Map<String, QName> getImportAliasesForNS() {
        return Collections.unmodifiableMap(this.importAliases);
    }

    public Optional<String> getImportAliasFor(String ns, String iModelName) {
        QName lookup = new QName(ns, iModelName);
        return this.importAliases.entrySet().stream().filter(kv -> ((QName)kv.getValue()).equals(lookup)).map(kv -> (String)kv.getKey()).findFirst();
    }

    public QName getImportNamespaceAndNameforAlias(String iAlias) {
        return this.importAliases.get(iAlias);
    }

    public void addImportChainChild(ImportChain child, String alias) {
        this.importChain.children.add(ImportChain.from(child, alias));
    }

    public ImportChain getImportChain() {
        return this.importChain;
    }

    public Map<String, Collection<List<String>>> getImportChainAliases() {
        return this.importChain.getImportChainAliases();
    }

    @Override
    public void addAllUnfiltered(List<? extends DMNMessage> messages) {
        this.messages.addAllUnfiltered(messages);
    }

    public void addPMMLImportInfo(DMNImportPMMLInfo info) {
        this.pmmlImportInfo.put(info.getImportName(), info);
    }

    public Map<String, DMNImportPMMLInfo> getPmmlImportInfo() {
        return Collections.unmodifiableMap(this.pmmlImportInfo);
    }

    private static class ImportChain {
        private final String alias;
        private final DMNModel node;
        private final List<ImportChain> children = new ArrayList<ImportChain>();

        public ImportChain(DMNModel node) {
            this(node, null);
        }

        private ImportChain(DMNModel node, String alias) {
            this.alias = alias;
            this.node = node;
        }

        public static ImportChain from(ImportChain from, String alias) {
            ImportChain result = new ImportChain(from.node, alias);
            result.children.addAll(from.children);
            return result;
        }

        public Map<String, Collection<List<String>>> getImportChainAliases() {
            HashMap<String, Collection<List<String>>> result = new HashMap<String, Collection<List<String>>>();
            for (ImportChain l : this.children) {
                Map<String, Collection<List<String>>> leafResult = l.getImportChainAliases();
                for (Map.Entry<String, Collection<List<String>>> kv : leafResult.entrySet()) {
                    Collection allPrefixesUnderNamespace = result.computeIfAbsent(kv.getKey(), k -> new ArrayList());
                    for (List<String> ps : kv.getValue()) {
                        ArrayList<String> prefixed = new ArrayList<String>();
                        if (this.alias != null) {
                            prefixed.add(this.alias);
                        }
                        prefixed.addAll(ps);
                        allPrefixesUnderNamespace.add(prefixed);
                    }
                }
            }
            if (this.alias != null) {
                Collection allPrefixesUnderMyNamespace = result.computeIfAbsent(this.node.getNamespace(), k -> new ArrayList());
                allPrefixesUnderMyNamespace.add(Arrays.asList(this.alias));
            }
            return result;
        }
    }

    private static enum SerializationFormat {
        DMN_XML;

    }
}

