/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RuntimeManagerFactory
extends org.kie.api.runtime.manager.RuntimeManagerFactory {

    public static class Factory {
        private static RuntimeManagerFactory INSTANCE;
        private static Logger logger;

        public static RuntimeManagerFactory get() {
            if (INSTANCE == null) {
                throw new RuntimeException("RuntimeManagerFactory was not initialized, see previous errors");
            }
            return INSTANCE;
        }

        static {
            logger = LoggerFactory.getLogger(Factory.class);
            try {
                final Object delegate = Class.forName(System.getProperty("org.jbpm.runtime.manager.class", "org.jbpm.runtime.manager.impl.RuntimeManagerFactoryImpl")).newInstance();
                INSTANCE = (RuntimeManagerFactory)Proxy.newProxyInstance(RuntimeManagerFactory.class.getClassLoader(), new Class[]{RuntimeManagerFactory.class}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
                        return method.invoke(delegate, arguments);
                    }
                });
            }
            catch (Exception e) {
                logger.error("Unable to instance RuntimeManagerFactory due to " + e.getMessage());
            }
        }
    }
}

