/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment.impl.strategy;

import java.util.Date;
import java.util.TreeSet;
import org.drools.core.ClassObjectFilter;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.task.TaskContext;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.assignment.Assignment;
import org.kie.internal.task.api.assignment.AssignmentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessRuleAssignmentStrategy
implements AssignmentStrategy {
    private static final Logger logger = LoggerFactory.getLogger(BusinessRuleAssignmentStrategy.class);
    private static final String IDENTIFIER = "BusinessRule";
    private boolean active = "BusinessRule".equals(System.getProperty("org.jbpm.task.assignment.strategy"));
    private String releaseId = System.getProperty("org.jbpm.task.assignment.rules.releaseId");
    private String scannerInterval = System.getProperty("org.jbpm.task.assignment.rules.scan");
    private KieServices kieServices = KieServices.Factory.get();
    private KieContainer kieContainer;
    private KieScanner kieScanner;

    public BusinessRuleAssignmentStrategy() {
        if (this.active) {
            if (this.releaseId == null) {
                throw new IllegalArgumentException("BusinessRule assignment strategy requires release id to be given via system property 'org.jbpm.task.assignment.rules.releaseId'");
            }
            String[] gav = this.releaseId.split(":");
            logger.debug("Creating KieContainer for {} to be used for task assignments", (Object)this.releaseId);
            this.kieContainer = this.kieServices.newKieContainer(this.kieServices.newReleaseId(gav[0], gav[1], gav[2]));
            if (this.scannerInterval != null) {
                Long pollingInterval = Long.parseLong(this.scannerInterval);
                logger.debug("Scanner to be enabled for {} container with polling interval set to {}", (Object)this.kieContainer, (Object)pollingInterval);
                this.kieScanner = this.kieServices.newKieScanner(this.kieContainer);
                this.kieScanner.start(pollingInterval.longValue());
                logger.debug("Scanner for container {} started at {}", (Object)this.kieContainer, (Object)new Date());
            }
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Assignment apply(Task task, TaskContext context, String excludedUser) {
        if (!this.active) {
            logger.debug("{} strategy is not active", (Object)this);
            return null;
        }
        logger.debug("Using rules to assign actual owner to task {}", (Object)task);
        KieSession kieSession = this.kieContainer.newKieSession();
        try {
            Object results;
            context.loadTaskVariables(task);
            kieSession.insert((Object)task);
            kieSession.fireAllRules();
            TreeSet assignments = new TreeSet();
            String queryName = System.getProperty("org.jbpm.task.assignment.rules.query");
            if (queryName != null) {
                logger.debug("Query {} is going to be used to retrieve results from working memory", (Object)queryName);
                results = kieSession.getQueryResults(queryName, new Object[0]);
                results.forEach(row -> assignments.add((Assignment)row.get("assignment")));
            } else {
                logger.debug("No query defined, retrieving all facts of type Assignment");
                results = kieSession.getObjects((ObjectFilter)new ClassObjectFilter(Assignment.class));
                assignments.addAll(results);
            }
            logger.debug("Rule evaluation completed with selected assignments of {}", assignments);
            if (assignments.isEmpty()) {
                logger.debug("No assignments found by BusinessRule strategy");
                results = null;
                return results;
            }
            Assignment selected = (Assignment)assignments.iterator().next();
            logger.debug("Selected assignment is {} for task {}", (Object)selected, (Object)task);
            Assignment assignment = selected;
            return assignment;
        }
        finally {
            kieSession.dispose();
            logger.debug("KieSession in BusinessRule disposed");
        }
    }

    public String toString() {
        return "BusinessRuleAssignmentStrategy [releaseId=" + this.releaseId + "]";
    }
}

